#!/bin/sh
#-----------------------------------------------------------------------------
#                                                                 2.1.7
# /usr/local/htdocs/main_ISDNFaxe.cgi - display received faxes from OPT_FAXRCV
#
# Creation:     28.09.2003  felix
# Last Update:  $Id: main_ISDNFaxe.cgi,v 1.6 2004/04/19 19:23:47 felix Exp $
#-----------------------------------------------------------------------------

eval "`proccgi $*`"
# access values using $FORM_name

# This script can be called with the following parameters
# ----------------------------------------------------------------------------
# Parameter    | Value                    | Meaning
# ----------------------------------------------------------------------------
# action       | showtab                  | Show the tab "item"
#              | deletefax                | Delete the fax in "item"
#              | viewfax                  | Display fax in "item" in browser
#              | downloadfax              | Download fax in "item"
#              | start, stop              | Start or stop the capifaxrcvd
# item         | depening on action       | The item "action" should process
# page         | number                   | Used in conjunction with viewfax
#              |                          | Returns given page as JPG

## sanity-check the input
FORM_action=`/bin/echo "$FORM_action" | /usr/bin/sed "s/[^a-zA-Z]//g"`
FORM_item=`/bin/echo "$FORM_item" | /usr/bin/sed "s/[^-_+.a-zA-Z0-9]//g"`
FORM_page=`/bin/echo "$FORM_page" | /usr/bin/sed "s/[^0-9]//g"`

## seclib-abfrage
SEC_REALM='isdnfax'
if [ "x$FORM_action" = "xdeletefax" ]
then
  SEC_ACTION='delete'
elif [ "x$FORM_action" = "xstart" -o "x$FORM_action" = "xstop" -o ]
then
  SEC_ACTION='startstop'
else
  SEC_ACTION='view'
fi
. ./sec-lib.cgi

## interne variablen
. /var/run/fax.conf
THISFILE="$0"
MENU_ITEMS="Faxe An-Aus"

if [ "$FAXRCV_IMONC_LIST" = "0" ]
then
  ACTIVE_NUMBER="$FAXRCV_HTTPGUI_USER"
else
  ACTIVE_NUMBER="$FAXRCV_IMONC_LIST"
fi

eval FAXDIR='$FAXRCV_'$ACTIVE_NUMBER'_DIRECTORY'
MFAX_LOG="$FAXDIR""/mfax.log"
CONVERTDIR="$FAXDIR/converttemp"
CONVERTNAME="fax"

## fallback
if [ "x$FORM_action" = "x" ]
then
  FORM_action="showtab"
fi

if [ "x$FORM_action" = "xshowtab" ]
then
  if [ "x$FORM_item" = "x" ]
  then
    MENU_SELECTED="Faxe"
  else
    MENU_SELECTED="$FORM_item"
  fi

  /bin/echo "Content-Type: text/html; charset=iso-8859-1"
  /bin/echo "Cache-control: no-cache"   # HTTP/1.1
  /bin/echo "Pragma: no-cache"          # HTTP/1.0
  /bin/echo
  /bin/echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">
<html><head>
<!-- 
######
# Created by $Id: main_ISDNFaxe.cgi,v 1.6 2004/04/19 19:23:47 felix Exp $
# Part of OPT_FAXRCV, (c) Felix Eckhofer <felix@tribut.de>
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License (GPL) as published by
# the Free Software Foundation; either version 2 of the License, or (at
# your option) any later version. 
######
-->
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">
<title>faxrcv :: http-gui (2.1.7)</title>
<link rel=\"stylesheet\" type=\"text/css\" href=\"faxrcv.css\">
</head>

<body>
<!-- HEADER  -->
<table class=\"headertable\"><tr><td><form name=\"num_select\">Faxnummer:
<select name=\"number\" class=\"inputs\">
<option>default</option>
</select></form></td><td align=\"right\">
faxrcv-Weboberflche (2.1.7)
</td></tr></table>
<!-- MENU -->
<table class=\"menutable\"><tr>"

  for MENU_ITEM in $MENU_ITEMS
  do
    if [ "x$MENU_ITEM" = "x$MENU_SELECTED" ]
    then
      /bin/echo "<td class=\"menuitemselected\">"
      /bin/echo "<span class=\"menulink\">$MENU_ITEM</span>"
    else
      /bin/echo "<td class=\"menuitem\">"
      /bin/echo "<a class=\"menulink\"
href=\"$THISFILE?action=showtab&item=$MENU_ITEM\">$MENU_ITEM</a>"
    fi
  done

  /bin/echo "</td></tr></table>
<!-- CONTENT -->
<table class=\"contenttable\">"

  case $MENU_SELECTED in
    Faxe)
      if [ -f "$MFAX_LOG" ] ; then
        /bin/echo "<tr class="listheader">
<td>
  Datum/Zeit
</td><td>
  Fax-ID
</td><td>
  Seiten
</td><td>
  Datei
</td><td>
  Aktionen
</td></tr>"

        /usr/bin/sed '1!G;h;$!d' "$MFAX_LOG" | while read d z i p f
        do
	  # + is not allowed in QUERY_STRING but in filenames
	  qf=`/bin/echo "$f" | /usr/bin/sed "s/\+/%2B/g"`
	  # "_" is a replacement for " "
	  # i=`/bin/echo "$i" | /usr/bin/sed "s/_/\&nbsp;/g"`
          /bin/echo "<tr class=\"listitem$ITERATE\">
<td align=\"center\">$d/$z</td>
<td><b>$i</b></td>
<td align=\"center\">$p</td>
<td>$f</td>
<td align=\"center\">"
          if [ "$FAXRCV_HTTPGUI_CONVERT" = "yes" ]
	  then
	    /bin/echo "  <a href=\"$THISFILE?action=viewfax&item=$qf\"><img 
      src=\"fax_view.gif\" border=0 width=21 height=16
      alt=\"Ansehen\" title=\"Ansehen\"></a>"
          fi
	  /bin/echo "  <a href=\"$THISFILE?action=downloadfax&item=$qf\"><img 
      src=\"fax_download.gif\" border=0 width=21 height=16
      alt=\"Download\" title=\"Download\"></a>
  <a href=\"$THISFILE?action=deletefax&item=$qf\"><img
      src=\"fax_delete.gif\" border=0 width=21 height=16
      alt=\"Lschen\" title=\"Lschen\"></a>
</td>
</tr>"

          if [ "$ITERATE" = "" ]
          then
            ITERATE="2"
          else
            ITERATE=""
          fi
        done
      else
        /bin/echo "<tr><td>Keine Faxe</td></tr>"
      fi
      ;;
    An-Aus)
      /bin/echo "<tr><td>&nbsp;</td></tr>"
      /bin/echo "<tr class=\"listheader\"><td>Faxempfang ist"
      if /bin/ps -ax|/usr/bin/grep capifaxrcvd|/usr/bin/grep -v grep >/dev/null
      then
        /bin/echo "<span class=\"faxrcvon\">AN</span>"
      else
        /bin/echo "<span class=\"faxrcvoff\">AUS</span>"
      fi
      /bin/echo "</td></tr><tr><td align=\"center\">
[<a href=\"$THISFILE?action=start\">einschalten</a>]&nbsp;
[<a href=\"$THISFILE?action=stop\">ausschalten</a>]
</td></tr>"
      ;;
    *)
      /bin/echo "<tr><td>What the?</td></tr>"
      ;;
  esac

  /bin/echo "</table></body></html>"

elif [ "x$FORM_action" = "xdeletefax" ]
then
  VALID_FILE="0"
  while read d z i p f
  do
    if [ "$f" = "$FORM_item" ]
    then
      VALID_FILE="1"
      break
    fi
  done < "$MFAX_LOG"

  if [ "$VALID_FILE" = "1" ]
  then
    /bin/rm -f "$FAXDIR"/"$FORM_item".gz
    if [ "$?" = 0 -o ! -f "$FAXDIR"/"$FORM_item".gz ]
    then
      # escape "." (see sanity-check above)
      FORM_item=`/bin/echo $FORM_item | /usr/bin/sed 's/\./\\\./g'`
      # remove the line corresponding with the deleted file
      /usr/bin/sed "/ $FORM_item\$/d" "$MFAX_LOG" > $FAXDIR/mfax.tmp
      # replace mfax.log
      /bin/mv "$FAXDIR/mfax.tmp" "$MFAX_LOG"
    fi
  fi
  
  /bin/echo "Location: $THISFILE"
  /bin/echo

elif [ "x$FORM_action" = "xviewfax" ]
then
  if [ "x$FORM_page" = "x" ]
  then
    # convert the fax and
    # show the page where all the images are included
    /bin/mkdir -p $CONVERTDIR
    /bin/rm -f "$CONVERTDIR/$CONVERTNAME"*

    if [ -f "$FAXDIR"/"$FORM_item".gz ]
    then
      /usr/local/bin/gzip -cd "$FAXDIR"/"$FORM_item".gz > $CONVERTDIR/$CONVERTNAME.sff 2>/dev/console
      # creates $CONVERTDIR/$CONVERTNAME.001.jpg $CONVERTNAME.002.jpg etc.
      /usr/local/bin/sff2misc -j "$CONVERTDIR/$CONVERTNAME.sff" "$CONVERTDIR/$CONVERTNAME" >/dev/console 2>&1

      /bin/echo "Content-Type: text/html; charset=iso-8859-1"
      /bin/echo "Cache-control: no-cache"   # HTTP/1.1
      /bin/echo "Pragma: no-cache"          # HTTP/1.0
      /bin/echo
      /bin/echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">
<html><head>
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">
<title>faxrcv :: http-gui (2.1.7)</title>
<link rel=\"stylesheet\" type=\"text/css\" href=\"faxrcv.css\">
</head><body>"
      
      INFOLINE=`/usr/bin/grep "$FORM_item" $MFAX_LOG`
      if [ "x$INFOLINE" = "x" ]
      then
        /bin/echo "<h1>Not found</h1>
The file $FORM_item was not found in $MFAX_LOG"
      else
	/bin/echo "<h1 class=\"faxpagehead\">$FORM_item</h1>"
        # d z i p f
        set -- $INFOLINE
	NUM_PAGES="$4"
        idx="1"
	while [ "$idx" -le "$NUM_PAGES" ]
	do
	  /bin/echo "<div class=\"faxpagenum\">Seite $idx</div><br>"
	  /bin/echo "<div class=\"faxpage\"><a
href=\"$THISFILE?action=viewfax&item=&page=$idx\"
target=\"_blank\"><img align=\"center\"
src=\"$THISFILE?action=viewfax&item=&page=$idx\"
alt=\"Seite $idx\" width=\"500\"
border=\"0\"></a></div>"
          idx=`/usr/bin/expr $idx + 1`
	done
      fi

      /bin/echo "</body></html>" 
    else
      # we dont have that file...
      /bin/echo "Location: $THISFILE"
      /bin/echo
    fi
  else
    # return a specific page as JPG
    PADDED_PAGE=`/bin/echo "000$FORM_page" | /usr/bin/sed "s/.*\([0-9]\{3\}\)/\1/"`
    /bin/echo "Content-Type: image/jpeg"
    /bin/echo
    /bin/cat "$CONVERTDIR/$CONVERTNAME.$PADDED_PAGE.jpg"    
  fi

elif [ "x$FORM_action" = "xdownloadfax" ]
then
  if [ -f "$FAXDIR/$FORM_item.gz" ]
  then
    /bin/echo "Content-Type: application/download"
    /bin/echo "Content-Disposition: attachment; filename=$FORM_item"
    /bin/echo
    /usr/local/bin/gzip -cd "$FAXDIR/$FORM_item.gz"
  else
    /bin/echo "Location: $THISFILE"
    /bin/echo
  fi

elif [ "x$FORM_action" = "xstart" ]
then
  /usr/local/bin/faxrcv.sh start > /dev/console 2>&1
  /bin/echo "Location: $THISFILE?action=showtab&item=An-Aus"
  /bin/echo
elif [ "x$FORM_action" = "xstop" ]
then
  /usr/local/bin/faxrcv.sh stop > /dev/console 2>&1
  /bin/echo "Location: $THISFILE?action=showtab&item=An-Aus"
  /bin/echo
else
  /bin/echo "Location: $THISFILE"
  /bin/echo
fi

