#----------------------------------------------------------------------------
# /usr/local/bin/newfax.sh - process received faxes              2.1.7
#
# Creation:     28.09.2003  felix
# Last Update:  $Id: newfax.sh,v 1.4 2004/04/18 10:11:26 felix Exp $
#----------------------------------------------------------------------------

gzip < "$2" > "$2.sff.gz"

if [ "$?" = 0 ]
then
        rm "$2"
else
        # remove the damaged file just to be sure
        rm -f "$2.sff.gz"
        # rename the file to make it recognizeable
        mv "$2" "$2.sff"
        # and output a warning
        /usr/local/bin/colecho "newfax.sh: ERROR gzipping the file $2! Probably not enough memory?" br x br
fi

if [ "$FAXRCV_DIRECTORY" != "" ]
then
        SENDER=`echo $1 | cut -c 14-`
        PAGES=`echo $1 | cut -c 3-5 | sed 's/^[0]*//'`
        if [ "$SENDER" = "" ] ; then
            SENDER="?"
        fi
        LANGDATUM=`/bin/date +%d.%m.%y`
        LANGZEIT=`/bin/date +%H:%M:%S`
        echo "$LANGDATUM $LANGZEIT $SENDER $PAGES $2.sff" >> $FAXRCV_DIRECTORY/mfax.log
fi

idx=1
while [ "$idx" -le "$FAXRCV_NTFYCMD_N" ]
do
        eval ntfycmd='$FAXRCV_NTFYCMD'_$idx
	$ntfycmd "$FAXRCV_DIRECTORY/$2.sff.gz"
	idx=`/usr/bin/expr $idx + 1`
done

