#! /bin/sh
#----------------------------------------------------------------------------
# mklinks.sh
#
# usage: /pathname/mklinks.sh source-tree dest-tree
#
# example: /etc/mklinks.sh /opt/files /
#
# start always with absolute pathname!
#----------------------------------------------------------------------------

pgm=$0
source=$1
dest=$2

cd $source

for j in *
do
    if [ -d $j -a -d $dest/$j ]
    then
        sh $pgm $source/$j $dest/$j
    elif [ ! -f $dest/$j ]
    then
        ln -s $source/$j $dest/$j
    fi
done
