#!/bin/sh
##-----------------------------------------------------------------------------
## opt/file/usr/local/htdocs/main_e2compr.cgi
##
## Creation:     28.03.2004
## Last Update:  09.05.2004
##
## Copyright (c) 2004 Ruediger Otte <ruediger dot otte at gmx dot net>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##-----------------------------------------------------------------------------

SEC_REALM='status'
SEC_ACTION='view'

. ./sec-lib.cgi

echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store" # HTTP/1.1 (or no-cache?)
echo "Pragma: no-cache"        # HTTP/1.0
echo "Expires: `date -Ru`"     # Expires now!
echo
echo '<html>'
echo '<head>'
echo ' <LINK REL=STYLESHEET TYPE="text/css" HREF="main.css">'
echo ' <title>e2compr</title>'
echo '</head>'
echo '<body bgcolor="#FFFFFF" text="#000000">'

echo '<h2>Ext2-Komprimierung</h2>'
echo '<hr>'

# import configuration
if [ -f /var/run/e2compr.cfg ]
then
   . /var/run/e2compr.cfg
else
   . /boot/rc.cfg
fi

echo '<ul>'
echo '<li>'

if [ "$E2COMPR_OPT_OK" = "yes" ]
then
   echo '<b>OPT-Komprimierung aktiviert.</b>'
else
   echo '<b>OPT-Komprimierung nicht aktiviert.</b>'
fi

echo '</li>'
echo '<li>'

if [ "1" -le "$E2COMPR_RD_N" ]
then
   echo '<b>Komprimierte Ramdisks konfiguriert.</b>'
else
   echo '<b>Keine komprimierten Ramdisks konfiguriert.</b>'
fi

echo '</li>'
echo '<li>'

if [ "$E2COMPR_KERNEL" = "yes" ]
then
   echo '<b>Kernel untersttzt Ext2-Komprimierung.</b>'
   echo '</li>'
   echo '</ul>'

   echo '<table border=1>'
   echo '<tr align="right">'
   echo '<td align="left">Typ</td>'
   echo '<td align="left">Pfad</td>'
   echo '<td>Algorithmus</td>'
   echo '<td>Unkomprimiert (Kb)</td>'
   echo '<td>Komprimiert (Kb)</td>'
   echo '<td>Komprimierung</td>'
   echo '</tr>'

   if [ "$E2COMPR_OPT" = "yes" ]
   then
      echo '<tr align="right">'
      echo '<td align="left">OPT</td>'
      echo '<td align="left">'
      echo "/opt"
      echo '</td>'

      # check if ramdisk state is ok
      if [ "$E2COMPR_OPT_OK" = "yes" ]
      then
         echo '<td>'

         # get compression algorithm
         /bin/lsattr -d /opt | cut -f3 -d" "
         echo '</td>'

         # hopefully sync attributes
         /bin/lsattr -R /opt 1> /dev/null
         # get e2ratio
         /usr/bin/e2ratio -s /opt > /tmp/e2c.tmp

         while read unkomprimiert komprimiert komprimierung pfad
         do
            echo "<td>$unkomprimiert</td>"
            echo "<td align="right">$komprimiert</td>"
            echo "<td align="right">$komprimierung</td>"
         done < /tmp/e2c.tmp

      else
         echo '<td>N/A</td>'
         echo '<td>N/A</td>'
         echo '<td>N/A</td>'
         echo '<td>N/A</td>'
      fi

      echo '</tr>'
   fi

   if [ "1" -le "$E2COMPR_RD_N" ]
   then
      # set internal counter
      idx=1
      while [ "$idx" -le "$E2COMPR_RD_N" ]
      do

         # get variables
         eval e2compr_rd_path='$E2COMPR_RD_'$idx'_PATH'
         eval e2compr_rd_ok='$E2COMPR_RD_'$idx'_OK'

         echo '<tr align="right">'
         echo '<td align="left">Ramdisk</td>'
         echo '<td align="left">'
         echo "$e2compr_rd_path"
         echo '</td>'

         # check if ramdisk state is ok
         if [ "$e2compr_rd_ok" = "yes" ]
         then
            echo '<td>'
            # get compression algorithm
            /bin/lsattr -d "$e2compr_rd_path" | cut -f3 -d" "
            echo '</td>'

            # hopefully sync attributes
            /bin/lsattr -R "$e2compr_rd_path" 1> /dev/null
            # get e2ratio if this ramdisk
            /usr/bin/e2ratio -s "$e2compr_rd_path" > /tmp/e2c.tmp

            while read unkomprimiert komprimiert komprimierung pfad
            do
               echo "<td>$unkomprimiert</td>"
               echo "<td align="right">$komprimiert</td>"
               echo "<td align="right">$komprimierung</td>"
            done < /tmp/e2c.tmp

         else
            echo '<td>N/A</td>'
            echo '<td>N/A</td>'
            echo '<td>N/A</td>'
            echo '<td>N/A</td>'
         fi

         echo '</tr>'
         # raise internal counter
         idx=`/usr/bin/expr $idx + 1`

      done

   fi

   echo '</table>'

else
   echo '<b>OPT_E2COMPR bentigt einen modifizierten Kernel!</b>'
   echo '</li>'
   echo '</ul>'
fi

echo '<br>'

echo '<table border=1>'
echo '<tr align="right">'
echo '<td align="left">Device</td>'
echo '<td>Gre (Kb)</td>'
echo '<td>Belegt (Kb)</td>'
echo '<td>Frei (Kb)</td>'
echo '<td>Nutzung</td>'
echo '<td align="left">Mountpunkt</td>'
echo '</tr>'

df | grep "/dev/ram" > /tmp/e2c.tmp

while read device groesse belegt frei nutzung mountpunkt
do
   echo "<tr align=right>"
   echo "<td align="left">$device</td>"
   echo "<td>$groesse</td>"
   echo "<td>$belegt</td>"
   echo "<td>$frei</td>"
   echo "<td>$nutzung</td>"
   echo "<td align="left">$mountpunkt</td>"
   echo "</tr>"
done < /tmp/e2c.tmp

echo '</table>'

echo '<br>'
echo '<hr>'

echo '<p><small>OPT_E2COMPR 0.7-pre1 fr FLI4L 2.1.7: Rdiger Otte &lt;ruediger dot otte at gmx dot net&gt;</small></p>'
echo '</body>'
echo '</html>'
exit 0
