#!/bin/sh
#---------------------------------------------------------------------------------------------
# /usr/local/htdocs/main_Timelog.cgi     OPT_TIMELOG      v.0.7
#
# Creation:        02.10.2004  Enrico Troeger <troeger@fh-coburg.de>
# Last Update:     03.01.2005  Enrico Troeger <troeger@fh-coburg.de>
#----------------------------------------------------------------------------------------------

# Variablen belegen
myname=`basename $0`
TLname="main_Timelog.cgi"
#TableWidth=600
if [ -f /var/run/timelog.conf ]
then
    . /var/run/timelog.conf
fi

# Zeit-Rechnen-Funktion
count() {
    h=`echo "$ot_i / 3600" | /usr/local/bin/bc`
    m=`echo "($ot_i / 60) % 60" | /usr/local/bin/bc`
    if [ "$h" -le "9" ]
    then
        h="0$h"
    fi
    if [ "$m" -le "9" ]
    then
        m="0$m"
    fi
    title="$h:$m"
    return 0
}

# Parameter parsen
for var in `echo "$QUERY_STRING" | tr '&' ' '`
do
    if echo "$var" | grep -v "=" > /dev/null ; then var="$var=yes" ; fi
    eval "P_$var"
done

# Daten berechnen
JAHR=$P_jahr
THIS_JAHR=`date +%Y`
MONAT=`date +%m`
TAG=`date +%d`

NAME_MONAT_01="Januar"
NAME_MONAT_02="Februar"
NAME_MONAT_03="M&auml;rz"
NAME_MONAT_04="April"
NAME_MONAT_05="Mai"
NAME_MONAT_06="Juni"
NAME_MONAT_07="Juli"
NAME_MONAT_08="August"
NAME_MONAT_09="September"
NAME_MONAT_10="Oktober"
NAME_MONAT_11="November"
NAME_MONAT_12="Dezember"
    

echo "Content-Type: text/html; charset=iso-8859-1"
echo
echo "<html><head>"
echo "<LINK REL=STYLESHEET TYPE=\"text/css\" HREF=\"main.css\">"
echo "<title>TimeLog</title></head>"
echo "<body alink=\"#0000FF\" vlink=\"#0000FF\" link=\"#0000FF\">"
echo "<b>OPT_TIMELOG</b><br><br>"

if [ -f "/tmp/timelog.lock" ]
then
     echo "<br><center><small>Neuberechnung der Daten l&auml;uft gerade. Bitte einen Moment warten.</small></center>"
     echo "<center><small><a href=\"http://mysite.fh-coburg.de/~troeger/fli4l/\" target=\"_blank\">OPT_TimeLog</a> $TIMELOG_VER by Enrico Tr&ouml;ger</small></center>"
     echo "</body></html>"
     exit
fi

# Circuit-Wahl
if [ -n "$ISDN_CIRCUITS_N" ]
then
    echo "Bitte Circuit w&auml;hlen:&nbsp;"
    i=1
    while [ $i -le "$ISDN_CIRCUITS_N" ];
    do
        echo "<a href=\"$myname?circuit=`eval echo '$ISDN_CIRC_'${i}_NAME`&jahr=$P_jahr&monat=$P_monat&tag=$P_tag\">`eval echo '$ISDN_CIRC_'${i}_NAME`</a>&nbsp;&nbsp;"
        i=`expr $i + 1`
    done
    echo "<a href=\"$myname?circuit=all&jahr=$P_jahr&monat=$P_monat&tag=$P_tag\">Alle</a><br><br>"
fi

# Circuit-Wahl
if [ -n "$P_circuit" ]
then
        if [ -z "$P_circuit" ]
        then
            CIRCUIT="all"
            ANZ_CIRCUIT="Alle"
        else
            CIRCUIT="$P_circuit"
            if [ "$P_circuit" = "all" ]
            then
                ANZ_CIRCUIT="Alle"
            else
                ANZ_CIRCUIT="$P_circuit"
            fi
        fi
else
        if [ "$TIMELOG_CIRCUIT" -gt "0" ]
        then
            CIRCUIT=`eval echo '$ISDN_CIRC_'${TIMELOG_CIRCUIT}_NAME`
            ANZ_CIRCUIT="$CIRCUIT"
        else
            CIRCUIT="all"
            ANZ_CIRCUIT="Alle"
        fi
fi

# Tages-Ausgabe
if [ "$P_monat" -gt "0" -a "$P_tag" -gt "0" ]
then
    echo "grafische Tagesanzeige f&uuml;r $P_tag.$P_monat.$P_jahr (f&uuml;r Circuit: $ANZ_CIRCUIT)<br><br><table>"
    file="$IMOND_LOGDIR/imond.log"
    cir=""
    if [ "$CIRCUIT" != "all" ]
    then
        cir="$CIRCUIT"
    fi
    conn_count=0
    i=0
    max=1
    sum=0
    GES_OT=0
    tmp="$P_jahr/$P_monat/$P_tag"
    
    for string in `grep "$cir[ ]*$tmp" "$file" | sed 's/^[ ]*\([^ ]\+\)[ ]\+\([^ ]\+\)[ ]\+\([^ ]\+\)[ ]\+[^ ]\+[ ]\+\([^ ]\+\)[ ]\+\([^ ]\+\)[ ]\+[^ ]\+[ ]\+[^ ]\+[ ]\+[^ ]\+[ ]\+\([^ ]\+\)[ ]\+[^ ]\+[ ]\+\([^ ]\+\).*$/\3_\4_\5/'`
    do
        tmp2=`echo "$string" | cut -d '_' -f 3`
        tmp3=`echo "$string" | cut -d '_' -f 1 | cut -d ':' -f 1,2`
        tmp4=`echo "$string" | cut -d '_' -f 2 | cut -d ':' -f 1,2`
        eval "OT"$conn_count"="$tmp2
        eval "SZ"$conn_count"="$tmp3
        eval "EZ"$conn_count"="$tmp4
        if [ $tmp2 -gt $max ]
        then
            max=$tmp2
        fi
        sum=`expr $sum + $tmp2`
        conn_count=`expr $conn_count + 1`
    done
   
    echo "<tr><!-- conn_count: $conn_count max: $max -->"
    for string in `grep "$cir[ ]*$tmp" "$file" | sed 's/^[ ]*\([^ ]\+\)[ ]\+\([^ ]\+\)[ ]\+\([^ ]\+\)[ ]\+[^ ]\+[ ]\+\([^ ]\+\)[ ]\+\([^ ]\+\)[ ]\+[^ ]\+[ ]\+[^ ]\+[ ]\+[^ ]\+[ ]\+\([^ ]\+\)[ ]\+[^ ]\+[ ]\+\([^ ]\+\).*$/\3_\4_\5/'`
    do
        echo -n "<td align=\"center\" valign=\"bottom\"><img src=\"timelog_bar.gif\" height=\""
        eval 'ot_i=$OT'${i}
        eval 'START=$SZ'${i}
        eval 'ENDE=$EZ'${i}
        count
        ot_i_k=`echo "($ot_i * 350) / $max" | /usr/local/bin/bc`
        echo -n $ot_i_k"\" width=\"15\" title=\"$START-$ENDE: $title h\"><br>$START</td>"
        i=`expr $i + 1`
    done
    # Durchschnitt berechnen
    ot_i=`echo "$sum / $conn_count" | /usr/local/bin/bc`
    ot_i_k=`echo "($ot_i * 350) / $max" | /usr/local/bin/bc`
    count
    # Rest ausgeben
    echo "<td align=\"center\" valign=\"bottom\"><img src=\"timelog_bar.gif\" height=\"$ot_i_k\" width=\"15\" title=\"Durchschnitt: $title h\" ><br>&#248;</td></tr></table>"
    echo "<br><br><a href=\"$TLname?circuit=$P_circuit&jahr=0&monat=0&tag=0\">Zur&uuml;ck</a>"
    echo "<a href=\"$TLname?circuit=$P_circuit&jahr=$P_jahr&monat=$P_monat&tag=$P_tag\">Daten</a>"
fi


# Monats-Ausgabe
if [ "$P_monat" -gt "0" -a "$P_tag" = "0" ]
then
    eval 'NAME_MONAT=$NAME_MONAT_'${P_monat}
    echo "grafische Monatsanzeige f&uuml;r $NAME_MONAT $P_jahr (f&uuml;r Circuit: $ANZ_CIRCUIT)<br><br><table>"
    case "$P_monat" in
        01|03|05|07|08|10|12 )        MAXDAYS=31;;
        04|06|09|11 )                 MAXDAYS=30;;
        02 )                          MAXDAYS=28;;
    esac
    # im aktuellen Monat nur bis zum heutigen Tag berechnen, weil von morgen gibt es ja noch keine Daten ;-)
    if [ "$P_monat" = "$MONAT" ]
    then
        MAXDAYS=$TAG
    fi
    i=1
    max=1
    sum=0
    GES_OT=0
    for i in $(seq 1 $MAXDAYS)
    do
        if [ "$i" -le "9" ]
        then
            tmp=0$i
        else
            tmp=$i
        fi
        tmp2=`/usr/local/bin/timelog.sh -Z $P_jahr/$P_monat/$tmp $CIRCUIT seconds`
        eval "OT"$i"="$tmp2
        eval "TAG"$i"="$tmp
        if [ $tmp2 -gt $max ]
        then
            max=$tmp2
        fi
        sum=`expr $sum + $tmp2`
    done
    
    echo "<tr><!-- $max -->"
    i=1
    for i in $(seq 1 $MAXDAYS)
    do
        echo -n "<td valign=\"bottom\"><img src=\"timelog_bar.gif\" height=\""
        eval 'ot_i=$OT'${i}
        eval 'DAY=$TAG'${i}
        count
        ot_i_k=`echo "($ot_i * 350) / $max" | /usr/local/bin/bc`
        echo -n $ot_i_k"\" width=\"15\" title=\"$DAY.$P_monat.$P_jahr: $title h\"><br>"
        if [ "$ot_i_k" -gt "0" ]
        then
            echo "<a href=\"$TLname?circuit=$P_circuit&jahr=$P_jahr&monat=$P_monat&tag=$DAY\">$DAY</a>"
        else
            echo -n "$DAY"
        fi
        echo "</td>"
    done
    # Durchschnitt berechnen
    ot_i=`echo "$sum / $MAXDAYS" | /usr/local/bin/bc`
    ot_i_k=`echo "($ot_i * 350) / $max" | /usr/local/bin/bc`
    count
    # Rest ausgeben
    echo "<td align=\"center\" valign=\"bottom\"><img src=\"timelog_bar.gif\" height=\"$ot_i_k\" width=\"15\" title=\"Durchschnitt: $title h\" ><br>&#248;</td></tr></table>"
    echo "<br><br><a href=\"$TLname?circuit=$P_circuit&jahr=0&monat=0&tag=0\">Zur&uuml;ck</a>"
    echo "<a href=\"$TLname?circuit=$P_circuit&jahr=$P_jahr&monat=$P_monat&tag=0\">Daten</a>"
fi


# Jahres-Ansicht
if [ "$P_jahr" -gt "0" -a "$P_monat" = "0" ]
then
    eval 'NAME_MONAT=$NAME_MONAT_'${tmp}
    echo "grafische Jahresansicht f&uuml;r $P_jahr (f&uuml;r Circuit: $ANZ_CIRCUIT)<br><br><table>"
    # im aktuellen Jahr nur bis zum aktuellen Monat berechnen, weil vom n�hsten Monat gibt es ja noch keine Daten ;-)
    if [ "$P_jahr" = "$THIS_JAHR" ]
    then
        MAX_MONAT=$MONAT
    else
        MAX_MONAT=12
    fi
    max=1
    sum=0
    GES_OT=0
    for i in $(seq 1 $MAX_MONAT)
    do
        if [ "$i" -le "9" ]
        then
            tmp=0$i
        else
            tmp=$i
        fi
        tmp2=`/usr/local/bin/timelog.sh -Z $P_jahr/$tmp $CIRCUIT seconds`
        eval "OT"$i"="$tmp2
        eval "MONAT"$i"="$tmp
        if [ $tmp2 -gt $max ]
        then
            max=$tmp2
        fi
        sum=`expr $sum + $tmp2`
    done
    
    echo "<tr><!-- $max -->"
    i=1
    for i in $(seq 1 $MAX_MONAT)
    do
        if [ "$i" -le "9" ]
        then
            tmp=0$i
        else
            tmp=$i
        fi
        eval 'NAME_MONAT=$NAME_MONAT_'${tmp}
        echo -n "<td valign=\"bottom\"><img src=\"timelog_bar.gif\" height=\""
        eval ot_i='$OT'${i}
        count
        ot_i_k=`echo "($ot_i * 350) / $max" | /usr/local/bin/bc`
        echo -n $ot_i_k"\" width=\"20\" title=\"$NAME_MONAT: $title h\"><br>"
        if [ "$ot_i_k" -gt "0" ]
        then
            echo "<a href=\"$myname?circuit=$P_circuit&jahr=$P_jahr&monat=$tmp&tag=0\">"
            eval echo -n '$MONAT'${i}
            echo "</a>"
        else
            eval echo -n '$MONAT'${i}
        fi
        echo -n "</td>"
    done
    # Durschschnitt berechnen
    ot_i=`echo "$sum / $MAX_MONAT" | /usr/local/bin/bc`
    ot_i_k=`echo "($ot_i * 350) / $max" | /usr/local/bin/bc`
    count
    # Rest ausgeben
    echo "<td align=\"center\" valign=\"bottom\"><img src=\"timelog_bar.gif\"  height=\"$ot_i_k\" width=\"20\" title=\"Durchschnitt: $title h\" ><br>&#248;</td></tr></table>"
    echo "<br><br><a href=\"$TLname?circuit=$P_circuit&jahr=0&monat=0&tag=0\">Zur&uuml;ck</a>"
fi




# Footer
echo "<br><br><center><small><a href=\"http://mysite.fh-coburg.de/~troeger/fli4l/\" target=\"_blank\">OPT_TimeLog</a> $TIMELOG_VER by Enrico Tr&ouml;ger</small></center>"
echo "</body></html>"

