#!/bin/sh
#---------------------------------------------------------------------------------------------
# /usr/local/htdocs/main_Timelog.cgi     OPT_TIMELOG      v.0.7
#
# Creation:        16.03.2004  Enrico Troeger <troeger@fh-coburg.de>
# Last Update:     03.01.2005  Enrico Troeger <troeger@fh-coburg.de>
#----------------------------------------------------------------------------------------------

# Variablen belegen
myname=`basename $0`
graphname="timegraph.cgi"
farbe="1"
farbe1="#FFFFFF"
farbe2="#E7E7E7"
if [ -f /var/run/timelog.conf ]
then
    . /var/run/timelog.conf
    reload="$TIMELOG_RELOAD"
else
    reload="600"
fi

# Parameter parsen
for var in `echo "$QUERY_STRING" | tr '&' ' '`
do
    if echo "$var" | grep -v "=" > /dev/null ; then var="$var=yes" ; fi
    eval "P_$var"
done
if [ -z "$P_monat" ];
then
    P_monat="0";
fi
if [ -z "$P_jahr" ];
then
    P_jahr=0
fi

# Zeit-Rechnen-Funktion
count() {
    #m=`echo "$tmp / 60" | /usr/local/bin/bc`
    h=`echo "$TAG_OT_TMP / 3600" | /usr/local/bin/bc`
    m=`echo "($TAG_OT_TMP / 60) % 60" | /usr/local/bin/bc`
    if [ "$h" -le "9" ]
    then
        h="0$h"
    fi
    if [ "$m" -le "9" ]
    then
        m="0$m"
    fi
    TAG_OT="$h:$m"
    return 0
}

# Traffic-Rechnen-Funktion
countT() {
    TO_NK=`echo "$T_OUT % 1048576" | /usr/local/bin/bc`
    TO_NK=`echo "$TO_NK / 10000" | /usr/local/bin/bc`
    TO=`echo "$T_OUT / 1048576" | /usr/local/bin/bc`
    TI_NK=`echo "$T_IN % 1048576" | /usr/local/bin/bc`
    TI_NK=`echo "$TI_NK / 10000" | /usr/local/bin/bc`
    TI=`echo "$T_IN / 1048576" | /usr/local/bin/bc`
    if [ "$TI" -le "9" ]
    then
        TI=0$TI
    fi
    if [ "$TO" -le "9" ]
    then
        TO=0$TO
    fi
    #shorten
    TI="$TI.$TI_NK"
    TO="$TO.$TO_NK"
    return 0
}


# Daten berechnen
JAHR=$P_jahr # aus Kompatibilit�sgrnden
THIS_JAHR=`date +%Y`
MONAT=`date +%m`
if [ "$MONAT" = "01" ]
then
    LMONAT=12
else
    LMONAT=`expr $MONAT - 1`
    if [ "$LMONAT" -le "9" ]
    then
        LMONAT=0$LMONAT
    fi
fi
TAG=`date +%d`
if [ "$TAG" != "01" ]
then
    GESTERN=`expr $TAG - 1`
    if [ "$GESTERN" -le "9" ]
    then
        GESTERN=0$GESTERN
    fi
else
        case "$MONAT" in
            01|05|07|10|12 )      GESTERN=30;;
            02|04|06|08|09|11 )               GESTERN=31;;
            03 )                        GESTERN=28;;
        esac
fi

NAME_MONAT_01="Januar"
NAME_MONAT_02="Februar"
NAME_MONAT_03="M&auml;rz"
NAME_MONAT_04="April"
NAME_MONAT_05="Mai"
NAME_MONAT_06="Juni"
NAME_MONAT_07="Juli"
NAME_MONAT_08="August"
NAME_MONAT_09="September"
NAME_MONAT_10="Oktober"
NAME_MONAT_11="November"
NAME_MONAT_12="Dezember"
    
echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store" # HTTP/1.1 (or no-cache?)
echo "Pragma: no-cache"        # HTTP/1.0
echo "Expires: `date -Ru`"     # Expires now!
echo "Refresh: $reload"
echo
echo "<html><head>"
echo "<LINK REL=STYLESHEET TYPE=\"text/css\" HREF=\"main.css\">"
echo "<meta HTTP-EQUIV=\"Refresh\" CONTENT=\"$reload;url=$myname?circuit=$P_circuit&jahr=$P_jahr&monat=$P_monat&tag=$P_tag\">"
echo "<meta http-equiv=\"expires\" content=\"0\">"
echo "<meta http-equiv=\"pragma\" content=\"no-cache\">"
echo "<title>TimeLog</title></head>"
echo "<body alink=\"#0000FF\" vlink=\"#0000FF\" link=\"#0000FF\">"
echo "<b>OPT_TIMELOG</b><br><br>"
echo "<!-- Jahr: $P_jahr akt. Jahr: $THIS_JAHR LM: $LMONAT M: $MONAT Gestern: $GESTERN Heute: $TAG         # just debug   ;-) -->"

if [ ! -f "/var/run/timelog.conf" ]
then
     echo "<br><center><small>Keine Daten vorhanden (START_IMOND <u>und</u> IMOND_LOG auf 'yes'?).</small></center>"
     echo "<br><center><small>Diese Seite erneuert sich automatisch alle $reload Sekunden.</small></center>"
     echo "<center><small><a href=\"http://mysite.fh-coburg.de/~troeger/fli4l/\" target=\"_blank\">OPT_TimeLog</a> $TIMELOG_VER by Enrico Tr&ouml;ger</small></center>"
     echo "</body></html>"
     exit
elif [ -f "/tmp/timelog.lock" ]
then
     echo "<br><center><small>Neuberechnung der Daten l&auml;uft gerade. Bitte einen Moment warten.</small></center>"
     echo "<br><center><small>Diese Seite erneuert sich automatisch alle $reload Sekunden.</small></center>"
     echo "<center><small><a href=\"http://mysite.fh-coburg.de/~troeger/fli4l/\" target=\"_blank\">OPT_TimeLog</a> $TIMELOG_VER by Enrico Tr&ouml;ger</small></center>"
     echo "</body></html>"
     exit
else
    # Circuit-Wahl
    if [ -n "$ISDN_CIRCUITS_N" ]
    then
        echo "Bitte Circuit w&auml;hlen:&nbsp;"
        i=1
        while [ $i -le "$ISDN_CIRCUITS_N" ];
        do
            echo "<a href=\"$myname?circuit=`eval echo '$ISDN_CIRC_'${i}_NAME`&jahr=$P_jahr&monat=$P_monat&tag=$P_tag\">`eval echo '$ISDN_CIRC_'${i}_NAME`</a>&nbsp;&nbsp;"
            i=`expr $i + 1`
        done
        echo "<a href=\"$myname?circuit=all&jahr=$P_jahr&monat=$P_monat&tag=$P_tag\">Alle</a><br>"
    fi
fi

# Circuit-Wahl
if [ -n "$P_circuit" ]
then
        if [ -z "$P_circuit" ]
        then
            CIRCUIT="all"
            ANZ_CIRCUIT="Alle"
        else
            CIRCUIT="$P_circuit"
            if [ "$P_circuit" = "all" ]
            then
                ANZ_CIRCUIT="Alle"
            else
                ANZ_CIRCUIT="$P_circuit"
            fi
        fi
else
        if [ "$TIMELOG_CIRCUIT" -gt "0" ]
        then
            CIRCUIT=`eval echo '$ISDN_CIRC_'${TIMELOG_CIRCUIT}_NAME`
            ANZ_CIRCUIT="$CIRCUIT"
        else
            CIRCUIT="all"
            ANZ_CIRCUIT="Alle"
        fi
fi
echo "Gew&auml;hlter Circuit: $ANZ_CIRCUIT<br><br>"

# imond.log neu einlesen
if [ "$P_calculate" = "yes" ]
then
    echo -n "<br>Verbindungsdaten werden neu eingelesen und berechnet<br>Dieser Vorgang kann einige Zeit dauern und sollte nicht abgebrochen werden.<br>"
    /usr/local/bin/timelog-calc.sh "."
    echo " fertig.<br><br>"
fi

# Tages-Ausgabe
if [ "$P_monat" -gt "0" -a "$P_tag" -gt "0" ]
then
    echo "Tagesanzeige f&uuml;r $P_tag.$P_monat.$P_jahr (f&uuml;r Circuit: $ANZ_CIRCUIT):<br>"
    echo "<table border=\"0\">"
    if [ "$TIMELOG_DO_TRAFFIC" = "yes" ]
    then
        echo "<tr><td width=\"65\">Circuit:</td><td width=\"75\">Start-Zeit:</td><td width=\"75\">End-Zeit:</td><td>Online-Zeit:</td><td width=\"15\"></td><td width=\"75\" align=\"center\">Traffic IN:&nbsp;&nbsp;</td><td width=\"15\"></td><td width=\"75\" align=\"center\">Traffic OUT:</td></tr>"
    else
        echo "<tr><td width=\"65\">Circuit:</td><td width=\"75\">Start-Zeit:</td><td width=\"75\">End-Zeit:</td><td>Online-Zeit</td></tr>"
    fi
    tmp="$P_jahr/$P_monat/$P_tag"
    farbe=1
    file="$IMOND_LOGDIR/imond.log"
    cir=""
    if [ "$CIRCUIT" != "all" ]
    then
       cir="$CIRCUIT"
    fi
    if [ "$TIMELOG_DO_TRAFFIC" = "yes" ]
    then
        grep "$cir[ ]*$tmp" "$file" | sed 's/^[ ]*\([^ ]\+\)[ ]\+\([^ ]\+\)[ ]\+\([^ ]\+\)[ ]\+[^ ]\+[ ]\+\([^ ]\+\)[ ]\+\([^ ]\+\)[ ]\+[^ ]\+[ ]\+[^ ]\+[ ]\+[^ ]\+[ ]\+\([^ ]\+\)[ ]\+[^ ]\+[ ]\+\([^ ]\+\).*$/\1 \3 \4 \5:\6:\7/' > "/tmp/timelog"
        while read string
        do
            # string parsen (T-Online 11:06:29 11:23:51 1042:2801225:490979)
            TAG_CI=`echo "$string" | cut -d ' ' -f 1`
            TAG_SZ=`echo "$string" | cut -d ' ' -f 2`
            TAG_EZ=`echo "$string" | cut -d ' ' -f 3`
            TAG_TMP=`echo "$string" | cut -d ' ' -f 4`
            TAG_OT_TMP=`echo "$TAG_TMP" | cut -d ':' -f 1`
            count
            T_IN=`echo "$TAG_TMP" | cut -d ':' -f 2`
            T_OUT=`echo "$TAG_TMP" | cut -d ':' -f 3`
            countT
            echo "<tr bgcolor=\"$tdcolor\"><td align=\"left\">$TAG_CI</td><td align=\"center\">$TAG_SZ</td><td align=\"center\">$TAG_EZ</td><td align=\"center\">$TAG_OT</td><td></td><td align=\"center\">$TI MB</td><td></td><td align=\"center\">$TO MB</td></tr>"
            # Tabellen-Hintergrundfarbe festlegen
            farbe=`expr $farbe + 1`;
            if [ `expr $farbe % 2` != "0" ]; then tdcolor=$farbe1; else tdcolor=$farbe2; fi
        done < "/tmp/timelog"
        rm "/tmp/timelog"
        # Gesamt-Zeile
        T_TMP=`/usr/local/bin/timelog.sh -A $tmp $CIRCUIT` # 00:59 06.90:01.14
        GES_OT=`echo $T_TMP | cut -d ' ' -f 1`
        GES_TI=`echo $T_TMP | cut -d ' ' -f 2 | cut -d ':' -f 1`
        GES_TO=`echo $T_TMP | cut -d ' ' -f 2 | cut -d ':' -f 2`
        echo "<tr bgcolor=\"$tdcolor\"><td align=\"left\" colspan=\"3\">Gesamt:</td><td align=\"center\">$GES_OT</td><td></td><td>$GES_TI MB</td><td></td><td>$GES_TO MB</td></tr>"
    else
        # ohne Traffic
        grep "$cir[ ]*$tmp" "$file" | sed 's/^[ ]*\([^ ]\+\)[ ]\+\([^ ]\+\)[ ]\+\([^ ]\+\)[ ]\+[^ ]\+[ ]\+\([^ ]\+\)[ ]\+\([^ ]\+\)[ ]\+[^ ]\+[ ]\+[^ ]\+[ ]\+[^ ]\+[ ]\+\([^ ]\+\)[ ]\+[^ ]\+[ ]\+\([^ ]\+\).*$/\1 \3 \4 \5:\6:\7/' > "/tmp/timelog"
        while read string
        do
            # string parsen (T-Online 11:06:29 11:23:51 1042:2801225:490979)
            TAG_CI=`echo "$string" | cut -d ' ' -f 1`
            TAG_SZ=`echo "$string" | cut -d ' ' -f 2`
            TAG_EZ=`echo "$string" | cut -d ' ' -f 3`
            TAG_TMP=`echo "$string" | cut -d ' ' -f 4`
            TAG_OT_TMP=`echo "$TAG_TMP" | cut -d ':' -f 1`
            count
            echo "<tr bgcolor=\"$tdcolor\"><td align=\"left\">$TAG_CI</td><td align=\"center\">$TAG_SZ</td><td align=\"center\">$TAG_EZ</td><td align=\"center\">$TAG_OT</td></tr>"
            # Tabellen-Hintergrundfarbe festlegen
            farbe=`expr $farbe + 1`;
            if [ `expr $farbe % 2` != "0" ]; then tdcolor=$farbe1; else tdcolor=$farbe2; fi
        done < "/tmp/timelog"
        rm "/tmp/timelog"
        # Gesamt-Zeile
        GES_OT=`/usr/local/bin/timelog.sh -Z $tmp $CIRCUIT`
        echo "<tr bgcolor=\"$tdcolor\"><td align=\"left\" colspan=\"3\">Gesamt:</td><td align=\"center\">$GES_OT</td></tr>"
    fi
    echo "</table><br><br><a href=\"$myname?circuit=$P_circuit&jahr=$P_jahr&monat=$P_monat&tag=0\">Zur&uuml;ck</a>"
    echo "<a href=\"$graphname?circuit=$P_circuit&jahr=$P_jahr&monat=$P_monat&tag=$P_tag\">Grafik</a>"
fi

# Monats-Ausgabe
if [ "$P_monat" -gt "0" -a "$P_tag" = "0" ]
then
    echo "<table border=\"0\">"
    eval 'NAME_MONAT=$NAME_MONAT_'${P_monat}
    if [ "$TIMELOG_DO_TRAFFIC" = "yes" ]
    then
        echo "<tr><td colspan=\"2\">Monatsanzeige f&uuml;r $NAME_MONAT $P_jahr (f&uuml;r Circuit: $ANZ_CIRCUIT):&nbsp;&nbsp;&nbsp;</td>"
        echo "<td align=\"right\">Traffic IN:&nbsp;&nbsp;</td><td width=\"15\"></td><td align=\"right\">Traffic OUT:</td></tr>"
    else
        echo "<tr><td colspan=\"2\">Monatsanzeige f&uuml;r $NAME_MONAT $P_jahr (f&uuml;r Circuit: $ANZ_CIRCUIT):</td></tr>"
    fi
    case "$P_monat" in
        01|03|05|07|08|10|12 )        MAXDAYS=31;;
        04|06|09|11 )                 MAXDAYS=30;;
        02 )                          MAXDAYS=28;;
    esac
    # im aktuellen Monat nur bis zum heutigen Tag berechnen, weil von morgen gibt es ja noch keine Daten ;-)
    if [ "$P_monat" = "$MONAT" ]
    then
        MAXDAYS=$TAG
    fi
    GES_OT=0
    # Mit Traffic-Anzeige
    if [ "$TIMELOG_DO_TRAFFIC" = "yes" ]
    then
        GES_TI=0
        GES_TO=0
        for i in $(seq 1 $MAXDAYS)
        do
            if [ "$i" -le "9" ]
            then
                tmp=0$i
            else
                tmp=$i
            fi
            DATA=`/usr/local/bin/timelog.sh -A $P_jahr/$P_monat/$tmp $CIRCUIT`
            OT=`echo "$DATA" | cut -d ' ' -f 1`
            TI=`echo "$DATA" | cut -d ' ' -f 2 | cut -d ':' -f 1`
            TO=`echo "$DATA" | cut -d ' ' -f 2 | cut -d ':' -f 2`
            echo "<tr bgcolor=\"$tdcolor\"><td><a href=\"$myname?circuit=$P_circuit&jahr=$P_jahr&monat=$P_monat&tag=$tmp\">"
            echo "$tmp.$P_monat.$P_jahr:</a></td><td>$OT</td></td><td align=\"right\">$TI MB</td><td></td>"
            echo "<td align=\"right\">$TO MB</td></tr>"
            GES_TI=`echo "$GES_TI + $TI" | /usr/local/bin/bc`
            GES_TO=`echo "$GES_TO + $TO" | /usr/local/bin/bc`
            # Tabellen-Hintergrundfarbe festlegen
            farbe=`expr $farbe + 1`;
            if [ `expr $farbe % 2` != "0" ]; then tdcolor=$farbe1; else tdcolor=$farbe2; fi
        done
        #GES_ALL=`/usr/local/bin/timelog.sh -A $JAHR/$P_monat $CIRCUIT`
        GES_OT=`/usr/local/bin/timelog.sh -Z $P_jahr/$P_monat $CIRCUIT`
        #GES_OT=`echo "$GES_ALL" | cut -d ' ' -f 1`
        #GES_TI=`echo "$GES_ALL" | cut -d ' ' -f 2 | cut -d ':' -f 1`
        #GES_TO=`echo "$GES_ALL" | cut -d ' ' -f 2 | cut -d ':' -f 2`
        echo "<tr bgcolor=\"$tdcolor\"><td>Gesamt:</td><td>$GES_OT</td></td><td align=\"right\">$GES_TI MB</td><td>"
        echo "</td><td align=\"right\">$GES_TO MB</td></tr>"
    # Ohne Traffic-Anzeige
    else
        for i in $(seq 1 $MAXDAYS)
        do
            if [ "$i" -le "9" ]
            then
                tmp=0$i
            else
                tmp=$i
            fi
            OT=`/usr/local/bin/timelog.sh -Z $P_jahr/$P_monat/$tmp $CIRCUIT`
            echo "<tr><td><a href=\"$myname?circuit=$P_circuit&jahr=$P_jahr&monat=$P_monat&tag=$tmp\">"
            echo "$tmp.$P_monat.$JAHR</a>:</td><td>$OT</td></tr>"
            # Tabellen-Hintergrundfarbe festlegen
            farbe=`expr $farbe + 1`;
            if [ `expr $farbe % 2` != "0" ]; then tdcolor=$farbe1; else tdcolor=$farbe2; fi
        done
        GES_OT=`/usr/local/bin/timelog.sh -Z $P_jahr/$P_monat $CIRCUIT`
        echo "<tr bgcolor=\"$tdcolor\"><td>Gesamt:</td><td>$GES_OT</td></tr>"
    fi
    echo "</table><br><br><a href=\"$myname?circuit=$P_circuit&jahr=0&monat=0&tag=0\">Zur&uuml;ck</a>"
    echo "<a href=\"$graphname?circuit=$P_circuit&jahr=$P_jahr&monat=$P_monat&tag=0\">Grafik</a>"
fi


# Jahres-Ansicht
if [ "$P_jahr" -gt "0" -a "$P_monat" = "0"  ]
then
    echo "<table border=\"0\">"
    if [ "$TIMELOG_DO_TRAFFIC" = "yes" ]
    then
        echo "<tr><td colspan=\"2\">Jahresansicht f&uuml;r <b>$P_jahr</b> (f&uuml;r Circuit: $ANZ_CIRCUIT):&nbsp;&nbsp;&nbsp;</td>"
        echo "<td align=\"right\">Traffic IN:&nbsp;&nbsp;</td><td width=\"15\"></td><td align=\"right\">Traffic OUT:</td></tr>"
    else
        echo "<tr><td colspan=\"2\">Jahresansicht f&uuml;r <b>$P_jahr</b> (f&uuml;r Circuit: $ANZ_CIRCUIT):</td></tr>"
    fi
    # im aktuellen Jahr nur bis zum aktuellen Monat berechnen, weil vom n�hsten Monat gibt es ja noch keine Daten ;-)
    if [ "$P_jahr" = "$THIS_JAHR" ]
    then
        MAX_MONAT=$MONAT
    else
        MAX_MONAT=12
    fi
    i=1
    GES_OT=0
    # Mit Traffic-Anzeige
    if [ "$TIMELOG_DO_TRAFFIC" = "yes" ]
    then
        GES_TI=0
        GES_TO=0
        for i in $(seq 1 $MAX_MONAT)
        do
            if [ "$i" -le "9" ]
            then
                tmp=0$i
            else
                tmp=$i
            fi
            eval 'NAME_MONAT=$NAME_MONAT_'${tmp}
            DATA=`/usr/local/bin/timelog.sh -A $P_jahr/$tmp $CIRCUIT`
            OT=`echo "$DATA" | cut -d ' ' -f 1`
            TI=`echo "$DATA" | cut -d ' ' -f 2 | cut -d ':' -f 1`
            TO=`echo "$DATA" | cut -d ' ' -f 2 | cut -d ':' -f 2`
            echo "<tr bgcolor=\"$tdcolor\"><td><a href=\"$myname?circuit=$P_circuit&jahr=$P_jahr&monat=$tmp&tag=0\">"
            echo "$NAME_MONAT:</a></td><td>$OT</td></td><td align=\"right\">$TI MB</td><td></td>"
            echo "<td align=\"right\">$TO MB</td></tr>"
            GES_TI=`echo "$GES_TI + $TI" | /usr/local/bin/bc`
            GES_TO=`echo "$GES_TO + $TO" | /usr/local/bin/bc`
            # Tabellen-Hintergrundfarbe festlegen
            farbe=`expr $farbe + 1`;
            if [ `expr $farbe % 2` != "0" ]; then tdcolor=$farbe1; else tdcolor=$farbe2; fi
        done
        GES_OT=`/usr/local/bin/timelog.sh -Z $P_jahr $CIRCUIT`
        echo "<tr bgcolor=\"$tdcolor\"><td>Gesamt:</td><td>$GES_OT</td></td><td align=\"right\">$GES_TI MB</td><td>"
        echo "</td><td align=\"right\">$GES_TO MB</td></tr>"
    # Ohne Traffic-Anzeige
    else
        for i in $(seq 1 $MAX_MONAT)
        do
            if [ "$i" -le "9" ]
            then
                tmp=0$i
            else
                tmp=$i
            fi
            eval 'NAME_MONAT=$NAME_MONAT_'${tmp}
            OT=`/usr/local/bin/timelog.sh -Z $P_jahr/$tmp $CIRCUIT`
            echo "<tr><td><a href=\"$myname?circuit=$P_circuit&jahr=$P_jahr&monat=$tmp&tag=0\">"
            echo "$NAME_MONAT</a>:</td><td>$OT</td></tr>"
            # Tabellen-Hintergrundfarbe festlegen
            farbe=`expr $farbe + 1`;
            if [ `expr $farbe % 2` != "0" ]; then tdcolor=$farbe1; else tdcolor=$farbe2; fi
        done
        GES_OT=`/usr/local/bin/timelog.sh -Z $P_jahr $CIRCUIT`
        echo "<tr bgcolor=\"$tdcolor\"><td>Gesamt:</td><td>$GES_OT</td></tr>"
    fi
    echo "</table><br><br><a href=\"$myname?circuit=$P_circuit&jahr=0&monat=0&tag=0\">Zur&uuml;ck</a>"
    echo "<a href=\"$graphname?circuit=$P_circuit&jahr=$P_jahr&monat=0&tag=0\">Grafik</a>"
fi


# Standard-Ausgabe
if [ "$P_jahr" = "0" ]
then

    min=`grep "min" /var/run/timelog.data2 | cut -d '' -f 2`
    tmp=`grep "$CIRCUIT" /var/run/timelog.data2 | cut -d '' -f 2`
    DATA_LMONAT=`echo "$tmp" | cut -d '|' -f 1`
    OT_LMONAT=`echo "$DATA_LMONAT" | cut -d ' ' -f 1`
    TI_LMONAT=`echo "$DATA_LMONAT" | cut -d ' ' -f 2 | cut -d ':' -f 1`
    TO_LMONAT=`echo "$DATA_LMONAT" | cut -d ' ' -f 2 | cut -d ':' -f 2`

    DATA_MONAT=`echo "$tmp" | cut -d '|' -f 2`
    OT_MONAT=`echo "$DATA_MONAT" | cut -d ' ' -f 1`
    TI_MONAT=`echo "$DATA_MONAT" | cut -d ' ' -f 2 | cut -d ':' -f 1`
    TO_MONAT=`echo "$DATA_MONAT" | cut -d ' ' -f 2 | cut -d ':' -f 2`

    # Mit Traffic-Anzeige
    if [ "$TIMELOG_DO_TRAFFIC" = "yes" ]
    then
        DATA_GESTERN=`echo "$tmp" | cut -d '|' -f 3`
        OT_GESTERN=`echo "$DATA_GESTERN" | cut -d ' ' -f 1`
        TI_GESTERN=`echo "$DATA_GESTERN" | cut -d ' ' -f 2 | cut -d ':' -f 1`
        TO_GESTERN=`echo "$DATA_GESTERN" | cut -d ' ' -f 2 | cut -d ':' -f 2`
        DATA_TAG=`echo "$tmp" | cut -d '|' -f 4`
        OT_TAG=`echo "$DATA_TAG" | cut -d ' ' -f 1`
        TI_TAG=`echo "$DATA_TAG" | cut -d ' ' -f 2 | cut -d ':' -f 1`
        TO_TAG=`echo "$DATA_TAG" | cut -d ' ' -f 2 | cut -d ':' -f 2`
    # Ohne Traffic-Anzeige
    else
        OT_GESTERN=`echo "$tmp" | cut -d '|' -f 3 | cut -d ' ' -f 1`
        OT_TAG=`echo "$tmp" | cut -d '|' -f 4 | cut -d ' ' -f 1`
    fi

    #echo "<!-- $TI_TAG |  $DATA_TAG -->"
    echo "<table border=\"0\">"
    # Mit Traffic-Anzeige
    if [ "$TIMELOG_DO_TRAFFIC" = "yes" ]
    then
        echo "<tr><td colspan=\"2\" style=\"font-size: 12pt\">Aktuelle Verbindungszeiten:</td><td width=\"25\"></td><td colspan=\"3\" align=\"center\" style=\"font-size: 12pt\">Traffic:</td></tr>"
        echo "<tr><td colspan=\"6\">&nbsp;</td></tr>"
        echo "<tr><td align=\"right\"><a href=\"$myname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$LMONAT&tag=0\">Letzter Monat</a>&nbsp;(<a href=\"$graphname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$LMONAT&tag=0\">Grafik</a>):</td><td>$OT_LMONAT h</td><td width=\"25\"></td><td>"
        echo "<td>IN: $TI_LMONAT MB</td><td>OUT: $TO_LMONAT MB</td></tr>"
        echo "<tr><td align=\"right\"><a href=\"$myname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$MONAT&tag=0\">Aktueller Monat</a>&nbsp;(<a href=\"$graphname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$MONAT&tag=0\">Grafik</a>):</td><td><b>$OT_MONAT h</b></td><td width=\"25\"></td><td></td>"
        echo "<td>IN: $TI_MONAT MB</td><td>OUT: $TO_MONAT MB</td></tr>"
        echo "<tr><td align=\"right\"><a href=\"$myname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$MONAT&tag=$GESTERN\">Gestern</a>&nbsp;(<a href=\"$graphname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$MONAT&tag=$GESTERN\">Grafik</a>):</td><td>$OT_GESTERN h</td><td width=\"25\"></td><td></td>"
        echo "<td>IN: $TI_GESTERN MB</td><td>OUT: $TO_GESTERN MB</td></tr>"
        echo "<tr><td align=\"right\"><a href=\"$myname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$MONAT&tag=$TAG\">Heute</a>&nbsp;(<a href=\"$graphname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$MONAT&tag=$TAG\">Grafik</a>):</td><td><b>$OT_TAG h</b></td><td width=\"25\"></td><td></td>"
        echo "<td>IN: $TI_TAG MB</td><td>OUT: $TO_TAG MB</td></tr>"
    # Ohne Traffic-Anzeige
    else
        echo "<tr><td colspan=\"2\" style=\"font-size: 12pt\">Aktuelle Verbindungszeiten:</td></tr>"
        echo "<tr><td colspan=\"2\">&nbsp;</td></tr>"
        echo "<tr><td align=\"right\"><a href=\"$myname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$LMONAT&tag=0\">Letzter Monat</a>&nbsp;(<a href=\"$graphname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$LMONAT&tag=0\">Grafik</a>):</td><td>$OT_LMONAT h</td></tr>"
        echo "<tr><td align=\"right\"><a href=\"$myname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$MONAT&tag=0\">Aktueller Monat</a>&nbsp;(<a href=\"$graphname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$MONAT&tag=0\">Grafik</a>):</td><td><b>$OT_MONAT h</b></td></tr>"
        echo "<tr><td align=\"right\"><a href=\"$myname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$MONAT&tag=$GESTERN\">Gestern:</a></td><td>$OT_GESTERN h</td></tr>"
        echo "<tr><td align=\"right\"><a href=\"$myname?circuit=$P_circuit&jahr=$THIS_JAHR&monat=$MONAT&tag=$TAG\">Heute:</a></td><td><b>$OT_TAG h</b></td></tr>"
    fi
    echo "</table>"
    echo "<table border=\"0\">"
    echo "<tr><td colspan=\"14\">&nbsp;</td></tr>"
    echo "<tr><td colspan=\"14\" style=\"font-size: 12pt\">Monatsdaten(D) oder Monatsgrafiken(G) anzeigen:</td></tr>"
    echo "<tr><td colspan=\"14\">&nbsp;</td></tr>"
    echo "<tr><td align=\"right\">Jahr / Monat:</td>"
    for i in $(seq 1 12)
    do
        if [ "$i" -le "9" ]
        then
            echo "<td align=\"center\">0$i</td><td>&nbsp;</td>"
        else
            echo "<td align=\"center\">$i</td><td>&nbsp;</td>"
        fi
    done
    echo "<td>Gesamt</td></tr>"
    
    for j in $(seq $min $THIS_JAHR)
    do
        i=1
        link=""
        echo "<tr><td align=\"right\">$j:&nbsp;</td>"
        for i in $(seq 1 12)
        do
            if [ "$i" -le "9" ]
            then
                tmp="0$i"
            else
                tmp=$i
            fi
            if [ "$j" = "$THIS_JAHR" -a "$i" -gt "$MONAT" ]
            then
                echo "<td></td><td>&nbsp;</td>"
            else
               echo "<td><a href=\"$myname?circuit=$P_circuit&jahr=$j&monat=$tmp&tag=0\">D</a>&nbsp;<a href=\"$graphname?circuit=$P_circuit&jahr=$j&monat=$tmp&tag=0\">G</a></td><td>&nbsp;</td>";
            fi
        done
        echo "<td align=\"center\"><a href=\"$myname?circuit=$P_circuit&jahr=$j&monat=0&tag=0\">D</a>&nbsp;<a href=\"$graphname?circuit=$P_circuit&jahr=$j&monat=0&tag=0\">G</a></td></tr>"
    done
fi

# Footer
echo "</table>"
echo "<br><br><center><small>Diese Seite erneuert sich automatisch alle $reload Sekunden, jetzt <a href=\"$myname?circuit=$P_circuit&jahr=$P_jahr&monat=$P_monat&tag=$P_tag\">neuladen</a>. Online-Zeiten jetzt <a href=\"$myname?circuit=$P_circuit&jahr=$P_jahr&monat=$P_monat&tag=$P_tag&calculate=yes\">neuberechnen</a>.</small></center>"
echo "<center><small><a href=\"http://mysite.fh-coburg.de/~troeger/fli4l/\" target=\"_blank\">OPT_TimeLog</a> $TIMELOG_VER by Enrico Tr&ouml;ger</small></center>"
echo "</body></html>"

