#!/bin/sh
#---------------------------------------------------------------------------
# /usr/local/bin/timelog.sh   OPT_TIMELOG       v.0.7
#
# Creation:     16.03.2004  Enrico Troeger <troeger@fh-coburg.de>
# Last Update:  03.01.2005  Enrico Troeger <troeger@fh-coburg.de>
#---------------------------------------------------------------------------

if [ -f /var/run/timelog.data ]
then
    . /var/run/timelog.conf
    ISDN_CIRC_0_NAME='all'
    eval 'circ=$ISDN_CIRC_'${TIMELOG_CIRCUIT}_NAME
    showhelp() {        
        # ISDN_CIRC_n_NAME geht hier, weil das aus der timelog.conf kommt,
        # und da gibts auch bei DSL diese Variablen
        echo "Usage: `basename $0` options date circuit"
        echo
        echo "Optionen:"
        echo "-z    - Zeitwerte ausgeben (-Z fuer kurze Ausgaben)"
        echo "-t    - Trafficwerte ausgeben (-T fuer kurze Ausgaben)"
        echo "-a    - Traffic- und Zeitwerte ausgeben (-A fuer kurze Ausgaben)"
        echo
        echo "Format von date:"
        echo "yyyy/mm/dd um einen Tag anzugeben"
        echo "yyyy/mm/ um einen Monat anzugeben"
        echo "yyyy/ um ein Jahr anzugeben"
        echo "(z.B. \"`date +%Y/%m/%d`\" fuer heute, \"`date +%Y/%m/`\" fuer diesen Monat, \"date +%Y/%m/%d\" in Scripten)"
        echo 
        echo "Bei Weglassen des Circuits, wird der in der config/timelog.txt eingestellte Standard-Circuit($circ) benutzt."
        echo 
        echo "Beispiele:"
        echo "`basename $0` -z `date +%Y/%m/%d`"
        echo "`basename $0` -z `date +%Y/%m/%d` all"
        echo "`basename $0` -a `date +%Y/%m/` $ISDN_CIRC_1_NAME"
        echo
        exit
    }
    date_format() {
        echo "$raw_date" | grep / >/dev/null
        if [ "$?" = "0" ]
        then
            y=`echo "$raw_date" | cut -d '/' -f 1`
            m=`echo "$raw_date" | cut -d '/' -f 2`
            d=`echo "$raw_date" | cut -d '/' -f 3`
            nice_date="$y"
            if [ ! -z "$m" ]; then nice_date="$m.$nice_date"; fi
            if [ ! -z "$d" ]; then nice_date="$d.$nice_date"; fi
        else
            nice_date="$raw_date"
        fi

    }
    
    # Vorbereitungen
    PARA=`echo "$1" | cut -d '-' -f 2`

    # Kommandozeilen-Modus
    if [ "$PARA" != "Z" -a "$PARA" != "A" -a "$PARA" != "T" -a "$PARA" != "d" -a "$PARA" != "D" ]
    then
        echo "OPT_TimeLog $TIMELOG_VER"
        echo
        if [ -f "/tmp/timelog.lock" ]
        then
            # Abbruch wenn grade timelog-calc.sh laeuft
            echo "Neuberechnung der Daten laeuft gerade. Bitte einen Moment warten."
            echo
            exit 1
        fi
        if [ -z "$2" ]
        then
            # Ueberischt, ohne konkretes Datum
            case "$PARA" in
                z)  # Monat
                    echo -n "Online-Zeit fuer diesen Monat (Circuit: $circ): "
                    timelog.sh -Z "`date +%Y/%m`" "$circ"
                    echo " h"
                    # Tag
                    echo -n "Online-Zeit fuer heute (Circuit: $circ): "
                    timelog.sh -Z "`date +%Y/%m/%d`" "$circ"
                    echo " h"
                    ;;
                t)  # Monat
                    echo "Traffic fuer diesen Monat (Circuit: $circ): "
                    echo -n "Incoming: "
                    value=$(timelog.sh -T "`date +%Y/%m`" "$circ")
                    echo "`echo "$value" | sed 's/:/ MB\nOutgoing: /'` MB"
                    # Tag
                    echo
                    echo "Traffic fuer heute (Circuit: $circ): "
                    echo -n "Incoming: "
                    value=$(timelog.sh -T "`date +%Y/%m/%d`" "$circ")
                    echo "`echo "$value" | sed 's/:/ MB\nOutgoing: /'` MB"
                    ;;
                a)  # Monat
                    value=$(timelog.sh -A "`date +%Y/%m`" "$circ")
                    echo -n "Online-Zeit fuer diesen Monat (Circuit: $circ): "
                    echo "`echo "$value" | cut -d ' ' -f 1` h"
                    echo -n "Incoming Traffic: "
                    echo "`echo "$value" | cut -d ' ' -f 2 | sed 's/:/ MB\nOutgoing Traffic: /'` MB"
                    echo
                    # Tag
                    value=$(timelog.sh -A "`date +%Y/%m/%d`" "$circ")
                    echo -n "Online-Zeit fuer heute (Circuit: $circ): "
                    echo "`echo "$value" | cut -d ' ' -f 1` h"
                    echo -n "Incoming Traffic: "
                    echo "`echo "$value" | cut -d ' ' -f 2 | sed 's/:/ MB\nOutgoing Traffic: /'` MB"
                    ;;
                *)  
                    showhelp
                    ;;
            esac         
        else
            # mit konkretem Datum
            case "$PARA" in
                z)  
                    raw_date="$2"
                    date_format
                    echo -n "Online-Zeit fuer $nice_date: "
                    timelog.sh -Z "$2" "$3"
                    echo " h"
                    ;;
                t)  
                    raw_date="$2"
                    date_format
                    echo "verursachter Traffic fuer $nice_date"
                    echo -n "Incoming: "
                    echo "`timelog.sh -T "$2" "$3"  | sed 's/:/ MB\nOutgoing: /'` MB"
                    ;;

                a)
                    raw_date="$2"
                    date_format
                    values=$(timelog.sh -A "$2" "$3")
                    echo -n "Online-Zeit fuer $nice_date: "
                    echo "`echo "$values" | cut -d ' ' -f 1` h"
                    echo -n "Incoming Traffic: "
                    echo "`echo "$values" | cut -d ' ' -f 2  | sed 's/:/ MB\nOutgoing Traffic: /'` MB"
                    ;;
                *)  
                    showhelp
                    ;;
            esac         
        fi
        echo
        exit
    fi
    
    
    
    # TimeLog-Modus
    if [ "$#" = "1" ]
    then
        TAG=`date +%Y/%m/%d`
    else
        TAG="$2"
    fi
    s=0
    TI=0
    TO=0
    
    # Zeiten auslesen
    if [ "$PARA" = "Z" -o "$PARA" = "A" ]
    then
        # Daten circuit-spezifisch auslesen
        if  [ "$3" != "all" -a -n "$3" ]
        then
            for i in `grep $TAG /var/run/timelog.data | cut -d ' ' -f 2`
            do
                if [ "`echo "$i" | cut -d ':' -f 2`" = "$3" ]
                then
                    zeit=`echo "$i" | cut -d ':' -f 1`
                    s=`echo "$s + $zeit" | /usr/local/bin/bc`
                fi
            done
        # Daten aller circuits auslesen
        else
            for i in `grep $TAG /var/run/timelog.data | cut -d ' ' -f 2`
            do
                 zeit=`echo "$i" | cut -d ':' -f 1`
                 s=`echo "$s + $zeit" | /usr/local/bin/bc`
             done
        fi
        # Zeit-Daten aufbereiten
        if [ "$4" = "seconds" ]
        then
            echo $s
        else
            /usr/local/bin/timelog.sh -d $s $4
        fi
    fi

    # Traffic auslesen
    if  [ "$PARA" = "T" -o "$PARA" = "A" ]
    then
        # Daten circuit-spezifisch auslesen
        if  [ "$3" != "all" -a -n "$3" ]
        then
            for i in `grep $TAG  /var/run/timelog.data | cut -d ' ' -f 3`
            do
                if [ `echo "$i" | cut -d ':' -f 3` = "$3" ]
                then
                    ti_tmp=`echo "$i" | cut -d ':' -f 1`
                    TI=`echo "$TI + $ti_tmp" | /usr/local/bin/bc`
                    to_tmp=`echo "$i" | cut -d ':' -f 2`
                    TO=`echo "$TO + $to_tmp" | /usr/local/bin/bc`
                fi
            done
        # Daten aller circuits auslesen
        else
            for i in `grep $TAG /var/run/timelog.data | cut -d ' ' -f 3`
            do
                ti_tmp=`echo "$i" | cut -d ':' -f 1`
                TI=`echo "$TI + $ti_tmp" | /usr/local/bin/bc`
                to_tmp=`echo "$i" | cut -d ':' -f 2`
                TO=`echo "$TO + $to_tmp" | /usr/local/bin/bc`
            done
        fi
        if [ "$PARA" = "A" ]
        then
            echo -n " "
        fi
        /usr/local/bin/timelog.sh -D $TI $TO
    fi

    # Zeit-Rechnen
    if [ "$PARA" = "d" ]
    then
        m=`echo "$2 / 60" | /usr/local/bin/bc`
        s=`echo "$2 % 60" | /usr/local/bin/bc`
        h=`echo "$m / 60" | /usr/local/bin/bc`
        m=`echo "$m % 60" | /usr/local/bin/bc`
        if [ "$h" -le "9" -a "$3" != "short" ]
        #if [ "$h" -le "9" ]
        then
            h="0$h"
        fi
        if [ "$m" -le "9" ]
        then
            m="0$m"
        fi
        echo -n "$h:$m"
    fi
    
    # Traffic-Rechnen
    if [ "$PARA" = "D" ]
    then
        TO_NK=`echo "$3 % 1048576" | /usr/local/bin/bc`
        TO_NK=`echo "$TO_NK / 10000" | /usr/local/bin/bc`
        TO=`echo "$3 / 1048576" | /usr/local/bin/bc`
        TI_NK=`echo "$2 % 1048576" | /usr/local/bin/bc`
        TI_NK=`echo "$TI_NK / 10000" | /usr/local/bin/bc`
        TI=`echo "$2 / 1048576" | /usr/local/bin/bc`
        if [ "$TI" -le "9" ]
        then
            TI=0$TI
        fi
        if [ "$TO" -le "9" ]
        then
            TO=0$TO
        fi
        #shorten
        echo -n "$TI.$TI_NK:$TO.$TO_NK"
    fi
    if [ "$PARA" = "A" -o "$PARA" = "T" ]
    then
        echo ""
    fi
fi
