#!/bin/sh
#------------------------------------------------------------------------------
# /usr/local/bin/timelog-calc.sh  OPT_TIMELOG   v.0.7
#
# Creation:      16.03.2004  Enrico Troeger <troeger@fh-coburg.de>
# Last Update:   30.12.2004  Enrico Troeger <troeger@fh-coburg.de>
#------------------------------------------------------------------------------

if [ -f /var/run/timelog.conf ]
then

    echo -n "" >/tmp/timelog.lock
    . /var/run/timelog.conf
    file="$IMOND_LOGDIR/imond.log"
    # Danke an Michael Wenger fuer den regulaeren Ausdruck ;-)
    # `sed 's/^[\t ]*[^ \t]\+[ \t]\+\([^ \t]\+\)[ \t]\+[^ \t]\+[ \t]\+[^ \t]\+[ \t]\+[^ \t]\+[ \t]\+\([^ \t]\+\).*$/\1 \2/' $file >/var/run/timelog.data`

    if [ "$TIMELOG_DO_TRAFFIC" = "yes" ]
    then
       if  [ `sed 's/\.//g' /etc/version` -gt "216" ]
       then
           # Fli4l-Version >= 2.1.7
           `sed 's/^[    ]*\([^     ]\+\)[  ]\+\([^     ]\+\)[  ]\+[^   ]\+[    ]\+[^   ]\+[    ]\+[^   ]\+[    ]\+\([^     ]\+\)[  ]\+[^   ]\+[    ]\+[^   ]\+[    ]\+[^   ]\+[    ]\+\([^     ]\+\)[  ]\+[^   ]\+[    ]\+\([^     ]\+\).*$/\2 \3:\1 \4:\5:\1/' $file >/var/run/timelog.data`
       else
           # Fli4l-Version < 2.1.7
           `sed 's/^[    ]*\([^     ]\+\)[  ]\+\([^     ]\+\)[  ]\+[^   ]\+[    ]\+[^   ]\+[    ]\+[^   ]\+[    ]\+\([^     ]\+\)[  ]\+[^   ]\+[    ]\+[^   ]\+[    ]\+\([^     ]\+\)[  ]\+\([^     ]\+\).*$/\2 \3:\1 \4:\5:\1/' $file >/var/run/timelog.data`
       fi
    else
        `sed 's/^[   ]*\([^     ]\+\)[  ]\+\([^     ]\+\)[  ]\+[^   ]\+[    ]\+[^   ]\+[    ]\+[^   ]\+[    ]\+\([^     ]\+\)[  ]\+[^   ]\+[    ]\+[^   ]\+[    ]\+\([^     ]\+\)[  ]\+\([^     ]\+\).*$/\2 \3:\1/' $file >/var/run/timelog.data`
    fi

    # Daten berechnen
    JAHR=`date +%Y`
    MONAT=`date +%m`
    if [ "$MONAT" = "01" ]
    then
        LMONAT=12
    else
        LMONAT=`expr $MONAT - 1`
        if [ "$LMONAT" -le "9" ]
        then
            LMONAT=0$LMONAT
        fi
    fi
    TAG=`date +%d`
    if [ "$TAG" != "01" ]
    then
        GESTERN=`expr $TAG - 1`
        if [ "$GESTERN" -le "9" ]
        then
            GESTERN=0$GESTERN
        fi
    else
        case "$MONAT" in
            01|02|05|07|09|12 )      GESTERN=30;;
            04|06|08|09|11 )               GESTERN=31;;
            03 )                        GESTERN=28;;
        esac
    fi


    echo -n "" >/var/run/timelog.data2
    ISDN_CIRC_0_NAME="all"
    i=0
    while [ $i -le "$ISDN_CIRCUITS_N" ];
    do
        echo -n "$1"
        eval 'CIRCUIT=$ISDN_CIRC_'${i}_NAME

        # Mit Traffic-Anzeige
        if [ "$TIMELOG_DO_TRAFFIC" = "yes" ]
        then
            DATA_LMONAT=`/usr/local/bin/timelog.sh -A $JAHR/$LMONAT $CIRCUIT`
            echo -n "$1"
            DATA_MONAT=`/usr/local/bin/timelog.sh -A $JAHR/$MONAT $CIRCUIT`
            echo -n "$1"
            DATA_GESTERN=`/usr/local/bin/timelog.sh -A $JAHR/$MONAT/$GESTERN $CIRCUIT`
            echo -n "$1"
            DATA_TAG=`/usr/local/bin/timelog.sh -A $JAHR/$MONAT/$TAG $CIRCUIT`
            echo -n "$1"
       # Ohne Traffic-Anzeige
        else
            DATA_LMONAT=`/usr/local/bin/timelog.sh -Z $JAHR/$LMONAT $CIRCUIT`
            echo -n "$1"
            DATA_MONAT=`/usr/local/bin/timelog.sh -Z $JAHR/$MONAT $CIRCUIT`
            echo -n "$1"
            DATA_GESTERN=`/usr/local/bin/timelog.sh -Z $JAHR/$MONAT/$GESTERN $CIRCUIT`
            echo -n "$1"
            DATA_TAG=`/usr/local/bin/timelog.sh -Z $JAHR/$MONAT/$TAG $CIRCUIT`
            echo -n "$1"
        fi
        i=`expr $i + 1`

        # Daten wegschreiben
        {
            echo "$CIRCUIT$DATA_LMONAT|$DATA_MONAT|$DATA_GESTERN|$DATA_TAG"
        } >>/var/run/timelog.data2
    done
    
    # Kleinstes Jahr finden
    min=`date +%Y`
    years=`sed 's/^[\t ]*\([^ \t]\+\)[ \t]\+\([^ \t]\+\)[ \t]\+[^ \t]\+[ \t]\+[^ \t]\+[ \t]\+[^ \t]\+[ \t]\+\([^ \t]\+\)[ \t]\+[^ \t]\+[ \t]\+[^ \t]\+[ \t]\+\([^ \t]\+\)[ \t]\+\([^ \t]\+\).*$/\2/' $file | cut -d '/' -f 1`
    if [ -x "/usr/bin/sort" ] # wenn sort vorhanden, damit Ergebnismenge minimieren
    then
        years=`echo "$years" | sort -u`
    fi
    for tmp in $years
    do
        if [ "$tmp" -lt "$min" ] 2>/dev/null
        then
             min="$tmp"
        fi
    done
    echo "min"$min >>/var/run/timelog.data2
    
    # LCD-Support
    eval 'CIRCUIT=$ISDN_CIRC_'${TIMELOG_CIRCUIT}_NAME
    if [ "$TIMELOG_LCD" = "yes" ]
    then
        /usr/local/bin/timelog.sh -Z $JAHR/$MONAT/$TAG $CIRCUIT short > /etc/lcd_text4.txt
        /usr/local/bin/timelog.sh -Z $JAHR/$MONAT $CIRCUIT short > /etc/lcd_text3.txt
    fi
 
    # Schluss
    echo ""
    rm /tmp/timelog.lock
    if [ "$1" = "" ]
    then
        echo "TimeLog wurde aktualisiert"
    fi
fi
