#!/bin/sh
#---------------------------------------------------------------------------------------------
# /usr/local/htdocs/main_Timelog.cgi     OPT_TIMELOG      v.0.8
#
# Creation:        16.03.2004  Enrico Troeger <fli4l@emgame.de>
# Last Update:     21.03.2005  Enrico Troeger <fli4l@emgame.de>
#----------------------------------------------------------------------------------------------

# Variablen belegen
myname=`basename $0`
farbe="1"
farbe1="#FFFFFF"
farbe2="#E7E7E7"
if [ -f /etc/timelog.conf ]
then
    . /etc/timelog.conf
    reload="$TIMELOG_RELOAD"
else
    reload="600"
fi

# Parameter parsen
for var in `echo "$QUERY_STRING" | tr '&' ' '`
do
    if echo "$var" | grep -v "=" > /dev/null ; then var="$var=yes" ; fi
    eval "P_$var"
done
if [ -z "$P_monat" ];
then
    P_monat="0";
fi
if [ -z "$P_jahr" ];
then
    P_jahr=0
fi
if [ -z "$P_graph" ];
then
    P_graph=0
fi

# Daten berechnen
THIS_JAHR=`date +%Y`
MONAT=`date +%m`
if [ "$MONAT" = "01" ]
then
    LMONAT=12
else
    LMONAT=`expr $MONAT - 1`
    if [ "$LMONAT" -le "9" ]
    then
        LMONAT=0$LMONAT
    fi
fi
TAG=`date +%d`
if [ "$TAG" != "01" ]
then
    GESTERN=`expr $TAG - 1`
    if [ "$GESTERN" -le "9" ]
    then
        GESTERN=0$GESTERN
    fi
else
        case "$MONAT" in
            01|05|07|10|12 )      GESTERN=30;;
            02|04|06|08|09|11 )               GESTERN=31;;
            03 )                        GESTERN=28;;
        esac
fi


echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store" # HTTP/1.1 (or no-cache?)
echo "Pragma: no-cache"        # HTTP/1.0
echo "Expires: `date -Ru`"     # Expires now!
echo "Refresh: $reload"
echo
echo "<html><head>"
echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"main.css\">"
echo "<meta HTTP-EQUIV=\"Refresh\" CONTENT=\"$reload;url=$myname?circuit=$P_circuit&graph=$P_graph&jahr=$P_jahr&monat=$P_monat&tag=$P_tag\">"
echo "<meta http-equiv=\"expires\" content=\"0\">"
echo "<meta http-equiv=\"pragma\" content=\"no-cache\">"
echo "<title>TimeLog</title></head>"
echo "<body alink=\"#0000FF\" vlink=\"#0000FF\" link=\"#0000FF\">"
echo "<b>OPT_TIMELOG</b><br><br>"
#echo "<!-- Jahr: $P_jahr akt. Jahr: $THIS_JAHR LM: $LMONAT M: $MONAT Gestern: $GESTERN Heute: $TAG         # just debug   ;-) -->"

if [ ! -f "/etc/timelog.conf" ]
then
     echo "<br><center><small>Keine Daten vorhanden (START_IMOND <u>und</u> IMOND_LOG auf 'yes'?).</small></center>"
     echo "<br><center><small>Diese Seite erneuert sich automatisch alle $reload Sekunden.</small></center>"
     echo "<center><small><a href=\"http://fli4l.emgame.de/\" target=\"_blank\">OPT_TimeLog</a> $TIMELOG_VER by Enrico Tr&ouml;ger</small></center>"
     echo "</body></html>"
     exit
else
    # Circuit-Wahl
    if [ -n "$ISDN_CIRCUITS_N" ]
    then
        echo "<span style=\"font-size: 11pt\">Bitte Circuit w&auml;hlen:&nbsp;"
        i=1
        while [ $i -le "$ISDN_CIRCUITS_N" ];
        do
            echo "<a href=\"$myname?circuit=`eval echo '$ISDN_CIRC_'${i}_NAME`&graph=$P_graph&jahr=$P_jahr&monat=$P_monat&tag=$P_tag\">`eval echo '$ISDN_CIRC_'${i}_NAME`</a>&nbsp;&nbsp;"
            i=`expr $i + 1`
        done
        echo "<a href=\"$myname?circuit=all&graph=$P_graph&jahr=$P_jahr&monat=$P_monat&tag=$P_tag\">Alle</a><br>"
    fi
fi

# Circuit-Wahl
if [ -n "$P_circuit" ]
then
        if [ -z "$P_circuit" ]
        then
            CIRCUIT="all"
            ANZ_CIRCUIT="Alle"
        else
            CIRCUIT="$P_circuit"
            if [ "$P_circuit" = "all" ]
            then
                ANZ_CIRCUIT="Alle"
            else
                ANZ_CIRCUIT="$P_circuit"
            fi
        fi
else
        if [ "$TIMELOG_CIRCUIT" -gt "0" ]
        then
            CIRCUIT=`eval echo '$ISDN_CIRC_'${TIMELOG_CIRCUIT}_NAME`
            ANZ_CIRCUIT="$CIRCUIT"
        else
            CIRCUIT="all"
            ANZ_CIRCUIT="Alle"
        fi
fi
echo "Gew&auml;hlter Circuit: $ANZ_CIRCUIT</span><br><br>"


# Tages-Ausgabe
if [ "$P_graph" != "1" -a "$P_monat" -gt "0" -a "$P_tag" -gt "0" ]
then

    #echo "<!-- /usr/local/bin/timelog -H "day" "$ANZ_CIRCUIT" "$P_jahr" "$P_monat" "$P_tag" -->"
    /usr/local/bin/timelog -H "day" "$ANZ_CIRCUIT" "$P_jahr" "$P_monat" "$P_tag"

fi

# Monats-Ausgabe
if [ "$P_graph" != "1" -a "$P_monat" -gt "0" -a "$P_tag" = "0" ]
then

    #echo "<!-- /usr/local/bin/timelog -H "month" "$ANZ_CIRCUIT" "$P_jahr" "$P_monat" -->"
    /usr/local/bin/timelog -H "month" "$ANZ_CIRCUIT" "$P_jahr" "$P_monat"

fi


# Jahres-Ansicht
if [ "$P_graph" != "1" -a "$P_jahr" -gt "0" -a "$P_monat" = "0"  ]
then

    #echo "<!-- /usr/local/bin/timelog -H "year" "$ANZ_CIRCUIT" "$P_jahr" -->"
    /usr/local/bin/timelog -H "year" "$ANZ_CIRCUIT" "$P_jahr"

fi


# Standard-Ausgabe
if [ "$P_graph" != "1" -a "$P_jahr" = "0" ]
then

    #echo "<!-- /usr/local/bin/timelog -H "sum" "$ANZ_CIRCUIT" "$LMONAT" "$GESTERN" -->"
    /usr/local/bin/timelog -H "sum" "$ANZ_CIRCUIT" "$LMONAT" "$GESTERN"

fi

# Grafik-Tages-Ausgabe
if [ "$P_graph" = "1" -a "$P_monat" -gt "0" -a "$P_tag" -gt "0" ]
then

    /usr/local/bin/timelog -H gday "$ANZ_CIRCUIT" "$P_jahr" "$P_monat" "$P_tag"

fi


# Grafik-Monats-Ausgabe
if [ "$P_graph" = "1" -a "$P_monat" -gt "0" -a "$P_tag" = "0" ]
then

    /usr/local/bin/timelog -H gmonth "$ANZ_CIRCUIT" "$P_jahr" "$P_monat"

fi


# Grafik-Jahres-Ansicht
if [ "$P_graph" = "1" -a "$P_jahr" -gt "0" -a "$P_monat" = "0" ]
then

    /usr/local/bin/timelog -H gyear "$ANZ_CIRCUIT" "$P_jahr"

fi


# Footer
echo "</table>"
echo "<span style=\"font-size: 10pt\"><br><br><center>Diese Seite erneuert sich automatisch alle $reload Sekunden, jetzt <a href=\"$myname?circuit=$P_circuit&jahr=$P_jahr&monat=$P_monat&tag=$P_tag\">neuladen</a>.</center>"
echo "<center><a href=\"http://fli4l.emgame.de/\" target=\"_blank\">OPT_TimeLog</a> $TIMELOG_VER by Enrico Tr&ouml;ger</span></center>"
echo "</body></html>"

