#include <sys/perm.h>
#include <sys/io.h>
//
// Refer to the National Semiconductor Datasheet for the 97317

#define SIO_GPIO_START 0x0fc0 //GPIO Register IO space
#define SIO_PM_START 0x0fc8 //PM Registers next to GPIO
#define SIO_INDEX 0x2e //io address of the SIO index register
#define SIO_DATA 0x2f //io address of the SIO data register
#define SIO_DEV_SEL 0x7
#define SIO_DEV_ENB 0x30
#define SIO_DEV_MSB 0x60
#define SIO_DEV_LSB 0x61
#define SIO_GP_DEV 0x7
#define SIO_PM_DEV 0x8
#define SIO_PM_BASE SIO_PM_START
#define SIO_PM_MSB (SIO_PM_BASE>>8)
#define SIO_PM_LSB (SIO_PM_BASE&0xff)
#define SIO_PM_INDEX (SIO_PM_BASE+0)
#define SIO_PM_DATA (SIO_PM_BASE+1)
#define SIO_PM_FER2 0x1
#define SIO_PM_GP_EN 0x80
#define SIO_GP_BASE SIO_GPIO_START
#define SIO_GP_MSB (SIO_GP_BASE>>8)
#define SIO_GP_LSB (SIO_GP_BASE&0xff)
// GPIO Register Bank 0
#define SIO_GP_DATA1 (SIO_GP_BASE)
#define SIO_GP_DIR1 (SIO_GP_BASE+1)
#define SIO_GP_OT1 (SIO_GP_BASE+2)
#define SIO_GP_PUC1 (SIO_GP_BASE+3)
// GPIO Register Bank 1
#define SIO_GP_LOCK1 (SIO_GP_BASE)
#define SIO_GP_I2O1 (SIO_GP_BASE+2)
#define GPIO10_MASK 1
#define GPIO_BANK_0 0 // mask of GPIO register bank 0 select bit in SIOC2
#define GPIO_BANK_1 0x80 // mask of GPIO register bank 1 select bit in SIOC2
#define OFF 1 // means a low on the GPIO which draws current
// through the LED, thus lighting it
#define ON 0


int main(int argc, char **argv)
{
   iopl(3);

   /*
    * First, we have to initialize the 317 part to allow us access
    * to the GPIO registers.
    */
   outb_p(SIO_DEV_SEL, SIO_INDEX);
   outb_p(SIO_GP_DEV, SIO_DATA); /* Talk to GPIO regs. */
   outb_p(SIO_DEV_MSB, SIO_INDEX);
   outb_p(SIO_GP_MSB, SIO_DATA); /* MSB of GPIO base address */
   outb_p(SIO_DEV_LSB, SIO_INDEX);
   outb_p(SIO_GP_LSB, SIO_DATA); /* LSB of GPIO base address */
   outb_p(SIO_DEV_ENB, SIO_INDEX);
   outb_p(1, SIO_DATA); /* Enable GPIO registers. */

   /*
    * Now, we have to map the power management section to write
    * a bit which enables access to the GPIO registers.
    */
   outb(SIO_DEV_SEL, SIO_INDEX);
   outb(SIO_PM_DEV, SIO_DATA); /* Talk to GPIO regs. */
   outb(SIO_DEV_MSB, SIO_INDEX);
   outb(SIO_PM_MSB, SIO_DATA); /* MSB of PM base address */
   outb(SIO_DEV_LSB, SIO_INDEX);
   outb(SIO_PM_LSB, SIO_DATA); /* LSB of PM base address */
   outb(SIO_DEV_ENB, SIO_INDEX);
   outb(1, SIO_DATA); /* Enable PM registers. */

   /*
    * Now, write the PM register which enables the GPIO registers.
    */
   outb(SIO_PM_FER2, SIO_PM_INDEX);
   outb(SIO_PM_GP_EN, SIO_PM_DATA);
   outb(GPIO10_MASK,SIO_GP_DIR1); // set GPIO10 direction to output


   /*
    * Now, we will switch the LED on or off...
    */
   if (argc == 2 && strcasecmp(argv[1], "on") == 0)
   {
      outb(ON,SIO_GP_DATA1);  // turn the light ON
   }
   else if (argc == 2 && strcasecmp(argv[1], "off") == 0)
   {
      outb(OFF,SIO_GP_DATA1); // turn the light OFF
   }
   else
   {
      printf("Usage: jntled [on|off]\n");
      printf("Switch the Online LED of the JNT Surfstation on or off.\n");
   }

   return 0;
}

