#!/bin/sh
#------------------------------------------------------------------------------
# main_ISDNFaxe.cgi - display received faxes from OPT_FAXRCV
# Based on main_Faxe.cgi, created 17.02.2001 by mh
# 
# Last Change: 14.04.2002 fe <felix@tribut.de> 
#                nderungen fr Kompatibilitt mit OPT_FAXRCV
#
#------------------------------------------------------------------------------

SEC_REALM='isdnfax'
if [ "$QUERY_STRING" = "DEL" -o "$QUERY_STRING" = "HIDE" ] 
then
  SEC_ACTION='delete'
else
  SEC_ACTION='view'
fi

. sec-lib.cgi
. /etc/rc.cfg

if [ "$FAXRCV_IMONC_LIST" != 0 ]
then
    eval FAXRCV_DIRECTORY='$FAXRCV_'$FAXRCV_IMONC_LIST'_DIRECTORY'
else
    eval FAXRCV_DIRECTORY='$FAXRCV_'$FAXRCV_HTTPGUI_USER'_DIRECTORY'
fi

RTIME=10

if [ "$QUERY_STRING" = "" ] ; then

    echo "Content-Type: text/html; charset=iso-8859-1"
    echo "Cache-control: no-store"   # HTTP/1.1 (or no-cache?)
    echo "Pragma: no-cache"          # HTTP/1.0
    echo "Expires: `/bin/date -Ru`"  # Expires now!
    echo "Refresh: $RTIME"
    echo
    echo "<html><body><center><h3>Empfangene Faxe (ISDN)</h3>"

    if [ -f $FAXRCV_DIRECTORY/mfax.log ] ; then

        echo "<table border><tr><th>Datum</th><th>Zeit</th><th>Fax-ID</th>
          <th>Seiten</th><th>Fax-Datei</th></tr>"

        while read d z i p f
        do
            echo "<tr><td>$d</td><td>$z</td><td>$i</td>
              <td>$p</td><td><a href=\"$0?$f\">$f</a></td></tr>"
        done < $FAXRCV_DIRECTORY/mfax.log

        echo "</tr></table><p><a href=\"$0?DEL\">Alle Lschen</a>"
        echo "<br><a href=\"$0?HIDE\">Alle Verbergen</a> (aus der Weboberflche "
        echo "entfernen, ohne sie von der HD zu lschen)"

    else
        echo "<br><br><b>Habe keine Faxe vorliegen.<b>"
    fi

    echo "</center></body></html>"

elif [ "$QUERY_STRING" = "DEL" ] ; then
    while read d z i p f
    do
        /bin/rm $FAXRCV_DIRECTORY/$f.gz
    done < $FAXRCV_DIRECTORY/mfax.log
    /bin/rm $FAXRCV_DIRECTORY/mfax.log
    echo "Location: $0"
    echo
elif [ "$QUERY_STRING" = "HIDE" ] ; then
    /bin/rm $FAXRCV_DIRECTORY/mfax.log
    echo "Location: $0"
    echo
else
    FAX=$QUERY_STRING
    echo "Content-Type: image/x-portable-bitmap"
    echo "Content-Disposition: attachment; filename=$FAX"
    echo
    /usr/local/bin/gzip -cd $FAXRCV_DIRECTORY/$FAX.gz
fi
