#!/bin/sh
#------------------------------------------------------------------------------
# unimount.cgi - Mountet und Dismountet Volumes, CD's und Shares
# Ver. 2.09

eval "`proccgi $*`"

. /var/run/unimount.cfg

RTIME=20

myname=`basename $0`

echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store" # HTTP/1.1 (or no-cache?)
echo "Pragma: no-cache"        # HTTP/1.0
echo "Expires: `date -Ru`"     # Expires now!
echo
echo "<html><head>"
echo '<LINK REL=STYLESHEET TYPE="text/css" HREF="../main.css">'
echo "<meta http-equiv="expires" content="0">" 
echo "<meta HTTP-EQUIV=\"Refresh\" CONTENT=\"$RTIME;URL=$myname\">"
echo "<title>Mounter</title>"
echo "</head><body>"
echo "<h2>Universal Mounter&nbsp;<font size=1>&copy;2003 <a href=mailto:info@herleb.de>Marcus Herleb</a></font></h2>"
if [ "$mount_n" = "0" -a "$mount_info" = "no" ] 
   then 
   echo "<h2>Es wurden keine Mount Devices definiert ...<br>
    ... Mount-Info ist ebenfalls deaktiviert.</h2>"	
fi  
echo "<pre>" 
echo "<p><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td valign=\"top\">"\ 
echo "<p><table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" bgcolor=\"#000000\">"
if [ "$mount_n" != "0" ] 
then
echo "<tr bgcolor=\"#ffffc0\"><th>Name</th><th>Device/Volume</th><th>Directory</th><th>option</th><th>Type</th><th>Status</th><th>&nbsp;</th></tr>"

ROWCOLOR="#e9e9e9"

i=1

while [ $mount_n -ge $i ]
do
 eval mount_name='$mount_name_'$i
 eval mount_device='$mount_device_'$i
 eval mount_point='$mount_point_'$i
 eval mount_option='$mount_option_'$i
 eval mount_type='$mount_type_'$i
  if [ "$mount_type" = "smbfs" ]
  then
   eval mount_username='$mount_username_'$i
   eval mount_password='$mount_password_'$i
 fi 
 
 if [ "$mount_option" = "ro" ]
  then
     mount_option="ro"
 elif [ "$mount_option" = "???" ]
  then
     mount_option="???" 
 else
    mount_option="rw"
 fi 
 if [ "$FORM_action" = "mount" ]
  then
    if [ "$FORM_id" = "$i" ]
     then
       if [ "$mount_option" = "rw" ]
        then 
          parameter="-rw"
       else
          parameter="-ro"
       fi
         
   if [ "$mount_type" = "ext2" -o "$mount_type" = "smbfs" ] 
    then
      parameter="-t $mount_type"
      if [ "$mount_type" = "smbfs" ]
       then
        parameter="$parameter -o username=$mount_username,password=$mount_password"
      fi 
   else   
      parameter="$parameter"
   fi   
      parameter="$parameter $mount_device $mount_point"
     
     #   echo "mount $parameter"
     mount $parameter
      
   fi
 fi

 if [ "$FORM_action" = "umount" ] 
 then
  if [ "$FORM_id" = "$i" ]
  then
   umount $mount_point
  fi
 fi

mount | grep $mount_point  > /dev/null
if [ "$?" != "0" ]; then 
  startstopurl="<a href=\"$myname?action=mount&id=$i\">Laden</a>"
  status='nicht geladen'
  image="cross.gif"
  else
  status='geladen'
  startstopurl="<a href=\"$myname?action=umount&id=$i\">Entladen</a>"
  image="ongreen.gif"
  
fi
if [ "$ROWCOLOR" = "#ffffff" ]
          then
            ROWCOLOR="#e9e9e9"
          else
            ROWCOLOR="#ffffff"
fi

 echo " <tr bgcolor=$ROWCOLOR>"
 echo "  <td>$mount_name</td><td>$mount_device</td><td>$mount_point</td><td>$mount_option</td><td>$mount_type</td>"
 echo "  <td align="center"><img border="0" src="$image" title='$status' width="20" height="20"></td>"
 echo "  <td>$startstopurl</td>"
 echo " </tr>"
 
i=`expr $i + 1`
done
else echo
fi
if [ "$mount_info" = "yes" ]
  then
    echo "<tr bgcolor=\"#ffffc0\"><th><b>Mount - Info</b></th><th>Device/Volume</th><th>Gr&ouml;sse</th><th>Belegt</th><th>Verf&uuml;gbar</th><th>Belegt in %</th><th>unimount ?</th></tr>"
    ROWCOLOR="#e9e9e9"
    i=1
    /bin/df -h | grep -v "Available" | while read Filesystem Size Used Available Use2 Mounted

    do

    if [ "$ROWCOLOR" = "#ffffff" ]
          then
            ROWCOLOR="#e9e9e9"
          else
            ROWCOLOR="#ffffff" 
    fi

     echo " <tr bgcolor=$ROWCOLOR>"
    if [ "$Filesystem" = "Filesystem" ]
      then
        echo
    else 
      if [ "$Filesystem" = "/dev/ram" ]   
       then 
        Info='fli4l rootfs'
      elif [ "$Mounted" = "/boot" ]   
       then 
        Info='BOOT Partition'
      elif [ "$Mounted" = "/opt" ]   
       then 
        Info='OPT Partition'
      elif [ "$Filesystem" = "/dev/hda4" -o "$Filesystem" = "/dev/sda4" ]   
       then 
        Info='Partition der ersten HD' 
      else        
        Info=''  
      fi    
   if [ "$Filesystem" = "$mount_device_1" -o "$Filesystem" = "$mount_device_2" -o "$Filesystem" = "$mount_device_3" -o "$Filesystem" = "$mount_device_4" -o "$Filesystem" = "$mount_device_5" -o "$Filesystem" = "$mount_device_6" -o "$Filesystem" = "$mount_device_7" -o "$Filesystem" = "$mount_device_8" -o "$Filesystem" = "$mount_device_9" -o "$Filesystem" = "$mount_device_10" ]
 	then
 	    image="ongreen.gif"
 	    text="durch Unimount gemountet, kann entladen werden"
        else
            image="cross.gif"
            text="ist ein Systemmount"
 	    
 fi
     echo "  <td>$Info</td><td>$Filesystem</td><td>$Size</td><td>$Used</td><td>$Available</td><td>$Use2</td><td align="center"><img border="0" src='$image' title='$text' width="20" height="20"></td>"     
 fi
  done  
fi 
echo "</tr></table></body></html>"
exit 1
