#! /bin/sh
#------------------------------------------------------------------------------
# Creates a new opt.tgz concerning to the configuration in config/
#
# $Id: mktgz.sh,v 1.5 2003/06/03 20:47:18 jw5 Exp $
#------------------------------------------------------------------------------

while [ 1 ]
do
    case "$1"
    in
	-?)
	    echo "usage: $0 [config-directory]" >&2;
	    exit 1
	    ;;
	*)
	    break
	    ;;
    esac
done

if [ "$1" != "" -a "$1" ]
then
    echo "using configuration directory $1 ..."
    config_dir=$1
else
    config_dir=config
fi

set -e						# exit on error

cd unix
make mkfli4l
cd ..

unix/mkfli4l -c $config_dir

rm -f $config_dir/config.tar.gz
tar --owner=root --group=root -c -v -f $config_dir/config.tar $config_dir/*.txt
gzip -9 $config_dir/config.tar
mv $config_dir/config.tar.gz opt/etc/config.tgz

rm -f $config_dir/config.tar.gz
tar --owner=root --group=root -c -v -f $config_dir/config.tar $config_dir/*.txt
gzip -9 $config_dir/config.tar
mv $config_dir/config.tar.gz opt/etc/config.tgz

echo "creating compressed tar archive..."
cd opt
rm -f ../img/opt.tgz ../img/opt.tar
sort opt.tmp | tar --owner=root --group=root -c -v -T - -f ../img/opt.tar
gzip -9 ../img/opt.tar
mv ../img/opt.tar.gz ../img/opt.tgz
rm -f opt.tmp

cp ./etc/rc.cfg ../img/rc.cfg
