#! /bin/sh
#------------------------------------------------------------------------------
# Creates a fli4l-Floppy
# use the -h option for 1680 kB formatted floppies
#
# $Id: mkfloppy.sh,v 1.1.1.1.2.4 2002/10/15 11:56:15 fm Exp $
#------------------------------------------------------------------------------

suffix=''					# fast but not safe
size=1440					# default size: 1440 KB
syslinux=syslinux1440.cfg                       # default cfg
fd0=/dev/fd0                                    # default device: generic fd0

while [ 1 ]
do
    case "$1"
    in
	-h)					# higher density
	    size='1680'
	    fd0=/dev/fd0u1680
	    syslinux=syslinux1680.cfg
	    suffix='-s'				# here: slow, safe and stupid
	    shift
	    ;;
	-s)					# slow stupid safe
	    suffix='-s'
	    shift
	    ;;
	-?)
	    echo "usage: $0 [-h] [-s] [config-directory]" >&2;
	    exit 1
	    ;;
	*)
	    break
	    ;;
    esac
done

if [ "$1" != "" ]
then
    echo "using configuration directory $1 ..."
    config_dir=$1
else
    config_dir=config
fi

set -e						# exit on error

cd unix
make mkfli4l
cd ..

unix/mkfli4l $config_dir

rm -f $config_dir/config.tar.gz
tar --owner=root --group=root -c -v -f $config_dir/config.tar $config_dir/*.txt
gzip -9 $config_dir/config.tar
mv $config_dir/config.tar.gz opt/etc/config.tgz

echo "creating compressed tar archive..."
cd opt
rm -f ../img/opt.tgz ../img/opt.tar
sort opt.tmp | tar --owner=root --group=root -c -v -T - -f ../img/opt.tar
gzip -9 ../img/opt.tar
mv ../img/opt.tar.gz ../img/opt.tgz
rm -f opt.tmp

cp ./etc/rc.cfg ../img/rc.cfg

cd ../img

fat_image_file=fd$size$suffix.gz

echo "writing FAT and system files ..."
gzip -d <$fat_image_file >$fd0

echo "copying syslinux.cfg ..."
mcopy -o $syslinux a:SYSLINUX.CFG

echo "copying kernel ..."
mcopy -o kernel a:KERNEL

echo "copying rootfs.gz ..."
mcopy -o rootfs.gz a:ROOTFS.GZ

echo "copying rc.cfg ..."
mcopy -o rc.cfg a:RC.CFG

echo "copying opt.tgz ..."
mcopy -o opt.tgz a:OPT.TGZ
