#!/bin/sh
#------------------------------------------------------------------------------
# vtund.cgi - check and/or control the vtund tunnels
#
# (c) copyright 2003 Markus Reile
#
# Creation:    2003/05/03 mr
# Update:	   2003/08/07 mr: update for fli4l 2.1.3, no sudo involved anymore
#------------------------------------------------------------------------------

myname=`basename $0`

#parse variables...
for var in `echo "$QUERY_STRING" | tr '&' ' '`
do
 if echo "$var" | grep -v "=" > /dev/null ; then var="$var=yes" ; fi
 eval "param_$var"
done

# Get server PID(s) - from gui-file and ps-list
get_server_pid()
{
  name=`cat $1 | cut -d " " -f1`
  port=`cat $1 | cut -d " " -f2`
  # analyze the stati of the servers
  # If a server is started with option MULTI='yes', the server can run new instances
  # The saved PID is the one of the initial server
  # If this server is supposed to be stopped, all instances have to be stopped!
  # Therefore all PIDs have to be found out.
  # If a running server is started one more time: nothing happens
  pid_name=`echo $1 | /usr/bin/sed "s#gui#pid#"`
  if [ -f "$pid_name" ]
  then
    pid=`cat $pid_name`
    status=`ps | grep -v grep | grep $pid | grep "vtund\[s\]" | /usr/bin/sed 's#.*vtund#vtund#'`
    if [ -n "$status" ]
    then # "master-server" is running, look for child processes
      status=$status"`ps | grep -v grep | grep $name | grep "vtund\[s\]" | /usr/bin/sed 's#.*vtund#<BR>vtund#' | /usr/bin/sed 's/^\<BR\>//'`"
      child_ps=`ps | grep -v grep | grep $name | grep "vtund\[s\]"`
      # add all the child PIDs to $pid
      for i in $child_ps 
      do
        if [ "$i" = "root" ]
        then
          pid="$pid $j"
        fi
        j=$i
      done
    else
      status="not running"
    fi
  else
    status="unknown (no PID file found)"
  fi
}


# execute commands
if [ -n "$param_vtund" -a ! \( "_$param_vtund" = "_$param_lastvtund" -a "_$param_guifile" = "_$param_lastguifile" \) -a ! -f /var/lock/vtund.cgi ]
then
  # lock vtund.cgi (if another option is clicked while waiting on result)
  echo "locked" > /var/lock/vtund.cgi
  # values, that a start/stop cannot be performed twice by clicking "reload" in the browser
  param_lastvtund=$param_vtund
  param_lastguifile=$param_guifile
  # read gui-file
  name=`cat $param_guifile | cut -d " " -f1`
  port=`cat $param_guifile | cut -d " " -f2`
  server=`cat $param_guifile | cut -d " " -f3`

  case $param_vtund in
  start_vtunds)
    message2="Started server $name"
    /usr/bin/vtund -s -f `echo $param_guifile | /usr/bin/sed "s#gui#conf#"` $name
    /bin/mv /var/run/vtund.pid `echo $param_guifile | /usr/bin/sed "s#gui#pid#"`
  ;;
  stop_vtunds)
    message2="Stopped server $name"
    get_server_pid $param_guifile
    /bin/kill -9 $pid
  ;;
  start_vtundc)
    message2="Started client $name"
    /usr/bin/vtund -f `echo $param_guifile | /usr/bin/sed "s#gui#conf#"` -P $port $name $server
  ;;
  stop_vtundc)
    message2="Stopped client $name"
    pid=`ps | grep -v grep | grep "vtund\[c\]\: $name " | /usr/bin/sed "s#^\ *##" | cut -d" " -f1`
    /bin/kill -9 $pid
  ;;
  esac
  # Waiting for execution
  rm /var/lock/vtund.cgi
else
  message2="Configuration not changed"
fi  


cat << HEAD
Content-Type: text/html; charset=iso-8859-1
Cache-control: no-store
Pragma: no-cache
Expires: `date -Ru`

<html><head>
<LINK REL=STYLESHEET TYPE="text/css" HREF="main.css">
<title>Check/Control vtund</title>
</head><body>

<table border="0" width="95%" cellspacing="0" cellpadding="0" align="center"><tr>
<th align="left" bgcolor="#C0C0C0"><b>Check and control the status of the vtund tunnels</b></th>
</tr>

<tr><td>
This table shows all vtund servers installed on the router
</td></tr>

<tr><td>
<table width="100%" border="1" cellpadding="5">
<tr><th align="left">Name</th><th align="left">Port</th><th align="left">Status</th></tr>
HEAD

# Status of vtund[s]

for fn in /var/run/vtund_s_*.gui
do
  if [ -f "$fn" ]
  then
    get_server_pid $fn
    # HREF vtund[s]
    if [ -n "`echo $status | grep 'not running'`" -o -n "`echo $status | grep 'no PID'`" ] 
    then 
      name="<A HREF=\"$myname?vtund=start_vtunds&guifile=$fn&lastvtund=$param_lastvtund&lastguifile=$param_lastguifile\">$name</A>"
    else
      name="<A HREF=\"$myname?vtund=stop_vtunds&guifile=$fn&lastvtund=$param_lastvtund&lastguifile=$param_lastguifile\">$name</A>"
    fi
    echo "<tr><td align=\"left\">$name</td><td align=\"left\">$port</td><td align=\"left\">$status</td>"
  fi
done

# Status of vtund[c]
echo "</table></td></tr>"

cat << CLIENTS
<tr><td>
This table shows all vtund clients installed on the router
</td></tr>

<tr><td>
<table width="100%" border="1" cellpadding="5">
<tr><th align="left">Name</th><th align="left">Port</th><th align="left">assigned Server</th><th align="left">Status</th></tr>
CLIENTS

for fn in /var/run/vtund_c_*.gui
do
  if [ -f "$fn" ]
  then
    name=`cat $fn | cut -d " " -f1`
    port=`cat $fn | cut -d " " -f2`
    server=`cat $fn | cut -d " " -f3`
    # analyze the stati of the clients
    #   don't check any produced PID file, because the client can be found
    #   exactly by grepping the ps list - there can be just one client (or none client :)
    pid=`ps | grep -v grep | grep "vtund\[c\]\: $name " | /usr/bin/sed "s#^\ *##" | cut -d" " -f1`
    if [ -n "$pid" ]
    then
      status="`ps | grep -v grep | grep $pid | grep "vtund\[c\]\: $name " | /usr/bin/sed 's#.*vtund#<BR>vtund#' | /usr/bin/sed 's/^<BR>//' `"
      name="<A HREF=\"$myname?vtund=stop_vtundc&guifile=$fn&lastvtund=$param_lastvtund&lastguifile=$param_lastguifile\">$name</A>"
    else
      status="not running"
      name="<A HREF=\"$myname?vtund=start_vtundc&guifile=$fn&lastvtund=$param_lastvtund&lastguifile=$param_lastguifile\">$name</A>"
    fi
    echo "<tr><td align=\"left\">$name</td><td align=\"left\">$port</td><td align=\"left\">$server</td><td align=\"left\">$status</td>"
  fi
done
echo "</table></td></tr>"

# Command window
cat << COMMAND
<tr><td>
This box shows the last command
</td></tr>
<tr><td>
<table width="100%" border="1" cellpadding="5">
<tr><td>$message2</td></tr></table></td></tr>
COMMAND

echo "</table></body></html>"
exit



