#!/bin/sh
#------------------------------------------------------------------------------
# /etc/rc.d/rc910.ssmtp_retry                                              v0.1
#
# Mails mit Status "retry" versenden
#
# Creation:     2003-05-05  t_klingl
# Last Update:  2003-05-20  t_klingl
#------------------------------------------------------------------------------

#----------------------------------------------------
# Variablen inkludieren
#----------------------------------------------------

. /etc/ssmtp/ssmtp_skripte.conf
DATE=`date`

#----------------------------------------------------
# Welche Dateien liegen vor ?
#----------------------------------------------------
for FILES in `ls ${SSMTP_SPOOL_DIR} | grep '^.*retry[0-9]\+$'`
do
	/usr/local/bin/ssmtp_send.sh "${FILES}"
	
	if [ "$?" = "0" ];
	then
	    # alles ok, file kann geloescht werden
		if [ "${SSMTP_LOGFILE}" != "" ];
		then
		    echo "ssmtp: mail ${FILES} sent successfully on ${DATE}" >> ${SSMTP_LOGFILE}
	    if
	    rm "${FILES}"
	else
	    # Versand gescheitert, ins Logfile eintragen
	    # Anzahl der Wiederholungsversuche & neuen Namen ermitteln
	    TRY=`echo "${FILES}" | sed 's/^\(.*\.retry\)\(.*\)$/\2/g' | sed 's/[^0-9]//g'`
	    BASE=`echo "${FILES}" | sed 's/^\(.*\.retry\)\(.*\)$/\1/g'`
	    NEXTTRY=`expr ${TRY} + 1`
	    
	    if [ "${SSMTP_LOGFILE}" != "" ];
	    then
	    	echo "ssmtp: error sending mail ${FILES} ($?), trail ${TRY} on ${DATE}" >> ${SSMTP_LOGFILE}
	    fi	  	
		echo "ssmtp: error sending mail ${FILES} ($?), trail ${TRY} on ${DATE}"
	    mv "${FILES}" "${BASE}${NEXTTRY}"
	fi
done

exit 0

