#!/bin/sh

. /etc/rc.cfg

# kennen wir das System
if [ -f $HTTP_LEASES_FILE ]; then
        localleases=$HTTP_LEASES_FILE
else
        echo "Bist Du sicher, das du DHCP benutzt?"
        exit 0
fi
myname=`basename $0`

echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store" # HTTP/1.1 (or no-cache?)
echo "Pragma: no-cache"        # HTTP/1.0
echo "Expires: `date -Ru`"     # Expires now!
echo
echo "<head><title>"$myname
echo "</title></head><html>"
echo "<br>" 
echo "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" width=\"90%\" bgcolor=\"f0f0f0\" bordercolor=\"ffffff\" align=\"center\">"
echo "<tr bgcolor=\"000000\">"
echo "    <td colspan=\"6\">"
echo "        <div align=\"center\"><font color=\"ffffff\"><b>aktive leases</b></font><div>"
echo "    </td>"
echo "</tr>"
echo "<tr><td><center><b>IP</center></b></td><td><center><b>MAC</center></b></td><td><center><b>Host</center></b></td><td><center><b>Vergeben am</center></b></td><td><center><b>Gltig bis</center></b></td></tr>"

cat $localleases | sed 's/\"//g;' > /tmp/leases.hosts_dhcp

while read line
do
 if [ "`echo $line | cut -d" " -f1`" = "lease" ]
 then
  ip="`echo $line | cut -d" " -f2`"
  hostname="--Keiner--"
 fi
 if [ "`echo $line | cut -d" " -f1`" = "starts" ]
 then
  starts="`echo $line | cut -d" " -f3`"
  starts_time="`echo $line | cut -d" " -f4 | sed 's/;/\ /g'`"
 fi
 if [ "`echo $line | cut -d" " -f1`" = "ends" ]
 then
  ends="`echo $line | cut -d" " -f3`"
  ends_time="`echo $line | cut -d" " -f4 | sed 's/;/\ /g'`"
 fi
 if [ "`echo $line | cut -d" " -f1`" = "hardware" ]
 then
  mac="`echo $line | cut -d" " -f3 | cut -d";" -f1`"
 fi
 if [ "`echo $line | cut -d" " -f1`" = "client-hostname" ]
 then
  hostname="`echo $line | cut -d" " -f2 | cut -d";" -f1`"
 fi
 if [ "`echo $line | cut -d" " -f1`" = "}" ]
 then
  echo " <tr><td>$ip</td><td>$mac</td><td>$hostname</td><td>$starts $starts_time</td><td>$ends $ends_time</td>"
 fi
done < /tmp/leases.hosts_dhcp

echo "</table>"

echo "<br><br><br># All times in this file are in UTC (GMT), not your local timezone.   This is<br>"
echo "# not a bug, so please don't ask about it.   There is no portable way to<br>"
echo "# store leases in the local timezone, so please don't request this as a<br>"
echo "# feature.   If this is inconvenient or confusing to you, we sincerely<br>"
echo "# apologize.   Seriously, though - don't ask.<br>"
echo "# The format of this file is documented in the dhcpd.leases(5) manual page.<br><br>"
echo '<font size="-1">By Christopher Kreitz <a href="mailto:fli4l@romses.de"><font face="MS Sans Serif">fli4l@romses.de</font></a></font>'


rm /tmp/leases.* 

# HTML Ende 
echo "</body></html>"