# !/bin/sh

#-------------------------------------------------------------------------
# /opt/files/usr/local/bin/faxprint.sh - druck von gzipten sff dateien
#
# Creation:	30.10.2002 	Initialversion				VER: 0.1
# 	 	 4.11.2002 	Doku- und Kommentarnderungen
#				Debugoptionen implementiert		VER: 0.2
#		 8.11.2002  Druckpositionierung implementiert	VER: 0.4
#		10.11.2002	absolute Pfade fr die .ps Dateien  VER: 0.5
#		30.05.2003  rem $1.prn im -t Abschnitt eingefgt  VER: 0.7
#-------------------------------------------------------------------------



# her mit den Variablen
. /etc/rc.cfg



# falscher Aufruf oder Hilfe?
if [ "$1" = "" ] || [ "$1" = "-h" ]  || [ "$1" = "-?" ]
	then
		echo "usage $0 filename [-h | -t | -a]"
		echo "      -h = help"
		echo "      -a = Testausdruck (align.ps) zur Marginjustage"
		echo "      -t = Testasudruck (margin.ps und align.ps) inkl. Marginjustage"
		exit 0
	fi




if [ "$1" = "-a" ]
	then
		gs -sDEVICE=$FAXPRINT_PRINTER_TYP -sOutputFile=$1.prn -dBATCH -dNOPAUSE -q /opt/files/usr/local/bin/align.ps
		lpr -P$FAXPRINT_PRINTER_QUEUE $1.prn
		rm $1.prn
		exit 0
	fi

if [ "$1" = "-t" ]
	then
		gs -sDEVICE=$FAXPRINT_PRINTER_TYP -sOutputFile=$1.prn -dBATCH -dNOPAUSE -q /opt/files/usr/local/bin/margins.ps /opt/files/usr/local/bin/align.ps
		lpr -P$FAXPRINT_PRINTER_QUEUE $1.prn
		rm $1.prn
		exit 0
	fi



# Debug oder doch nicht
if [ "$FAXPRINT_DO_DEBUG" = yes ]
	then
		set -x
	fi



{
# auspacken
cat $1 | gzip -d >$1.sff

# ein Postscriptfile draus machen
sff2misc -p $1.sff $1

# eine fr den Drucker passendes File draus machen
gs -sDEVICE=$FAXPRINT_PRINTER_TYP -sOutputFile=$1.prn -dBATCH -dNOPAUSE -q /opt/files/usr/local/bin/margins.ps $1.ps

# und ab zum Drucker
lpr -P$FAXPRINT_PRINTER_QUEUE $1.prn

logger -is FAX $1 auf $FAXPRINT_PRINTER_QUEUE gedruckt

# Muell aufraeumen
rm $1.sff
rm $1.prn
rm $1.ps

} | logger -is
# Debug wieder aus
set +x