#import "menubarThingyView.h"

@implementation menubarThingyView

- initWithFrame:(NSRect)aRect menuExtra:aMenuExtra
{
    if (!(self = [super initWithFrame:aRect])) return nil;

    menuExtra = aMenuExtra;
	
	online_channels = 0;

	path_in = [[NSBezierPath alloc] init];
	path_out = [[NSBezierPath alloc] init];
	[path_in setLineWidth: 1.0];
	[path_out setLineWidth: 1.0];
	
	long i;
	for (i=0; i<maximum_percents; i++)
	{
		percent_in[i]=0;
		percent_out[i]=0;
	};

    return self;
}

- (void)drawRect:(NSRect)rect
{
	[[menuExtra image] compositeToPoint:NSMakePoint(0, 0) operation:NSCompositeSourceOver];

	if (online_channels > 0)
	{
		CGContextRef currentContext = (CGContextRef)[[NSGraphicsContext currentContext] graphicsPort];
		CGContextSelectFont(currentContext, "Times-Roman", 1.0, kCGEncodingMacRoman);
		NSString *str=[NSString stringWithFormat:@"%i",online_channels];
		CGContextShowTextAtPoint(currentContext, 6, 6, [str cString], [str length]);
	}

	[[NSColor redColor] set];
	[path_out stroke];
	[[NSColor greenColor] set];
	[path_in stroke];
}

- (void) setPercentageIn:(double)pin Out:(double)pout;
{
	long i=0;
	for (i=0; i<maximum_percents-1; i++)
	{
		percent_in[i]=percent_in[i+1];
		percent_out[i]=percent_out[i+1];
	}
	
	percent_in[maximum_percents-1] = pin;
	percent_out[maximum_percents-1] = pout;

	[path_in removeAllPoints];
	[path_out removeAllPoints];

	i=0;
	for (i=0; i<maximum_percents-averaging_percents; i++)
	{
		long j=0;
		double av_in=0.0;
		double av_out=0.0;
		for (j=0; j<averaging_percents; j++)
		{
			av_in += percent_in[i+j];
			av_out += percent_out[i+j];
		}
		av_in /= averaging_percents;
		av_out /= averaging_percents;
		
		[path_in moveToPoint:  NSMakePoint(1+i,2)];
		[path_in lineToPoint:  NSMakePoint(1+i,2 +  av_in*18)];
		[path_out moveToPoint: NSMakePoint(1+i,2 +  av_in*18)];
		[path_out lineToPoint: NSMakePoint(1+i,2 + (av_in+av_out)*18)];
	}
}

- (void) setOnlineChannels:(int)s
{
	online_channels=s;
}

@end
