/*
 MultiImonC - a multiplatform imonc for fli4l
 Copyright (C) 2003, 2004 Michael Hanselmann

 Based on:
 md5.h - Compute MD5 checksum of files or strings according to the
          definition of MD5 in RFC 1321 from April 1992.
 Copyright (C) 1995-1999 Free Software Foundation, Inc.
 
 Written by Ulrich Drepper <drepper@gnu.ai.mit.edu>
 Hacked to work with BusyBox by Alfred M. Szmidt <ams@trillian.itslinux.org>
 Stripped down for fli4l by Tobias Greutzmacher <fli4l@portfolio16.de>
 Ported to C++ by Michael Hanselmann
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
 $Id: Md5.h,v 1.3 2004/07/10 19:25:38 michael Exp $
 */

#include <iostream>
#include <string>
#include <cstdio>

class Md5 {
public:
	std::string operator()(const FILE* i_pFile);
	std::string operator()(const std::string i_strValue);
	std::string operator()(const void* i_pObject, const size_t i_sSize);
private:
	std::string ToHex(unsigned char* c_value);
  
    // md5.h - Declaration of functions and data types used for MD5 sum
    // computing library functions.
    typedef u_int32_t md5_uint32;
    
    // Structure to save state of computation between the single steps.
    struct md5_ctx {
        md5_uint32 A;
        md5_uint32 B;
        md5_uint32 C;
        md5_uint32 D;
        
        md5_uint32 total[2];
        md5_uint32 buflen;
        char buffer[128];
    };
    
    /*
     * The following three functions are build up the low level used in
     * the functions `md5_stream' and `md5_buffer'.
     */
    
    /* Initialize structure containing state of computation.
        (RFC 1321, 3.3: Step 3)  */
    void md5_init_ctx(struct md5_ctx * ctx);

    /* Starting with the result of former calls of this function (or the
        initialization function update the context for the next LEN bytes
        starting at BUFFER.
        It is necessary that LEN is a multiple of 64! */
    void md5_process_block(const void *buffer, size_t len,
						   struct md5_ctx * ctx);
    
    /* Starting with the result of former calls of this function (or the
        initialization function update the context for the next LEN bytes
        starting at BUFFER.
        It is NOT required that LEN is a multiple of 64.  */
    void md5_process_bytes(const void *buffer, size_t len,
						   struct md5_ctx * ctx);
    
    /* Process the remaining bytes in the buffer and put result from CTX
        in first 16 bytes following RESBUF.  The result is always in little
        endian byte order, so that a byte-wise output yields to the wanted
        ASCII representation of the message digest.
        
        IMPORTANT: On some systems it is required that RESBUF is correctly
        aligned for a 32 bits value.  */
    void *md5_finish_ctx(struct md5_ctx * ctx, void *resbuf);
    
    
    /* Compute MD5 message digest for bytes read from STREAM.  The
        resulting message digest number will be written into the 16 bytes
        beginning at RESBLOCK.  */
    int md5_stream(const FILE * stream, void *resblock);
    
    /* Compute MD5 message digest for LEN bytes beginning at BUFFER.  The
        result is always in little endian byte order, so that a byte-wise
        output yields to the wanted ASCII representation of the message
        digest.  */
    void *md5_buffer(const char *buffer, size_t len, void *resblock);
};
