/*
	to test the recompiled menu, do in Terminal:

		sudo killall SystemUIServer

	and the new menu will be loaded. * Quitting is not enough *
*/

#import "menubarThingyView.h"
#import "menubarThingy.h"
#include <ImonC.h>
#include "SystemConfiguration.framework/Headers/SCPreferences.h"
#include "SystemConfiguration.framework/Headers/SCSchemaDefinitions.h"
#include "SystemConfiguration.framework/Headers/SCPreferencesPath.h"

ImonC *globalImonC;

class connectLost : public ImonC::AbstractCallback
{
public:
	void operator()() { };
};

connectLost *globalConnectLost;

@implementation AppleVPNExtra

-(void)timerCallback:(NSTimer*)timer
{
	[self menu];
}

- (id)initWithBundle:(NSBundle *)bundle
{
    self = [super initWithBundle:bundle];
    if( self == nil )
        return nil;
	
	theAppID = CFSTR("com.ramjac.imoncosx");
    CFPreferencesAppSynchronize( theAppID );

	// init ImonC

	theRouterIP = NULL;
	globalImonC = new ImonC();
	globalConnectLost = new connectLost();
	globalImonC->SetConnectionLostCallback(globalConnectLost);
	globalImonC->InitSignalHandler();

	// init view

    theView = [[menubarThingyView alloc] initWithFrame:[[self view] frame] menuExtra:self];
    [self setView:theView];
    
	// init menu
	
    theMenu = [[NSMenu alloc] initWithTitle: @""];
    [theMenu setAutoenablesItems: NO];
	
	// init images						single-channel / dual-channel
	
    theOnlineImage = [[NSImage alloc] initWithContentsOfFile:[[self bundle] pathForImageResource:@"online"]];
    theOnlineActiveImage = [[NSImage alloc] initWithContentsOfFile:[[self bundle] pathForImageResource:@"onlineactive"]];
    theOfflineImage = [[NSImage alloc] initWithContentsOfFile:[[self bundle] pathForImageResource:@"offline"]];
    theNoConnectImage = [[NSImage alloc] initWithContentsOfFile:[[self bundle] pathForImageResource:@"noconnect"]];
	
	// update intervall
	
	long intv=2;			// default: 2 seconds update intervall
	CFPropertyListRef value = CFPreferencesCopyAppValue( CFSTR("UpdateInterval"), theAppID );
    if ( value && CFGetTypeID(value) == CFNumberGetTypeID() )
	{
		CFNumberGetValue((CFNumberRef)value,kCFNumberLongType,&intv);
    }
    if ( value )
	{
		CFRelease(value);
		value = NULL;
	}

	// max channel rate

	theMaxChannelRate = 1152*128;		// default: DSL 1000
	value = CFPreferencesCopyAppValue( CFSTR("MaxChannelRate"), theAppID );
    if ( value && CFGetTypeID(value) == CFNumberGetTypeID() )
	{
		long chanrate;
		CFNumberGetValue((CFNumberRef)value,kCFNumberLongType,&chanrate);
		theMaxChannelRate = chanrate*128.0;//	kbps * 1024 / 8 Bpb
    }
    if ( value )
	{
		CFRelease(value);
		value = NULL;
	}

	// start intervall timer

	theTimer = [NSTimer scheduledTimerWithTimeInterval:intv target:self selector:@selector(timerCallback:) userInfo:0 repeats:YES];
//	[theTimer fire];
	
    return self;
}

-(void)willUnload
{
	[theTimer invalidate];
	globalImonC->Disconnect();
    [theMenu release];
    [theView release];

	[theOnlineImage release];
	[theOnlineActiveImage release];
	[theOfflineImage release];
	[theNoConnectImage release];

	if (theRouterIP != NULL)
	{
		CFRelease(theRouterIP);
		theRouterIP = NULL;
	}
	CFRelease(theAppID);
	theAppID=NULL;
}

-(void)unload
{
}

- (void)dealloc
{
    [super dealloc];
}

- (void) determineRouterIP
{
    CFPreferencesAppSynchronize( theAppID );

	if (theRouterIP != NULL)
	{
		CFRelease(theRouterIP);
		theRouterIP=NULL;
	}

	// default auto-detection state
	int autodetect = YES;

	// what do the preferences say to "auto-detection" ?
    CFPropertyListRef value = CFPreferencesCopyAppValue( CFSTR("AutoDetectRouter"), theAppID );
    if ( value && CFGetTypeID(value) == CFBooleanGetTypeID() )
	{
		autodetect = CFBooleanGetValue((CFBooleanRef)value);
    }
    if ( value )
	{
		CFRelease(value);
		value = NULL;
	}

	if (autodetect)
	{
		/* auto-determine Router IP */
		SCDynamicStoreRef storeRef = SCDynamicStoreCreate(nil, theAppID, nil, nil);

		CFStringRef IPv4globalsPath = CFStringCreateWithFormat(nil, nil, CFSTR("%@/%@/%@/%@"), kSCDynamicStoreDomainState, kSCCompNetwork, kSCCompGlobal, kSCEntNetIPv4);
		CFDictionaryRef IPv4Dict = (CFDictionaryRef) SCDynamicStoreCopyValue(storeRef, IPv4globalsPath);

		if (IPv4Dict != NULL)
		{
			if (CFDictionaryContainsKey(IPv4Dict, kSCPropNetIPv4Router))
			{
				theRouterIP = (CFStringRef) CFRetain( CFDictionaryGetValue(IPv4Dict, kSCPropNetIPv4Router) );
			}
		}
		
		if (IPv4Dict) CFRelease(IPv4Dict);
		if (IPv4globalsPath) CFRelease(IPv4globalsPath);
		CFRelease(storeRef);
	}
	else
	{
		/* no autodetect: get router IP from preferences */
		value = CFPreferencesCopyAppValue( CFSTR("RouterIPAddress"), theAppID );
		if ( value && CFGetTypeID(value) == CFStringGetTypeID() )
		{
			theRouterIP = (CFStringRef)CFRetain(value);
		}
		else
		{
			theRouterIP = NULL;
		}
		if ( value )
		{
			CFRelease(value);
			value = NULL;
		}
	}
}

- (void)connect
{
    CFPreferencesAppSynchronize( theAppID );

	[self determineRouterIP];

	if (theRouterIP != NULL)
	{
		long rport = 5000;
		
		// get router port from prefs
		CFPropertyListRef value = CFPreferencesCopyAppValue( CFSTR("RouterPort"), theAppID );
		if ( value && CFGetTypeID(value) == CFNumberGetTypeID() )
		{
			CFNumberGetValue((CFNumberRef)value,kCFNumberLongType,&rport);
		}
		if ( value )
		{
			CFRelease(value);
			value = NULL;
		}

		try
		{
			globalImonC->Connect(CFStringGetCStringPtr(theRouterIP,kCFStringEncodingMacRoman) , rport);
		}
		catch (ImonC::ConnectError)
		{
			// ...
		}
		
		if (globalImonC->IsConnected())
		{
			CFStringRef passw;

			// try adminpassword for gaining admin-priv
			if (!globalImonC->IsAdmin())
			{
				CFPropertyListRef value = CFPreferencesCopyAppValue( CFSTR("RouterAdminPass"), theAppID );
				if ( value && CFGetTypeID(value) == CFStringGetTypeID() )
				{
					passw = (CFStringRef)CFRetain(value);
					globalImonC->Pass(CFStringGetCStringPtr(passw,kCFStringEncodingMacRoman));
					CFRelease(passw);
				}
				if ( value )
				{
					CFRelease(value);
					value = NULL;
				}
			}
			
			// try userpassword for gaining admin-priv
			if (!globalImonC->IsUser())
			{
				CFPropertyListRef value = CFPreferencesCopyAppValue( CFSTR("RouterUserPass"), theAppID );
				if ( value && CFGetTypeID(value) == CFStringGetTypeID() )
				{
					passw = (CFStringRef)CFRetain(value);
					globalImonC->Pass(CFStringGetCStringPtr(passw,kCFStringEncodingMacRoman));
					CFRelease(passw);
				}
				if ( value )
				{
					CFRelease(value);
					value = NULL;
				}
			}

			if (globalImonC->IsUser())
			{
				theNumChannels = globalImonC->GetChannels().size();
				theDialAllowed = globalImonC->IsDialAllowed();
				theAddLinkAllowed = globalImonC->IsAddLinkAllowed();
			}
			else
			{
				// we are not even "User" -> nothing to do :(
				globalImonC->Disconnect();
			}
		}
		else
		{
			// Connection failed
		}
	}
}

- (void)IPselected:(id)sender
{
}

-(void)hangup:(id)sender
{
	globalImonC->Hangup();
	[self menu];
}

-(void)dial:(id)sender
{
	globalImonC->Dial();
	[self menu];
}

-(void)addlink:(id)sender
{
	globalImonC->AddLink();
	[self menu];
}

-(void)removelink:(id)sender
{
	globalImonC->RemoveLink();
	[self menu];
}

- (NSMenu *)menu
{
	// empty the menu
	while ([theMenu numberOfItems]) [theMenu removeItemAtIndex:0];

	// if we are not connected (must have failed at startup) -> offer "connect" to the user
	if (!globalImonC->IsConnected())
		[self connect];
	
	// if connected...
	if (globalImonC->IsConnected())
	{
		theNumChannels = globalImonC->GetChannels().size();
		int channels_online=0;

		// iterate through the channels and list IPs of online channels
		for (long i=0; i<theNumChannels; i++)
		{
			if (globalImonC->GetChannels()[i]->Status() == ImonC::Channel::Online)
			{
				NSString *IPname=[NSString stringWithCString:globalImonC->GetChannels()[i]->IP().c_str()];
				NSMenuItem *aItem = [theMenu addItemWithTitle:IPname action:@selector(IPselected:) keyEquivalent: @""];
				[aItem setEnabled:NO];      // disable it
				channels_online++;
			}
		}

		// we are online:
		if (channels_online > 0)
		{
			// not all channels online
			if (theAddLinkAllowed && (channels_online < theNumChannels))	// "add link" in the sense of "additional link" (otherwise "dial")
			{
				NSMenuItem *aItem = [theMenu addItemWithTitle:@"Add Link" action:@selector(addlink:) keyEquivalent: @""];
				[aItem setTarget:self];
			
				if (channels_online > 1)	// "rem link" in the sense of "removing additional link" (= of at least 2 links)
				{
					NSMenuItem *aItem = [theMenu addItemWithTitle:@"Remove Link" action:@selector(removelink:) keyEquivalent: @""];
					[aItem setTarget:self]; 
				}
			}
			if (theDialAllowed)   // FIX: same restrictions on "hangup" and "dial" ?
			{
				NSMenuItem *aItem = [theMenu addItemWithTitle:@"Hang up" action:@selector(hangup:) keyEquivalent: @""];
				[aItem setTarget:self]; 
			}
		}
		// we are offline:
		else
		{
			if (theDialAllowed)
			{
				NSMenuItem *aItem = [theMenu addItemWithTitle:@"Dial" action:@selector(dial:) keyEquivalent: @""];
				[aItem setTarget:self]; 
			}
		}
	}

	// redraw status
	[_view setNeedsDisplay:YES];

    return theMenu;
}

//
// which image to draw for status (grey / red / dark green / light green)
// how much percentage of bandwidth is taken
//
- (NSImage*) image
{
	if (!globalImonC->IsConnected())
	{
		[theView setPercentageIn:0.0 Out:0.0];
		[theView setOnlineChannels:0];
		return theNoConnectImage;
	}
	else
	{
		long online_channels=0;
		double max_rate=0.0;
		ImonC::Channel::Traffic_t rate_all;
		// scan all channels for online and rate (B/s)
		for (long i=0; i<theNumChannels; i++)
			if (globalImonC->GetChannels()[i]->Status() == ImonC::Channel::Online)
			{
				max_rate += theMaxChannelRate;
				ImonC::Channel::Traffic_t rate=globalImonC->GetChannels()[i]->Rate();
				rate_all.in += rate.in;
				rate_all.out += rate.out;
				online_channels++;
			}

		if (online_channels > 0)				// at least 1 channel is online ...
		{
			[theView setPercentageIn:(rate_all.in/max_rate) Out:(rate_all.out/max_rate)];

			if (theNumChannels > 1)			// if there is more than 1 channel
				[theView setOnlineChannels:online_channels]; // then display # of online chans
			else
				[theView setOnlineChannels:0];  // otherwise it is not interesting
			
			if (rate_all.in+rate_all.out == 0)  // ... but no data transfer
			{
				return theOnlineImage;
			}
			else								// ... and active
			{
				return theOnlineActiveImage;
			}
		}
	}

	[theView setPercentageIn:0.0 Out:0.0];
	[theView setOnlineChannels:0];
    return theOfflineImage;
}

@end
