/*
 MultiImonC - a multiplatform imonc for fli4l
 Copyright (C) 2003, 2004 Michael Hanselmann
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
 $Id: ImonC.h,v 1.9 2004/07/10 21:02:55 michael Exp $
 */

#ifndef _IMONC_H
#define _IMONC_H

#include <istream>
#include <string>
#include <stdexcept>
#include <vector>

class ImonC {
private:
#ifndef uint64_t
    typedef unsigned long long uint64_t;
#endif // uint64_t
#ifndef int64_t
    typedef long long int64_t;
#endif // int64_t
public:
    /*
     "he, hansmi, was macht diese klasse" -> "keine ahnung, akira meinte machs so und davon erben" :))
     akira, 2003-11-24
    */
    class AbstractCallback {
    public:
        virtual void operator()() = 0;
    };
    class ConnectError {
    private:
        std::string m_strMessage;
    public:
        ConnectError(std::string i_strMessage):
            m_strMessage(i_strMessage) {
        }
        std::string GetMessage() {
            return m_strMessage;
        }
    };
    class Channel {
    public:
        struct Traffic_t {
            uint64_t in;
            uint64_t out;
            Traffic_t() {
                in = 0;
                out = 0;
            }
        };
        enum Type_t {
            PPPoE = 1,
            ISDN = 2
        };
        enum Status_t {
            Offline = 0,
            Online = 1
        };
        Type_t Type();
        Status_t Status();
        std::string IP();
        std::string Phone();
        std::string InOut();
        std::string OnlineTime();
        std::string Time();
        std::string ChargeTime();
        std::string Charge();
        Traffic_t Rate();
        Traffic_t Quantity();
        Channel(ImonC& imonc, std::string name);

    private:
        ImonC& m_oImonC;
        std::string m_strName;
        Type_t m_tType;
        void SetType(Type_t t) { m_tType = t; }

        friend class ImonC;
    };
    class Circuit {
    public:
        std::string Name();
        long HupTimeOut(long timeout = -1);
        bool CanSetHupTimeOut();
        std::string Device();
        Circuit(ImonC& imonc, int number);
    private:
        ImonC& m_oImonC;
        int m_iNumber;
        friend class ImonC;
    };
    typedef std::vector<ImonC::Channel*> ChannelVector;
    typedef std::vector<ImonC::Circuit*> CircuitVector;

private:
    class Socket {
    public:
        friend class ImonC;
    public:
        bool Connect(const std::string i_strHostname = "localhost",
                     const unsigned int i_iPort = DefaultPort);
        void Disconnect();
        bool IsConnected() const;
        void Write(const std::string i_strCommand);
        std::string Read();
        void SetTimeout(const int i_iTimeout = DefaultTimeout);
        Socket();
        ~Socket();
        std::string GetHost() const;
        unsigned int GetPort() const;
        void SetConnectionLostObj(ImonC* imonc);

        static void InitSignalHandler();
    private:
        int m_iFD;
        int m_iTimeout;
        std::string m_strHostname;
        unsigned int m_iPort;

        void ConnectionLost();

        ImonC* m_pImonC;
        
        static void SigAlarm(int signo);
        static Socket* SigAlarmObj;
    public:
        enum {
            DefaultTimeout = 1,
        };
    };
    
public:
    enum {
        DefaultPort = 5000,
    };
    enum Dialmode_t {
        Off = 1,
        Manual = 2,
        Auto = 3,
        _Default = -1
    };
    struct Version_t {
        unsigned int protocol;
        std::string version;
        Version_t():version("") {
            protocol = 0;
        }
    };
    
private:
    std::string m_strHost;
    unsigned int m_iPort;
    Socket m_oSocket;
    Version_t m_oVersionCache;
    ChannelVector m_oChannelData;
    CircuitVector m_oCircuitData;
    AbstractCallback* m_pConnectionLostCallbackObj;

    inline uint64_t atoull(const char* Buffer) const;
    int Channels();
    int Circuits();
    std::string GetAnswer(std::string i_strCommand);
    std::string GetMultilineAnswer(std::string i_strCommand);
    std::string Salt();
    bool IsAllowed(std::string i_strCommand);
    
    enum PassValue {
        PassRequired = 0,
        AdminPassRequired = 1,
        AdminMode = 2
    };
    enum {
        ACK_CHAR = '\006',
        NAK_CHAR = '\025'
    };

public:
    ImonC();
    ~ImonC();
    bool Connect(std::string i_strHostname = "localhost",
                 unsigned int i_iPort = DefaultPort);
    bool IsConnected();
    void Disconnect();
    
    std::string GetHost();
    unsigned int GetPort();

    void Dial();
    void Hangup();
    std::string Date();
    std::string Timetable();
    std::string Support(std::string i_strRootPassword);
    unsigned long long int Uptime();
    Dialmode_t Dialmode(Dialmode_t dmSet = _Default);
    unsigned short int CPU();
    int Route(int i_iRoute = -1);
    int Links(int i_iDefault = -1);
    bool IsDialAllowed();
    bool IsDialmodeAllowed();
    bool IsRouteAllowed();
    bool IsAddLinkAllowed();
    bool IsHaltAllowed();
    bool IsRebootAllowed();
    bool IsUser();
    bool IsAdmin();
    void AddLink();
    void RemoveLink();
    void Reboot();
    void Halt();
    unsigned short int Pass(std::string i_strPassword = "");
    Version_t Version();
    const ChannelVector& GetChannels();
    const CircuitVector& GetCircuits();

    std::string GetFile(std::string i_strRootPassword,
                        std::string i_strFilename);
    bool UploadFile(std::string i_strRootPassword,
                    std::string i_strFilename,
                    std::string i_strContent);
    bool UploadFile(std::string i_strRootPassword,
                    std::string i_strFilename,
                    std::istream& i_oStream);

    void SetConnectionLostCallback(AbstractCallback* callback);
    void ConnectionLost();
    
    static void InitSignalHandler();
};

#endif // _IMONC_H
