	TITLE	"Power"
	LIST	P=16C622, F=INHX8M, N=56, C=80
	PROCESSOR	16C622

INDF		EQU	00H	;Indirektes Adress-Register
TMR0		EQU	01H	;Timer0 Register
PC		EQU	02H	;Program counter
STATUS		EQU	03H	;Status register
FSR		EQU	04H	;FILE SELECT REGISTER
PORTA		EQU	05H	;Port A
PORTB		EQU	06H	;Port B

OPTION_REG	EQU	81H	;Option Register
TRISA		EQU	85H	;Tristate Control Port A
TRISB		EQU	86H	;Tristate Control Port B
CMCON		EQU	1FH	;Comparator Control Register
	;==========================================================

COUNTLO		EQU	20H	;Low Byte fr Zeitzhler
COUNTMID	EQU	21H	;Mitte
COUNTHI		EQU	22H	;High Byte
;COUNTHIHI	EQU	23H	;Ganz hoch
OLD_INPUTB	EQU	24H	;Alter Zustand der Eingnge am Port B
ACT_INPUTB	EQU	25H	;Aktueller Zustand der Eingnge am Port B
OLD_INPUTA	EQU	26H	;Das gleiche nochmal fr Port A
ACT_INPUTA	EQU	27H



;INIT_CNTHIHI	EQU	2	;Initialisierungswert fr Zeitzhler

	;==========================================================
	;
;Status Register:
CARRY		EQU	0	;Carry-Bit im Statusreg.
DCARRY		EQU	1	;Digit Carry
ZBIT		EQU	2	;ZBIT-Bit im Statusreg.
PD		EQU	3	;Power Down Bit
TO		EQU	4	;Time Out (Watchdog)
PA0		EQU	5	;Seitenumschaltung Bank0/1

GPWUF		EQU	7	;Wake up from sleep by GPIO change

;OPTION: = OPTR
OPT_VAL	EQU	b'10000000'	;Date f. Option Reg.
;	  	  ||||||||
PS0	EQU	0;||||||||_ PS0   siehe Tabelle
PS1	EQU	1;|||||||__ PS1   siehe Tabelle
PS2	EQU	2;||||||___ PS2   siehe Tabelle 
;		  |||||
PSA	EQU	3;|||||____ PSA		0=prescaler RTCC/
;		  ||||         		1=prescaler WDT
TOSE	EQU	4;||||_____ T0SE	0=Timer incr. Low-High Flanke am Eingag
;		  |||       		1=Timer incr. High-Low Flanke am Eingang
TOCS	EQU	5;|||______ TOCS	0=Timer Clock intern
;		  ||        		1=Timer Clock extern (RA4/TOCKI)
INTEDG	EQU	6;||_______ INTEGD	Interrupt edge select
;		  |			0=falling, 1=rising 
RBPU	EQU	7;|________ GPPU	enable weak pull up
;			          	0=enable, 1 disable 
;
;	PS2 PS1 PS0 | RTCC RATE | WDT RATE
;	----------------------------------
;	 0   0   0  |    1:2    |    1:1
;	 0   0   1  |    1:4    |    1:2
;	 0   1   0  |    1:8    |    1:4
;	 0   1   1  |    1:16   |    1:8
;	 1   0   0  |    1:32   |    1:16
;	 1   0   1  |    1:64   |    1:32
;	 1   1   0  |    1:128  |    1:64
;	 1   1   1  |    1:256  |    1:128
;

#define	POWER_ON	PORTA,3
#define	SHUT_DOWN	PORTA,2
#define	PAGE1		STATUS,5
INIT_CNTHI	EQU	.88		;Anzahl Zhlzyklen je 3,4 s -> 300 s
INIT_SHTDWN	EQU	.9		;			    ->  30 s

;
;============================================================================
;============================================================================
;============================================================================
	org	0
LOOP:
	clrf	STATUS
	movlw	b'0000111'	;all Comparators off
	movwf	CMCON

	bsf	PAGE1		;Speicherseite 1
	movlw	OPT_VAL		;Option Register setup
	movwf	OPTION_REG
	movlw	b'00000001'	;Port A0 Eingang
	movwf	TRISA
	movlw	b'11111111'	;Port B: alle Bits Eingang
	movwf	TRISB

	bcf	PAGE1	


	movf	PORTB,w		;Eingang Port B lesen (8 bits)
	xorwf	OLD_INPUTB	;Mit Altzustand vergleichen
	movwf	OLD_INPUTB	;Und Neuzustand als Altzustand ablegen
	btfss	STATUS,ZBIT	;Ergebnis des Vergleiches abfragen
	goto	ON		;und wenn nderung, dann Einschalten
	
	movf	PORTA,w		;Eingang Port A lesen (1 bit)
	andlw	b'00000001'	;Nur Bit 0 ist gltig
	xorwf	OLD_INPUTA	;Mit Altzustand vergleichen
	movwf	OLD_INPUTA	;Und Neuzustand als Altzustand ablegen
	btfsc	STATUS,ZBIT	;Ergebnis des Vergleiches abfragen
	goto	NIX_NEUES	;und wenn keine nderung, dann nur Zeit ablaufen lassen
	

ON:
	clrf	COUNTLO		;Timer immer wieder neu initialisieren
	clrf	COUNTMID
	movlw	INIT_CNTHI
	movwf	COUNTHI
	bsf	POWER_ON	;Relais ansteuern
	bcf	SHUT_DOWN	;Keine Shutdown-Meldung
	;
NIX_NEUES:
	decfsz	COUNTLO
	goto	LOOP
	decfsz	COUNTMID
	goto	LOOP
	decfsz	COUNTHI
	goto	LOOP
	
	bsf	SHUT_DOWN	;Timer ist abgelaufen, Shut Down anfordern

	clrf	COUNTLO		;Wartezeit fr Shut Down initialisieren
	clrf	COUNTMID
	movlw	INIT_SHTDWN
	movwf	COUNTHI
	
SHUT_DOWN_DELAY:		;Wartezeit fr Shut Down luft
	decfsz	COUNTLO
	goto	SHUT_DOWN_DELAY
	decfsz	COUNTMID
	goto	SHUT_DOWN_DELAY
	decfsz	COUNTHI
	goto	SHUT_DOWN_DELAY

	bcf	POWER_ON	;Wartezeit abgelaufen, jetzt ausschalten
	goto	LOOP		;und wieder auf Daten im Netzwerk warten
	
	end
	
