	TITLE	"Power"
	LIST	P=12C509, F=INHX8M, N=56, C=80
	PROCESSOR	12C509

INDF		EQU	00H	;Indirektes Adress-Register
TMR0		EQU	01H	;Timer0 Register
PC		EQU	02H	;Program counter
STATUS		EQU	03H	;Status register
FSR		EQU	04H	;FILE SELECT REGISTER
OSCCAL		EQU	05H	;Oscillator Calibration Register
GPIO		EQU	06H	;General purpose I/O port

	;==========================================================

COUNTLO		EQU	07H	;Low Byte fr Zeitzhler
COUNTMID	EQU	08H	;Mitte
COUNTHI		EQU	09H	;High Byte
;COUNTHIHI	EQU	0AH	;Ganz hoch
OLD_INPUT	EQU	0BH	;Alter Zustand der Eingnge
ACT_INPUT	EQU	0CH	;Aktueller Zustand der Eingnge


;MERK
POWER_ON	EQU	0	;Bit 0 ist AN


	;==========================================================
	;
;Status Register:
CARRY		EQU	0	;Carry-Bit im Statusreg.
DCARRY		EQU	1	;Digit Carry
ZBIT		EQU	2	;ZBIT-Bit im Statusreg.
PD		EQU	3	;Power Down Bit
TO		EQU	4	;Time Out (Watchdog)
PA0		EQU	5	;Seitenumschaltung Bank0/1

GPWUF		EQU	7	;Wake up from sleep by GPIO change

;OPTION: = OPTR
OPT_VAL	EQU	b'10000001'	;Date f. Option Reg.
;	  	  ||||||||
PS0	EQU	0;||||||||_ PS0   siehe Tabelle
PS1	EQU	1;|||||||__ PS1   siehe Tabelle
PS2	EQU	2;||||||___ PS2   siehe Tabelle 
;		  |||||
PSA	EQU	3;|||||____ PSA		0=prescaler RTCC/
;		  ||||         		1=prescaler WDT
TOSE	EQU	4;||||_____ T0SE	0=Timer incr. Low-High Flanke am Eingag
;		  |||       		1=Timer incr. High-Low Flanke am Eingang
TOCS	EQU	5;|||______ TOCS	0=Timer Clock intern
;		  ||        		1=Timer Clock extern (RA4/TOCKI)
GPPU	EQU	6;||_______ INTEGD	enable weak pull up resistors
;		  |			0=enable, 1 disable 
GPWU	EQU	7;|________ GPPU	enable Wake up
;			          	0=enable, 1 disable 
;
;	PS2 PS1 PS0 | RTCC RATE | WDT RATE
;	----------------------------------
;	 0   0   0  |    1:2    |    1:1
;	 0   0   1  |    1:4    |    1:2
;	 0   1   0  |    1:8    |    1:4
;	 0   1   1  |    1:16   |    1:8
;	 1   0   0  |    1:32   |    1:16
;	 1   0   1  |    1:64   |    1:32
;	 1   1   0  |    1:128  |    1:64
;	 1   1   1  |    1:256  |    1:128
;

;
;============================================================================
;============================================================================
;============================================================================
	org	0
LOOP:
	clrf	STATUS
	movlw	OPT_VAL
	option
	movlw	b'001111'	;	GP0 GP1 GP2 GP3 Eingang, Rest ausgang
	TRIS	GPIO
	;

	movf	GPIO,w
	andlw	b'00001111'
	movwf	ACT_INPUT
	xorwf	OLD_INPUT
	movwf	OLD_INPUT
	btfsc	STATUS,ZBIT
	goto	NIX_NEUES

ON:
	clrf	COUNTLO
	clrf	COUNTMID
	clrf	COUNTHI
	bsf	GPIO,4
	;
NIX_NEUES:
	decfsz	COUNTLO
	goto	LOOP
	decfsz	COUNTMID
	goto	LOOP
	decfsz	COUNTHI
	goto	LOOP
	bcf	GPIO,4
	goto	LOOP
	
	end
	
