
#import "ImonCosXprefsPref.h"
#include "ImonC.h"
#include "SystemConfiguration.framework/Headers/SCPreferences.h"
#include "SystemConfiguration.framework/Headers/SCSchemaDefinitions.h"
#include "SystemConfiguration.framework/Headers/SCPreferencesPath.h"
#import <Foundation/NSAppleScript.h>

ImonC *globalImonC;

class connectLost : public ImonC::AbstractCallback
{
public:
	void operator()() { };
};

connectLost *globalConnectLost;

@implementation ImonCosXprefsPref

- (NSString*) sec2string:(long long)sec
{
	int days = sec / (60*60*24);
	long long rest = sec-days*60*60*24;
	
	int hours = rest / (60*60);
	rest = rest - hours*60*60;
	
	int minutes = rest / 60;
	int seconds = rest - minutes*60;
	
	if (days > 0)
		return [NSString stringWithFormat:@"%02i:%02i:%02i:%02i",days,hours,minutes,seconds];
	
	if (hours > 0)
		return [NSString stringWithFormat:@"%02i:%02i:%02i",hours,minutes,seconds];

	return [NSString stringWithFormat:@"%02i:%02i",minutes,seconds];
}

-(void)timerCallback:(NSTimer*)timer
{
	if ([theAutoDetectCheckBox state])
	{
		[self determineRouterIP];
	}
	
	try
	{
		globalImonC->Connect([[theRouterIPAddressText stringValue] cString],[theRouterPortText intValue]);
	}
	catch (ImonC::ConnectError &err)
	{
//		[theRouterStatusText setStringValue:[NSString stringWithCString:err.GetMessage().c_str()]];
		[theRouterVersionText setStringValue:@"not connected"];
		[theRouterStatusText setStringValue:@"not connected"];
		[theRouterUptimeText setStringValue:@"not connected"];
		return;
	}
	
	if (globalImonC->IsConnected())
	{
		ImonC::Version_t ver = globalImonC->Version();
		[theRouterVersionText setStringValue:[NSString stringWithCString: ver.version.c_str()]];

		// try userpassword for gaining user-priv
		if (!globalImonC->IsUser())
		{
			globalImonC->Pass([[thePasswordText stringValue] cString]);
		}

		// try adminpassword for gaining user-priv
		if (!globalImonC->IsUser())
		{
			globalImonC->Pass([[theAdminPasswordText stringValue] cString]);
		}

		if (globalImonC->IsUser())
		{
			long channel_count=0;
			if (!globalImonC->GetChannels().empty())
			{
				channel_count = globalImonC->GetChannels().size();
			}

			long channels_online = 0;
			for (long i=0; (i<channel_count) && (i<10); i++)
			{
				if (globalImonC->GetChannels()[i]->Status() == ImonC::Channel::Online)
				{
					channels_online++;
				}
			}
		
			if (channel_count == 1)
				if (channels_online > 0)
					[theRouterStatusText setStringValue:@"online"]; // only one channel
				else
					[theRouterStatusText setStringValue:@"offline"];
			else
				[theRouterStatusText setStringValue:[NSString stringWithFormat:@"%i/%i online",channels_online,channel_count]];

			NSString *str = [self sec2string:globalImonC->Uptime()];
			[theRouterUptimeText setStringValue:str];
		}
		else
		{
			[theRouterVersionText setStringValue:@"no Password"];
			[theRouterStatusText setStringValue:@"no Password"];
			[theRouterUptimeText setStringValue:@"no Password"];
		}
	}
	else
	{
		[theRouterVersionText setStringValue:@"not connected"];
		[theRouterStatusText setStringValue:@"not connected"];
		[theRouterUptimeText setStringValue:@"not connected"];
	}
	globalImonC->Disconnect();
}

- (id)initWithBundle:(NSBundle *)bundle
{
    if ( ( self = [super initWithBundle:bundle] ) != nil )
	{
		appID = CFSTR("com.ramjac.imoncosx");
		globalImonC = new ImonC();
		globalConnectLost = new connectLost();
		globalImonC->SetConnectionLostCallback(globalConnectLost);
		globalImonC->InitSignalHandler();
	}
	return self;
}

- (void) mainViewDidLoad
{
	// init textfields and checkboxes, to default values where needed

    CFPropertyListRef value=NULL;
    value = CFPreferencesCopyAppValue( CFSTR("StatusMenuBarThingy"), appID );
    if ( value && CFGetTypeID(value) == CFBooleanGetTypeID() )
	{
        [theMenuBarStatusCheckBox setState:CFBooleanGetValue((CFBooleanRef)value)];
    }
	else
	{
        [theMenuBarStatusCheckBox setState:YES];			// default: menubar extra visible
    }
    if ( value )
	{
		CFRelease(value);
		value = NULL;
	}

    value = CFPreferencesCopyAppValue( CFSTR("RouterIPAddress"), appID );
    if ( value && CFGetTypeID(value) == CFStringGetTypeID() )
	{
        [theRouterIPAddressText setStringValue:(NSString *)value];
    }
	else
	{
        [theRouterIPAddressText setStringValue:@"fli4l"];   // default: router is "fli4l"
    }
    if ( value )
	{
		CFRelease(value);
		value = NULL;
	}

    value = CFPreferencesCopyAppValue( CFSTR("RouterPort"), appID );
    if ( value && CFGetTypeID(value) == CFNumberGetTypeID() )
	{
		long rport;
		CFNumberGetValue((CFNumberRef)value,kCFNumberLongType,&rport);
        [theRouterPortText setIntValue:rport];
    }
	else
	{
        [theRouterPortText setIntValue:5000];				// default: imond port 5000
    }
    if ( value )
	{
		CFRelease(value);
		value = NULL;
	}

    value = CFPreferencesCopyAppValue( CFSTR("RouterUserPass"), appID );
    if ( value && CFGetTypeID(value) == CFStringGetTypeID() )
	{
        [thePasswordText setStringValue:(NSString *)value];
    }
	else
	{
        [thePasswordText setStringValue:@""];				// default: no user password
    }
    if ( value )
	{
		CFRelease(value);
		value = NULL;
	}

    value = CFPreferencesCopyAppValue( CFSTR("RouterAdminPass"), appID );
    if ( value && CFGetTypeID(value) == CFStringGetTypeID() )
	{
        [theAdminPasswordText setStringValue:(NSString *)value];
    }
	else
	{
        [theAdminPasswordText setStringValue:@""];			// default: no admin password
    }
    if ( value )
	{
		CFRelease(value);
		value = NULL;
	}

	value = CFPreferencesCopyAppValue( CFSTR("UpdateInterval"), appID );
    if ( value && CFGetTypeID(value) == CFNumberGetTypeID() )
	{
		long intv;
		CFNumberGetValue((CFNumberRef)value,kCFNumberLongType,&intv);
        [theUpdateIntervalText setIntValue:intv];
    }
	else
	{
        [theUpdateIntervalText setIntValue:2];				// default: 2 second update intervall
    }
    if ( value )
	{
		CFRelease(value);
		value = NULL;
	}

	value = CFPreferencesCopyAppValue( CFSTR("MaxChannelRate"), appID );
    if ( value && CFGetTypeID(value) == CFNumberGetTypeID() )
	{
		long maxrate;
		CFNumberGetValue((CFNumberRef)value,kCFNumberLongType,&maxrate);
        [theChannelMaxRateText setIntValue:maxrate];
    }
	else
	{
        [theChannelMaxRateText setIntValue:1152];			// default: DSL 1000
    }
    if ( value )
	{
		CFRelease(value);
		value = NULL;
	}

    value = CFPreferencesCopyAppValue( CFSTR("AutoDetectRouter"), appID );
    if ( value && CFGetTypeID(value) == CFBooleanGetTypeID() )
	{
        [theAutoDetectCheckBox setState:CFBooleanGetValue((CFBooleanRef)value)];
        [theRouterIPAddressText setEnabled:!CFBooleanGetValue((CFBooleanRef)value)];
    }
	else
	{
        [theAutoDetectCheckBox setState:YES];				// default: autodetect router
        [theRouterIPAddressText setEnabled:NO];
    }
    if ( value )
	{
		CFRelease(value);
		value = NULL;
	}
	
    value = CFPreferencesCopyAppValue( CFSTR("DefaultRouterPort"), appID );
    if ( value && CFGetTypeID(value) == CFBooleanGetTypeID() )
	{
        [theDefaultPortCheckBox setState:CFBooleanGetValue((CFBooleanRef)value)];
        [theRouterPortText setEnabled:!CFBooleanGetValue((CFBooleanRef)value)];
    }
	else
	{
        [theDefaultPortCheckBox setState:YES];				// default: use default imond port
        [theRouterPortText setEnabled:NO];
    }
    if ( value )
	{
		CFRelease(value);
		value = NULL;
	}

	// first reactions to user-preferences:

	if ([theDefaultPortCheckBox state])
		[theRouterPortText setIntValue:5000];
	
	if ([theAutoDetectCheckBox state])
		[self determineRouterIP];

	if ([theMenuBarStatusCheckBox state])
		[self launchMenuBarThingy];
	else
		[self removeMenuBarThingy];
	
	// 5 second timer to update preference panel
	
	theTimer = [NSTimer scheduledTimerWithTimeInterval:5.0 target:self selector:@selector(timerCallback:) userInfo:0 repeats:YES];
//	[theTimer fire];
	
	[theVersionText setStringValue:@" v0.5"];
}

- (int) determineRouterIP
{
	int result = NO;
	
	SCDynamicStoreRef storeRef = SCDynamicStoreCreate(nil, appID, nil, nil);

	CFStringRef IPv4globalsPath = CFStringCreateWithFormat(nil, nil, CFSTR("%@/%@/%@/%@"), kSCDynamicStoreDomainState, kSCCompNetwork, kSCCompGlobal, kSCEntNetIPv4);
	CFDictionaryRef IPv4Dict = (CFDictionaryRef) SCDynamicStoreCopyValue(storeRef, IPv4globalsPath);

	if (IPv4Dict != NULL)
	{
		if (CFDictionaryContainsKey(IPv4Dict, kSCPropNetIPv4Router))
		{
			CFStringRef router = (CFStringRef) CFRetain( CFDictionaryGetValue(IPv4Dict, kSCPropNetIPv4Router) );
					
			NSString *sString=[NSString stringWithCString: CFStringGetCStringPtr(router,kCFStringEncodingMacRoman)];
			[theRouterIPAddressText setStringValue:sString];
			result = YES;
			
			CFRelease(router);
		}
	}

	if (IPv4Dict) CFRelease(IPv4Dict);
	if (IPv4globalsPath) CFRelease(IPv4globalsPath);
	CFRelease(storeRef);
	
	return result;
}

- (IBAction) autoDetectRouterClicked:(id)sender
{
    if ( [sender state] )
	{
        CFPreferencesSetAppValue( CFSTR("AutoDetectRouter"),kCFBooleanTrue, appID );
		[theRouterIPAddressText setEnabled: NO];
		[self determineRouterIP];
	}
	else
	{
        CFPreferencesSetAppValue( CFSTR("AutoDetectRouter"),kCFBooleanFalse, appID );
		[theRouterIPAddressText setEnabled: YES];	
	}
}

- (IBAction) defaultRouterPortClicked:(id)sender
{
    if ( [sender state] )
	{
        CFPreferencesSetAppValue( CFSTR("DefaultRouterPort"),kCFBooleanTrue, appID );
		[theRouterPortText setIntValue:5000];
		[theRouterPortText setEnabled: NO];
	}
	else
	{
        CFPreferencesSetAppValue( CFSTR("DefaultRouterPort"),kCFBooleanFalse, appID );
		[theRouterPortText setEnabled: YES];	
	}
}

- (IBAction)nextChannelRateClicked:(id)sender
{
	long actualrate = [theChannelMaxRateText intValue];

	// siehe: http://www.oliver-brosch.de/tarife/?DSL

	switch (actualrate)
	{
		case 56:
			actualrate = 64;	// ISDN
			break;
		
		case 64:
			actualrate = 1152;  // DSL 1000
			break;
			
		case 1152:
			actualrate = 2240;  // DSL 2000
			break;

		case 2240:
			actualrate = 3456;  // DSL 3000
			break;

		default:
			actualrate = 56;	// Modem
			break;
	}
	
	[theChannelMaxRateText setIntValue:actualrate];
}

extern "C"
{
	typedef struct OpaqueMenuExtraRef *MenuExtraRef;
	OSStatus CoreMenuExtraAddMenuExtra( CFURLRef inURL, SInt32 inAfterItem, void *inUnknown1, void *inUnknown2, void *inUnknown3, void *inUnknown4 );
	OSStatus CoreMenuExtraGetMenuExtra( CFStringRef inIdentifier, MenuExtraRef *outMenuExtra );
	OSStatus CoreMenuExtraRemoveMenuExtra( MenuExtraRef inMenuExtra, void *inUnknown1 );
}

- (void) launchMenuBarThingy
{
	[self savePreferences];

    NSString *menuExtraPath = [[[self bundle] resourcePath] stringByAppendingPathComponent:@"ImonCosX.menu"];
    CFURLRef url = CFURLCreateWithFileSystemPath(kCFAllocatorDefault, (CFStringRef)menuExtraPath, kCFURLPOSIXPathStyle, NO);

    unsigned int outExtra;
    CoreMenuExtraAddMenuExtra(url, 0, 0, nil, 0, &outExtra);
        // Do not check the return value as it is always going to return an error
		
    CFRelease(url);
}

- (void) removeMenuBarThingy
{
	MenuExtraRef menref = NULL;
	CoreMenuExtraGetMenuExtra( CFSTR("com.ramjac.imoncosxmenu"), &menref);	
	if (menref != NULL)
		CoreMenuExtraRemoveMenuExtra( menref, 0);

	menref = NULL;
	CoreMenuExtraGetMenuExtra( CFSTR("com.ramjac.imoncosxmenu"), &menref);	
	if (menref != NULL)
		CoreMenuExtraRemoveMenuExtra( menref, 0);
}

- (IBAction) showHideStatusMenu:(id)sender
{
    if ( [sender state] )
	{
        CFPreferencesSetAppValue( CFSTR("StatusMenuBarThingy"),kCFBooleanTrue, appID );
		[self didUnselect];
		[self launchMenuBarThingy];
	}
    else
	{
        CFPreferencesSetAppValue( CFSTR("StatusMenuBarThingy"),kCFBooleanFalse, appID );
		[self removeMenuBarThingy];
	}
}

- (void)savePreferences
{
    CFNotificationCenterRef center;

    CFPreferencesSetAppValue( CFSTR("RouterIPAddress"), [theRouterIPAddressText stringValue], appID );
	long rport=[theRouterPortText intValue];
    CFPreferencesSetAppValue( CFSTR("RouterPort"), CFNumberCreate(kCFAllocatorDefault,kCFNumberLongType,&rport), appID );
    CFPreferencesSetAppValue( CFSTR("RouterUserPass"), [thePasswordText stringValue], appID );
    CFPreferencesSetAppValue( CFSTR("RouterAdminPass"), [theAdminPasswordText stringValue], appID );
	long intv=[theUpdateIntervalText intValue];
	if (intv < 1) intv=1;
    CFPreferencesSetAppValue( CFSTR("UpdateInterval"), CFNumberCreate(kCFAllocatorDefault,kCFNumberLongType,&intv), appID );
	long rate=[theChannelMaxRateText intValue];
    CFPreferencesSetAppValue( CFSTR("MaxChannelRate"), CFNumberCreate(kCFAllocatorDefault,kCFNumberLongType,&rate), appID );

    CFPreferencesAppSynchronize( appID );

    center = CFNotificationCenterGetDistributedCenter();
    CFNotificationCenterPostNotification(center, CFSTR("Preferences Changed"), appID, NULL, TRUE);
}

- (void)didUnselect
{
	[self savePreferences];
}

@end
