/*
 * Name: 	rawplay
 * Version:	1.2
 * Description:	rawplay accepts .raw format sound input on standart input
 *		and outputs it's to /dev/dsp. The .raw format is a header
 *		less 16bit/16KHz .au format. If either the .raw format is
 *		broken or /dev/dsp can not be opened rawplay outputs a more
 *		or less sensible error message.
 *
 * Copyright:	(C) 1998 Vincent Pagel <pagel@hal.fpms.ac.be>
 *		rawplay is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; version 2
 *
 * History:
 * 1998		V.Pagel <pagel@hal.fpms.ac.be>	* created
 * 10-07-1998	T.Pospisek <tpo@spin.ch>	* licenced with authors
 * 						  acceptance under GPL
 * 						* Added a bit better error
 * 						  messages
 * 						* made fit for and released
 * 21-07-1998	T.Pospisek <tpo@spin.ch>	* adjusted header
 * 19-08-1998	T.Pospisek <tpo@spin.ch>	* "Allright" removed
 * 						* stupid bug fixed, I hope
 * 						  nobody was using this
 * 						  until now...
 */ 

#include <math.h>
#include <stdlib.h>
#include <stdio.h>

#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>
 
short space[1024*1024];

main()
{
  int fd, tmp;
  int size;
  short sample;
  
  
  fd=open("/dev/dsp", O_WRONLY );
  if (fd<0) {
	 fprintf(stderr,"Error opening /dev/dsp \n");
	 return;
  }
  tmp=16;			/* 16 bits by sample */
  if (ioctl(fd, SNDCTL_DSP_SAMPLESIZE, &tmp)<0 || tmp!=16) {
	 fprintf(stderr,"Error setting SNDCTL_DSP_SAMPLESIZE \n");
	 return;
  }

  tmp=0;			/* Mono */
  if ((ioctl(fd, SNDCTL_DSP_STEREO, &tmp)<0) || tmp!=0) {
	 fprintf(stderr,"Error setting SNDCTL_DSP_STEREO\n");
	 return;
  }
    
  tmp=16000;	/* Sample Rate */
  if (ioctl(fd, SNDCTL_DSP_SPEED, &tmp)<0 || tmp!=16000) {
	 fprintf(stderr,"Error setting SNDCTL_DSP_SPEED\n");
	 return;
  }

/*  fprintf(stderr,"Alright\n");*/

  while (!feof(stdin))
	 {
		sample=  fgetc(stdin) + fgetc(stdin)*256;
		if ((-1== write(fd,&sample,2)) && errno==EINTR) {
	 	  fprintf(stderr,"Error writing to /dev/dsp\n");
		  return;
		}
	 }
  ioctl(fd, SNDCTL_DSP_SYNC); 
  ioctl(fd, SNDCTL_DSP_RESET);
  close(fd);
}
