/*
 * FPMs-TCTS SOFTWARE LIBRARY
 *
 * File:    mbrola.c
 * Purpose: Transforms 1.02 input of MBROLA to 2.00b sampa input
 * Author:  V. Pagel
 * Email :  mbrola@tcts.fpms.ac.be
 *
 * Copyright (c) 95 Faculte Polytechnique de Mons (TCTS lab)
 *
 * This programs transform .pho file designed for TCTS
 * phonetic alphabet in a sampa equivalent
 *
 * HISTORY:
 *
 * 29/03/96 : created by V. Pagel
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

char *tcts_sampa[]={ "a","a",
		     "e","@",
		     "i","i",
		     "o","O",
		     "u","y",
		     "au","o",
		     "ou","u",
		     "e1","e",
		     "e2","E",
		     "e3","9",
		     "eu","2",
		     "an","a~",
		     "on","o~",
		     "in","e~",
		     "un","9~",
		     "b","b",
		     "k","k",
		     "ch","S",
		     "d","d",
		     "f","f",
		     "g","g",
		     "j","Z",
		     "l","l",
		     "m","m",
		     "n","n",
		     "p","p",
		     "r","R",
		     "s","s",
		     "t","t",
		     "v","v",
		     "z","z",
		     "ng","N",
		     "u1","H",
		     "w","w",
		     "y","j",
		     "_","_",
		     NULL };

/* 
 * return the SAMPA equivallent of a TCTS phone
 */
char *search_tcts(char *tcts)
{
  int i;

  for(i=0; tcts_sampa[i]!=NULL; i+=2)
      {
	  if (!strncmp(tcts,tcts_sampa[i],2))
	      return(tcts_sampa[i+1]);
      }
  return(NULL);
}

int main(int argc, char **argv)
{
  char *new_name;
  int new_len, position, length;
  char line[255], name[10];
  
  if (argc!=1)
      {
	  printf("\n %s < stdin > stdout\n",argv[0]);
	  exit(1);
      }
  
  fgets(line, sizeof(line), stdin);
  
  do
      if (sscanf(line,"%2s %i%n",name,&length,&position)!=2)
	  fprintf(stdout,"%s\n",line);
      else
	  {
	      if (!(new_name=search_tcts(name)))
		  new_name=name;
	      
	      fprintf(stdout,"%s %i %s\n", new_name,length,&line[position]);
	  }
  while (fgets(line, sizeof(line), stdin));
}
