// CarrierDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Carrier.h"
#include "CarrierDlg.h"



// ~vincent
#include <strstream>
#include "mbrplay.h"
#include "VpError.hpp"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Global variable


	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
		
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCarrierDlg dialog

CCarrierDlg::CCarrierDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCarrierDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCarrierDlg)
	m_name = _T("smith");
	m_place = _T("on the moon");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	// ~vincent
	phonet=load_Speak("american.ini");

}

CCarrierDlg::~CCarrierDlg()
{	// release member phonet
	phonet->~Speak();
}

void CCarrierDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCarrierDlg)
	DDX_Text(pDX, IDC_EDIT1, m_name);
	DDX_Text(pDX, IDC_EDIT2, m_place);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCarrierDlg, CDialog)
	//{{AFX_MSG_MAP(CCarrierDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCarrierDlg message handlers

BOOL CCarrierDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCarrierDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCarrierDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCarrierDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCarrierDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	// Vincent
    UpdateData(TRUE);   // Fill the member variables

	strstream outpho;
	LPhonemePlus lpp;
	lpp.ReadPhofile("../DATA/carrier_us.pho");

  
	try
	{
	  phonet->transcribe_insert(lpp, m_name);
	  phonet->transcribe_insert(lpp, m_place);
	  
	  int error_code= MBR_SetDatabase(phonet->get_dba());

	  if (error_code != MBRERR_NOERROR)
	  {
		  char local[255];
		  MBR_LastError(local,sizeof(local));
		  fatal_message(-1,"MBROLA Init failed:%s",local);
	  }
		
		// End with a Flush command
	  outpho << "; Target " << m_name << m_place << endl << "_ 100\n" 
				 << lpp << endl << "_ 100\n _ 0" << endl << char(0);
		
	  int ret=MBR_Play(CString(outpho.str()),MBR_WAIT,NULL,NULL);
	
		// If you want to display the phonetic transcription
		//if (display)
		//	MessageBox(AfxGetMainWnd()->GetSafeHwnd(), CString(outpho.str()), CString("Phonetized"), MB_OK );
	 }
  catch (int somthg_wrong)
	 {
		// We'll handle this another day
	 }
}
    // ~Vincent
