/*
 * File:    Mbrdico.cpp
 * Purpose: Front end of talking dictionnary for Unix platforms
 * Author: Vincent Pagel <pagel@tcts.fpms.ac.be>
 * Version : 0.99
 * Time-stamp: <1999-06-23 15:48:40 pagel>
 *
 * Copyright (c) 1998 Faculte Polytechnique de Mons (TCTS lab)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 1
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 *
 *  10/03/98 : Created
 */
#include <stdlib.h>
#include <stdio.h>
#include <strstream.h>
#include <iostream.h>
#include <locale.h>

#include "VpError.hpp"
#include "LPhonemePlus.hpp"
#include "Speak.hpp"

int main(int argc, char **argv)
{
  if (argc!=2)
	 {
		cerr << "Usage: " << argv[0] << " american.ini" << endl
			  << "or "     << argv[0] << " french.ini" << endl; 
		return 1;
	 }

  printf("Wait while loading data\n");
  Speak* phonet= load_Speak(argv[1]);
  
  // command stream to play a mbrola .pho file
  char* mbrola_command=getenv( phonet->get_dba() );
  if (!mbrola_command)
	 {
		cerr << "You must define an environment variable " << phonet->get_dba() 
			  << " like:" << endl
			  << " setenv " << phonet->get_dba()
			  << " \"mbrola -f 1.1 ~/MBROLA/WWWDBA/"
			  << phonet->get_dba() << "/" << phonet->get_dba()
			  << " - -.au | audioplay \" " 
			  << endl 
			  << " export " << phonet->get_dba()
			  << "=\"mbrola -f 1.1 ~/MBROLA/WWWDBA/"
			  << phonet->get_dba() << "/" << phonet->get_dba()
			  << " - - | rawplay \" " 
			  << endl << endl
			  << " If you don't have mbrola yet, you can display the phonetic output with:" 
			  << endl
			  << "setenv " << phonet->get_dba() << " \"cat > /dev/null\"" << endl << endl
			  << "If you want to download MBROLA and a voice database:" << endl
			  << "   http://tcts.fpms.ac.be/synthesis" << endl;
		return 2;
	 }

  printf("Ready:\n");
  char word[255];
  while ( cin.getline(word, sizeof(word)))
	 {
		strstream outpho;
		LPhonemePlus lpp;
		
		try
		  {
			 phonet->transcribe(lpp, word, 130, 40, 1);
			 
			 // End with a Flush command
			 outpho << "; Target " << word << endl 
					  << "_ 100\n" << lpp << endl << "_ 100\n#" << endl << char(0);
			 
			 // French FR1/FR2 database or American English US1/US2
			 FILE* out= popen(mbrola_command,"w");
			 if (out == NULL)
				fatal_message(-1,"Command failed: %s",mbrola_command);

			 char* local= outpho.str();
			 fprintf(out,"%s", local);
			 fprintf(stderr,"%s",local);
			 fclose(out);
			 
			 // Strstream is not responsible any more
			 delete[] local;
		  }
		catch (int somthg_wrong)
		  {
			 // We'll handle this another day
		  }
	 }
}
