#!/usr/local/bin/perl
# File: iterativelyAlign.pl
# Purpose: iteratively compute Letter/Phoneme affinity matrix, align, 
# until converge
# Author: Kevin Lenzo
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 1
#
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

$| = 1;

if (@ARGV > 3 or @ARGV < 1) {
    print STDERR "\n";
    print STDERR "  Usage: $0 dictionary [nb_skip [<alignment_file>]]\n";
    print STDERR "  nb_skip is the number of attributes to ignore in the dictionary such as Part of Speech tags\n";
    exit(-1);
}

$dictionary  = shift @ARGV;
$iterations  = 50;

$nb_skip= shift @ARGV;
if (!$nb_skip)
{
	 $nb_skip=0;
}

$alignBase   = "_$dictionary.ali";
$affineBase   = "_$dictionary.aff";

$origAligned = shift @ARGV;

if (!$origAligned) {
    $newAffine =  "$affineBase.0";
    $newAligned = "$alignBase.0";

    # get the initial letter-phone affinities from the dictionary
    # $command = "t2p_affinities_from_dict.pl $dictionary > $newAffine";

	 # IMPORTANT: I skip the seed -> gain a lot of time
	 # Means initializing from words with same length for graphemic/phonemic strings
    $command = "t2p_affinities_from_align.pl $dictionary $nb_skip > $newAffine";
    print "# 0: $command\n";
    print STDERR "# 0: $command\n";
    print STDERR `$command`;

    # generate an alignment using the given affinities
    $command = "t2p_affinities_align.pl $newAffine $dictionary $nb_skip > $newAligned";
    
    print "# 0: $command\n";
    print STDERR "# 0: $command\n";
    print STDERR `$command`;

    $origAligned = $newAligned;
}

$aligned = $origAligned;

print STDERR "# $iterations iterations using the $dictionary dictionary\n";
print STDERR "# $origAligned is the initial alignment.\n";

for $i (1..$iterations) {
    $format = '%0.'.length($iterations).'d';
    $fnum = sprintf($format, $i);

    $newAffine =  "$affineBase.$fnum";
    $newAligned = "$alignBase.$fnum";

    # get the affinities from the alignment
    $command = "t2p_affinities_from_align.pl $aligned $nb_skip > $newAffine";
    print "# $i: $command\n";
    print STDERR "# $i: $command\n";
    print STDERR `$command`;

    # re-align the dictionary using the derived affinities
    $command = "t2p_affinities_align.pl $newAffine $dictionary $nb_skip > $newAligned"; 
    print "# $i: $command\n";
    print STDERR "# $i: $command\n";
    print STDERR `$command`;

	 # Stop when the alignment stops moving
    last if (system("diff $aligned $newAligned") == 0);
    $aligned = $newAligned;
}
