char ProgInfo[]=
"/*                                                \n"
"* File: t2p_align_from_affinities.cpp             \n"
"* Purpose: DTW alignement letter/phoneme          \n"
"* Author: Vincent Pagel ( pagel@tcts.fpms.ac.be ) \n"
"* Version : 0.4                                   \n"
"* Time-stamp: <00/03/09 14:00:33 pagel>         \n"
"*                                                 \n"
"* Copyright (c) 2000 Faculte Polytechnique de Mons (TCTS lab) \n"
"*                                                             \n"
"* This program is free software; you can redistribute it and/or modify \n"
"* it under the terms of the GNU General Public License as published by \n"
"* the Free Software Foundation version 1 \n"
"* \n"
"* This program is distributed in the hope that it will be useful, \n"
"* but WITHOUT ANY WARRANTY; without even the implied warranty of \n"
"* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the \n"
"* GNU General Public License for more details. \n"
"* \n"
"* You should have received a copy of the GNU General Public License \n"
"* along with this program; if not, write to the Free Software \n"
"* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. \n"
"* \n"
"* History: \n"
"* \n"
"*  19/02/99 : Created.  \n"
"*  02/03/99 : probability( phone | letters + next letter)\n"
"*  06/03/00 : bug, extra white spaces mismatch alignment\n"
"*/\n";

#include <fstream>
#include "Dtw.hpp"

int main(int argc, char **argv)
{
  if (argc<4)
	 {
		cerr << ProgInfo;
		cerr << "Usage: " << argv[0] << " affinity_file dictionary nb_tags [threshold] [back_off] [debug]" << endl;
		return 1;
	 }

  char* affinity_in_name=argv[1];
  char* dictionary_in_name=argv[2];
  int nb_tags=atoi(argv[3]);

  double threshold=1;			  // Min proba
  if (argc>=5)
	 threshold=atof(argv[4]);
  
  bool back_off=false; // maximum size of clusters emitting epsilon (0 means no epsilon at all)
  if (argc>=6)
	 back_off= ( atoi(argv[5])==1 );
  
  bool debug= (argc==7);
  
  // *****************************************************
  // Read affinity matrix from file and initialize the DTW
  // *****************************************************
  ifstream affinity_in(affinity_in_name);
  if (!affinity_in.is_open())
	 {
		cerr << "affinity fails\n";
		exit(2);
	 }
  Dtw my_dtw(affinity_in, back_off, threshold, debug);
  
  // *********************************
  // Align each word in the dictionary
  // *********************************
  ifstream dictionary_in(dictionary_in_name);
  if (!dictionary_in.is_open())
	 {
		cerr << "Dictionary fails\n";
		return 2;
	 }

  // Warning: don't use notation "dictionary_in >> head_word" because
  // it requires you set "locale" properly when compiling foreign languages
  // unless you wish unwanted behavior upon accented chars
  char head_word[1024];
  while( dictionary_in.getline(head_word, sizeof(head_word),' ') )
	 {
		dictionary_in >> ws; // eat white spaces

		// Read eventual tags
		string tags;
		for(int i=0;i<nb_tags;i++)
		  {
			 char tag[255];
			 dictionary_in.getline(tag, sizeof(tag),' ');
			 dictionary_in >> ws; // eat white spaces

			 tags+= tag;
		  }
		
		char phonet[1024];
		dictionary_in.getline(phonet, sizeof(phonet));
		
		// Compute the best alignment path
		my_dtw.align(head_word, phonet, tags);
	 }
}

