/*
 * File:    affinity.hpp
 * Purpose: Letter^n | phoneme affinity matrix
 * Author:  Vincent Pagel ( pagel@tcts.fpms.ac.be )
 * Version : 0.99
 * Time-stamp: <1999-02-22 12:51:32 pagel>
 * 
 * Copyright (c) 1998 Faculte Polytechnique de Mons (TCTS lab)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 1
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * 19/02/99: Created (replace t2p_affinities_align.pl)
 */

#ifndef AFFINITY_HPP
#define AFFINITY_HPP

#include <map>
#include <string>
#include <iostream>

// Probability of letter|phonemes or phonemes|letters association
// At the moment the convention is to write in the string 'letters|phoneme'
class Affinity: public map<string, double, less<string> > 
{
public:
  // Constructor from an initialization file ( pairs string|probability )
  Affinity(istream& affinity_in);

  // true if the association letter/phone is in the matrix
  bool search(const string& letters, const string& phone, double& probability) const;

  // print the matrix
  friend ostream& operator<< (ostream& o, const Affinity& aff);
};

#endif
