/*
 * File:    affinity.cpp
 * Purpose: Letter^n | phoneme affinity matrix
 * Author:  Vincent Pagel ( pagel@tcts.fpms.ac.be )
 * Version : 0.99
 * Time-stamp: <1999-02-22 13:00:11 pagel>
 * 
 * Copyright (c) 1998 Faculte Polytechnique de Mons (TCTS lab)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 1
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * 19/02/99: Created (replace t2p_affinities_align.pl)
 */


/*
#include <map>
#include <string>
#include <iostream>
*/

#include "Affinity.hpp"

// Constructor read from an initialization file
Affinity::Affinity(istream& affinity_in)
{
  char key[255];					  //  Keys ending with char(0) as space may be part of a key
  while(affinity_in.getline(key, sizeof(key),0))
	 {  
		double proba;
		affinity_in >> proba;
		
		// Till the end of the line
		char rest[255];
		affinity_in.getline(rest, sizeof(rest));
		
		insert(Affinity::value_type(string(key),proba));
	 }
}

// Search an association in the affinity matrix
bool 
Affinity::search(const string& letters, const string& phone, double& probability) const
{
  string key= letters+"|"+phone;
  Affinity::const_iterator position= find(key);
  
  if (position==end())
	 return false;
  
  probability= (*position).second;
  return true;
}

ostream& 
operator<< (ostream& o, const Affinity& aff)
{
  for(Affinity::const_iterator i= aff.begin() ; i != aff.end() ; i++)
	 {
		// the association key      the probability
		o << (*i).first << " " << (*i).second << endl;
	 }
  return o;
}

