package info.magnolia.projects.lm.templates.components;

import info.magnolia.context.MgnlContext;
import info.magnolia.module.templatingkit.functions.STKTemplatingFunctions;
import info.magnolia.module.templatingkit.templates.components.EventsOverviewModel;
import info.magnolia.rendering.model.RenderingModel;
import info.magnolia.rendering.template.TemplateDefinition;
import info.magnolia.templating.functions.TemplatingFunctions;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

import javax.inject.Inject;
import javax.jcr.Node;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("unused")
public class LmEventsOverviewModel extends EventsOverviewModel {

    private static final Logger log = LoggerFactory.getLogger(LmEventsOverviewModel.class);

    private static final String[] dateFormats = new String[]{"dd.MM.yyyy", "yyyy-MM-dd", "MM/dd/yyyy"};

    @Inject
    public LmEventsOverviewModel(Node content, TemplateDefinition definition, RenderingModel<?> parent, STKTemplatingFunctions stkFunctions, TemplatingFunctions templatingFunctions) {
        super(content, definition, parent, stkFunctions, templatingFunctions);
    }

    @Override
    public Calendar getMinDate() {
        final String dateParam = MgnlContext.getParameter("date");
        final String fromDateParam = MgnlContext.getParameter("fromDate");

        if (StringUtils.isNotEmpty(fromDateParam)) {
            try {
                Date fromDate = DateUtils.parseDate(fromDateParam, dateFormats);
                this.minDate.setTimeInMillis(fromDate.getTime());

                return minDate;
            } catch (ParseException e) {
                log.error("Could not parse date: " + fromDateParam);
            }
        } else {
            if (StringUtils.isEmpty(dateParam)) {
                // initialize minDate
                this.minDate = super.getMinDate();

                // set the day to the current day of the month
                this.minDate.set(Calendar.DAY_OF_MONTH, Calendar.getInstance().get(Calendar.DAY_OF_MONTH));

                return minDate;
            }
        }

        return super.getMinDate();
    }

    @Override
    public Calendar getMaxDate() {
        final String toDateParam = MgnlContext.getParameter("toDate");

        if (StringUtils.isNotEmpty(toDateParam)) {
            try {
                Date toDate = DateUtils.parseDate(toDateParam, dateFormats);
                this.maxDate.setTimeInMillis(toDate.getTime());

                return maxDate;
            } catch (ParseException e) {
                log.error("Could not parse date: " + toDateParam);
            }
        }

        return super.getMaxDate();
    }

}
