package info.magnolia.projects.lm.actions;

import info.magnolia.jcr.util.NodeTypes;
import info.magnolia.jcr.util.PropertyUtil;
import info.magnolia.projects.lm.util.PageUtil;
import info.magnolia.ui.api.action.ActionExecutionException;
import info.magnolia.ui.form.EditorCallback;
import info.magnolia.ui.form.EditorValidator;
import info.magnolia.ui.form.action.SaveFormAction;
import info.magnolia.ui.form.action.SaveFormActionDefinition;
import info.magnolia.ui.vaadin.integration.jcr.JcrNodeAdapter;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("unused")
public class SaveEventFormAction extends SaveFormAction {

    private static final Logger log = LoggerFactory.getLogger(SaveEventFormAction.class);

    public SaveEventFormAction(SaveFormActionDefinition definition, JcrNodeAdapter item, EditorCallback callback, EditorValidator validator) {
        super(definition, item, callback, validator);
    }

    @Override
    public void execute() throws ActionExecutionException {
        // First Validate
        validator.showValidation(true);
        if (validator.isValid()) {
            try {
                final Node node = item.applyChanges();
                // Set the Node name.
                setNodeName(node, item);
                NodeTypes.LastModified.update(node);

                node.getSession().save();

                // Update data for event page (website)
                Node page = PageUtil.findEventPage(item.getItemProperty("id").toString());

                if (page != null) {
                    updateEventPage(page);
                }
            } catch (final RepositoryException e) {
                throw new ActionExecutionException(e);
            }
            callback.onSuccess(getDefinition().getName());
        } else {
            log.info("Validation error(s) occurred. No save performed.");
        }
    }

    protected void updateEventPage(Node page) {
        try {
            PropertyUtil.setProperty(page, "title", item.getItemProperty("title").toString());
            PropertyUtil.setProperty(page, "eventTitle", item.getItemProperty("eventTitle").toString());
            PropertyUtil.setProperty(page, "date", item.getItemProperty("date").getValue());
            PropertyUtil.setProperty(page, "dateEnd", item.getItemProperty("dateEnd").getValue());
            PropertyUtil.setProperty(page, "zeit", item.getItemProperty("zeit").toString());
            PropertyUtil.setProperty(page, "location", item.getItemProperty("location").toString());
            PropertyUtil.setProperty(page, "bezirk", item.getItemProperty("bezirk").toString());
            PropertyUtil.setProperty(page, "link", item.getItemProperty("link").toString());
            PropertyUtil.setProperty(page, "veranstalter", item.getItemProperty("veranstalter").toString());
            PropertyUtil.setProperty(page, "mail", item.getItemProperty("mail").toString());
            PropertyUtil.setProperty(page, "bemerkungen", item.getItemProperty("bemerkungen").toString());
            NodeTypes.LastModified.update(page);

            page.getSession().save();
        } catch (RepositoryException e) {
            log.error("Problem while updating event page (website): " + e.getMessage());
        }
    }


}
