lexer grammar InternalMyFirewall;
@header {
package org.myfirewall.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

T11 : 'script' ;
T12 : '{' ;
T13 : 'interfaces internal' ;
T14 : 'external' ;
T15 : ';' ;
T16 : 'allow incoming {' ;
T17 : '}' ;
T18 : 'allow outgoing {' ;
T19 : '.' ;
T20 : 'host' ;
T21 : '=' ;
T22 : 'net' ;
T23 : '/' ;
T24 : 'service' ;
T25 : 'proto' ;
T26 : '(' ;
T27 : ',' ;
T28 : ')' ;
T29 : 'port' ;
T30 : 'to' ;
T31 : ':' ;
T32 : 'tcp' ;
T33 : 'udp' ;

// $ANTLR src "../org.myfirewall/src-gen/org/myfirewall/parser/antlr/internal/InternalMyFirewall.g" 1137
RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

// $ANTLR src "../org.myfirewall/src-gen/org/myfirewall/parser/antlr/internal/InternalMyFirewall.g" 1139
RULE_INT : ('0'..'9')+;

// $ANTLR src "../org.myfirewall/src-gen/org/myfirewall/parser/antlr/internal/InternalMyFirewall.g" 1141
RULE_STRING : ('"' ('\\' ('b'|'t'|'n'|'f'|'r'|'"'|'\''|'\\')|~(('\\'|'"')))* '"'|'\'' ('\\' ('b'|'t'|'n'|'f'|'r'|'"'|'\''|'\\')|~(('\\'|'\'')))* '\'');

// $ANTLR src "../org.myfirewall/src-gen/org/myfirewall/parser/antlr/internal/InternalMyFirewall.g" 1143
RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

// $ANTLR src "../org.myfirewall/src-gen/org/myfirewall/parser/antlr/internal/InternalMyFirewall.g" 1145
RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

// $ANTLR src "../org.myfirewall/src-gen/org/myfirewall/parser/antlr/internal/InternalMyFirewall.g" 1147
RULE_WS : (' '|'\t'|'\r'|'\n')+;

// $ANTLR src "../org.myfirewall/src-gen/org/myfirewall/parser/antlr/internal/InternalMyFirewall.g" 1149
RULE_ANY_OTHER : .;


