package com.hemju.biborder;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * This class is the entry point for doing a reorder. It takes a file path from the the content is read and a strategy
 * of the order.
 *
 * @author Helmut Juskewycz, <hjuskewycz - at - hemju.com>
 */
public class BibReorder {

  private final String filePath;
  private final OrderStrategy orderer;

  public BibReorder(String filePath, OrderStrategy orderer) {
    this.filePath = filePath;
    this.orderer = orderer;
  }

  public void reorder(OutputStream out) {
    FileInputStream fis = null;

    try {
      fis = new FileInputStream(filePath);
      orderer.order(fis, out);
    } catch (FileNotFoundException ex) {
      Logger.getLogger(BibReorder.class.getName()).log(Level.SEVERE, null, ex);
    } finally {
      if (fis != null) {
        try {
          fis.close();
        } catch (IOException ex) {
          Logger.getLogger(BibReorder.class.getName()).log(Level.SEVERE, null, ex);
        }
      }
    }
  }
}
