/*
 * Decompiled with CFR 0.152.
 */
package com.hemju.biborder;

import com.hemju.biborder.OrderStrategy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OrderAll
implements OrderStrategy {
    private static final int WRITE_BUFFER_SIZE = 16384;
    private static final int READ_BUFFER_SIZE = 16384;
    private static final char[] READ_BUFFER = new char[16384];
    private static final char[] WRITE_BUFFER = new char[16384];
    private static final int DIGITAL_MIN_VALUE = 48;
    private static final int DIGITAL_MAX_VALUE = 57;

    public void order(InputStream in, OutputStream out) {
        try {
            int charsRead;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(in)));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(out)));
            StringBuilder bibEntry = null;
            boolean bibRefStart = false;
            HashMap<String, String> mapping = new HashMap<String, String>(1000);
            int counter = 1;
            int charsWritten = 0;
            while ((charsRead = reader.read(READ_BUFFER)) >= 0) {
                for (int j = 0; j < charsRead; ++j) {
                    char actChar = READ_BUFFER[j];
                    if (bibRefStart) {
                        if (actChar == ']' && bibEntry != null) {
                            String key = bibEntry.toString();
                            String value = (String)mapping.get(key);
                            if (value == null) {
                                String newBibRef = counter++ + "";
                                mapping.put(key, newBibRef);
                                value = newBibRef;
                            }
                            int bibRefLength = value.length();
                            for (int m = 0; m < bibRefLength; ++m) {
                                OrderAll.WRITE_BUFFER[charsWritten++] = value.charAt(m);
                                if (charsWritten < 16384) continue;
                                writer.write(WRITE_BUFFER);
                                charsWritten = 0;
                            }
                        }
                        if (actChar >= '0' && actChar <= '9') {
                            if (bibEntry == null) {
                                bibEntry = new StringBuilder();
                            }
                            bibEntry.append(actChar);
                        } else {
                            bibRefStart = false;
                            bibEntry = null;
                            OrderAll.WRITE_BUFFER[charsWritten++] = actChar;
                        }
                    } else {
                        bibRefStart = actChar == '[';
                        OrderAll.WRITE_BUFFER[charsWritten++] = actChar;
                    }
                    if (charsWritten < 16384) continue;
                    writer.write(WRITE_BUFFER);
                    charsWritten = 0;
                }
            }
            writer.write(WRITE_BUFFER);
        }
        catch (IOException ex) {
            Logger.getLogger(OrderAll.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

