"""Jukebox Database Models

Simple music collection schema
"""

from django.db import models
from django.core.validators import NumberIsInRange

# Create your models here.
class Genre(models.Model):
    """Simple genre name
    """
    desc = models.CharField(maxlength=20)

    def __str__(self):
        return self.desc

    class Admin:
        pass

class Music(models.Model):
    """Simple minimal replresentation of a song, artist, data and genre
    """
    title = models.CharField(maxlength=72)
    artist = models.CharField(maxlength=72)
    year = models.IntegerField(validator_list=[NumberIsInRange(1000, 9999),])
    genre = models.ForeignKey(Genre)

    def __str__(self):
        return self.title

    class Meta:
        ordering = ('artist', 'title', 'genre', 'year' )

    class Admin:
        list_display = ('title', 'artist', 'year', 'genre')
        ordering = ('artist', 'title', 'genre', 'year' )
        list_filter = ('genre',)
        search_fields = ('artist', 'title', 'genre__desc')
