package de.wartala.client;

import com.google.gwt.user.client.HTTPRequest;
import com.google.gwt.user.client.ResponseTextHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

public class MyAddressRequester {

	/*
	 * The URL where we go to do the address search.
	 */
	private String DEFAULT_SEARCH_URL = "http://localhost:3000/name/find_names_to_json";

	/*
	 * Some widgets that we go to need.
	 */

	private Button b1 = new Button();

	private Grid gdOut = new Grid(2, 1);
	
	private FlexTable table = new FlexTable();

	private TextBox txtBox = new TextBox();

	private int itemNumber = 0;

	public Widget initializeMainForm() {

		/*
		 * Here we initialize and setup a panel for use it as container for the
		 * search form and the results.
		 */

		FocusPanel fpn = new FocusPanel();
		Grid gd = new Grid(1, 2);

		b1.setText("Search");
		b1.addClickListener(new SearchButtonClickListener());
		txtBox.setStyleName("text-input");
		
		gd.setWidget(0, 0, txtBox);
		gd.setWidget(0, 1, b1);

		gdOut.setWidget(0, 0, gd);

		gdOut.setBorderWidth(1);
		gdOut.setWidth("500px");

		table.setCellSpacing(0);
	    table.setCellPadding(2);
	    table.setWidth("100%");
	    table.setText(0, 0, "ID");
	    table.setText(0, 1, "firstname");
	    table.setText(0, 2, "lastname");
	    table.setText(0, 3, "email");
	    table.getRowFormatter().setStyleName(0, "table-ListHeader");

		fpn.add(gdOut);

		return fpn;
	}

	private class SearchButtonClickListener implements ClickListener {
		/*
		 * (non-Javadoc)
		 * 
		 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
		 */
		public void onClick(Widget sender) {
			/*
			 * When the user click the button we fetch the URL.
			 */
			itemNumber = 0;
			doFetchURL();
		}

		private void doFetchURL() {
			/*
			 * Here we fetch the URL and call the handler
			 */
			b1.setText("Searching ...");
			if (!HTTPRequest.asyncGet(DEFAULT_SEARCH_URL + "?lastname="
					+ txtBox.getText(), new JSONResponseTextHandler())) {

				b1.setText("Search");
			}
		}
	}

	private class JSONResponseTextHandler implements ResponseTextHandler {
		/*
		 * (non-Javadoc)
		 * 
		 * @see com.google.gwt.user.client.ResponseTextHandler#onCompletion(java.lang.String)
		 */

		public void onCompletion(String responseText) {
			/*
			 * When the fetch has been completed we parse the JSON response and
			 * display the result
			 */

			JSONObject jsonObject;
			try {
				jsonObject = JSONParser.parse(responseText);
				displayJSONObject(jsonObject);

			} catch (JSONException e) {

			}

			b1.setText("Search");

		}

		private void displayJSONObject(JSONObject jsonObject) {
			/*
			 * Here we clear the grid and fill it with the new values.
			 */
			table.clear();
			updateAddressTable(jsonObject);
			gdOut.setWidget(1, 0, table);

		}

		private void updateAddressTable(JSONValue jsonValue) {
			// the main JSON object
			JSONObject jsonObject = jsonValue.isObject();
			String[] keys = jsonObject.getKeys();
			itemNumber = 1;	
			for (int i = 0; i < keys.length; ++i) {
				String key = keys[i];
						
				if(jsonObject.get(key).isObject() != null) {
					JSONObject jsonValueKeys = jsonObject.get(key).isObject();
					String[] valueKeys = jsonValueKeys.getKeys();
							
					for(int j = 0; j < valueKeys.length; j++) {
						String valueKey = valueKeys[j];
						JSONObject jsonData = jsonValueKeys.get(valueKey).isObject();
						int col = 0;
						table.setWidget(itemNumber, col++, new Label(jsonData.get("id").toString()));
						table.setWidget(itemNumber, col++, new Label(jsonData.get("firstname").toString()));
						table.setWidget(itemNumber, col++, new Label(jsonData.get("lastname").toString()));
						table.setWidget(itemNumber, col++, new Label(jsonData.get("email").toString()));
					}
				} else if (jsonValue != null) {
					// it is safe to handle all non-null cases by simply using
				} else {
					// 
				}
				itemNumber++;
			}

		}

	}

}