function ResultsAssistant(argFromPusher) {
	this.results = argFromPusher[0];
	this.latitude = argFromPusher[1];
	this.longitude = argFromPusher[2];
}

ResultsAssistant.prototype = {
	setup: function() {
		Ares.setupSceneAssistant(this);
		this.$.list1.model.items = this.results.Result;
		this.controller.modelChanged(this.$.list1.model);
		this.setMarkers();
		this.centerMap();
	},
	cleanup: function() {
		Ares.cleanupSceneAssistant(this);
	},
	setMarkers: function() {
		var i, point, marker;
		
		for(i = 0; i < this.results.Result.length; i++)
		{
			point = new google.maps.LatLng(this.results.Result[i].Latitude, this.results.Result[i].Longitude);
			marker = new google.maps.Marker({position: point, map: this.$.map1.map});
		}
	},
	centerMap: function() {
		if(this.latitude == undefined)
		{
			this.$.map1.map.setCenter(new google.maps.LatLng(this.results.Result[0].Latitude, this.results.Result[0].Longitude));
		}
		else
		{
			this.$.map1.map.setCenter(new google.maps.LatLng(this.latitude, this.longitude));
		}
	}

};