function MainAssistant(argFromPusher) {
}

MainAssistant.prototype = {
	setup: function() {
		Ares.setupSceneAssistant(this);
	},
	cleanup: function() {
		Ares.cleanupSceneAssistant(this);
	},
	ZIPSearchButtonTap: function(inSender, event) {
		var zip = this.$.ZIPCode.fetchModelProperty("value");
		this.$.webService1.parameters.zip = zip;
		this.latitude = this.longitude = undefined;
		this.$.webService1.execute();
	},
	webService1Success: function(inSender, inResponse, inRequest) {
		if(inResponse.ResultSet && (inResponse.ResultSet.totalResultsReturned > 0))
		{
			this.controller.stageController.pushScene("results", [inResponse.ResultSet, this.latitude, this.longitude]);
		}
		else
		{
			Mojo.Controller.errorDialog("No results found!");
		}
		// Disable the spinners on the buttons once our Web request is done
		this.$.ZIPSearchButton.active = false;
		this.$.ZIPSearchButton.activeChanged();
		this.$.GPSSearchButton.active = false;
		this.$.GPSSearchButton.activeChanged();
	},
	webService1Failure: function(inSender, inError) {
		Mojo.Controller.errorDialog("Unable to communicate with the server!");
		// Disabled the spinners after an error
		this.$.ZIPSearchButton.active = false;
		this.$.ZIPSearchButton.activeChanged();
		this.$.GPSSearchButton.active = false;
		this.$.GPSSearchButton.activeChanged();
	},
	GPSSearchButtonTap: function(inSender, event) {
		this.$.gps1.getCurrentPosition();
	},
	gps1Success: function(inSender, inResponse, inRequest) {
		if(inResponse.errorCode == 0)
		{
			this.latitude = inResponse.latitude;
			this.longitude = inResponse.longitude;
			delete this.$.webService1.parameters.zip;
			this.$.webService1.parameters.latitude = this.latitude;
			this.$.webService1.parameters.longitude = this.longitude;
			this.$.webService1.execute();
		}
		else
		{
			Mojo.Controller.errorDialog("GPS Error!");
			this.$.GPSSearchButton.active = false;
			this.$.GPSSearchButton.activeChanged();
		}
	},
	gps1Failure: function(inSender, inError) {
		Mojo.Controller.errorDialog("GPS Error!");
		this.$.GPSSearchButton.active = false;
		this.$.GPSSearchButton.activeChanged();
	}
};