// Project: Delta.Rendering.Tutorials

using System;
using Delta.Engine;
using Delta.InputSystem;
using Delta.Utilities.Datatypes;
using Delta.Rendering.Basics.Materials;
using Delta.Rendering.Basics;

namespace Delta.Rendering.Tutorials
{
	/// <summary>
	/// This class provides a great list of tutorials to start with
	/// when you're new to the Delta Engine. Simply comment in the tutorial
	/// call in the Main method you want to check out.
	/// </summary>
	public class Tutorials
	{
		// Note: This class is usually a lot bigger and has many tutorials :)

		#region Tutorial 12: Blocks Game
		/// <summary>
		/// Blocks game for the Smart Developer Article in April 2011 (60 lines).
		/// </summary>
		public static void BlocksGame()
		{
			Material2D background = new Material2D("SpaceBackground");
			background.DrawLayer = RenderLayer.Background;
			Material2D block = new Material2D("Block");
			// Define a field of 9x9 blocks
			const int FieldWidth = 9, FieldHeight = 9;
			bool[,] field = new bool[FieldWidth, FieldHeight];
			int currentBlockX = 4, currentBlockY = 0;
			Rectangle fieldRect = new Rectangle(0.2f, 0.2f, 0.6f, 0.6f);
			Application.Start(delegate
			{
				// Move left right depending on where the user touched the screen
				float inputX = 0.5f;
				if (Input.Touch.TouchReleased)
					inputX = Input.Touch.Position.X;
				// Note: Also supporting Mouse and Keyboard input now ;)
				if ((inputX < 0.45f || Input.Keyboard.CursorLeftReleased) &&
					currentBlockX > 0)
					currentBlockX--;
				else if ((inputX > 0.55f || Input.Keyboard.CursorRightReleased) &&
					currentBlockX < FieldWidth - 1)
					currentBlockX++;
				// Only handle this every 0.25 seconds (4 times per sec).
				if (Time.CheckEvery(0.25f))
				{
					// Check if we can move block one down
					if (currentBlockY < FieldHeight - 1 &&
						field[currentBlockX, currentBlockY + 1] == false)
					{
						currentBlockY++;
					}
					// Otherwise fix this block and create a new one at the top
					else
					{
						field[currentBlockX, currentBlockY] = true;
						currentBlockX = 4;
						currentBlockY = 0;
						// Quick check if the bottom line is now full
						int blocksInLine = 0;
						for (int x = 0; x < FieldWidth; x++)
							if (field[x, FieldHeight - 1])
								blocksInLine++;
						if (blocksInLine == FieldWidth)
						{
							// Move everything one down (we have to do it upside down)!
							for (int y = FieldHeight - 1; y > 0; y--)
								for (int x = 0; x < FieldWidth; x++)
									field[x, y] = field[x, y - 1];
						}
					} // else
				} // if

				// Do all drawing, first the background
				background.Draw(Rectangle.One);
				// And then draw all field blocks
				for (int x = 0; x < FieldWidth; x++)
					for (int y = 0; y < FieldHeight; y++)
						if (field[x, y])
							block.Draw(fieldRect.GetInnerRectangle(new Rectangle(
								x / (float)FieldWidth, y / (float)FieldHeight,
								1.0f / (float)FieldWidth, 1.0f / (float)FieldHeight)));
				// And finally also add the current block
				block.Draw(fieldRect.GetInnerRectangle(new Rectangle(
					currentBlockX / (float)FieldWidth,
					currentBlockY / (float)FieldHeight,
					1.0f / (float)FieldWidth, 1.0f / (float)FieldHeight)));
			});
		} // BlocksGame()
		#endregion
	} // class Tutorials
} // namespace Delta.Rendering.Tutorials
