#include "Form1.h"
#include <FContent.h>

using namespace Osp::Base;
using namespace Osp::Ui;
using namespace Osp::Ui::Controls;

Form1::Form1(void)
{

	__pCamera = 0;
	__pBitmap = 0;
	__doCapture = false;

}

Form1::~Form1(void)
{
	if(0!=__pCamera)
	{
		if(__pCamera->IsPoweredOn())
		{
			__pCamera->PowerOff();
		}
		delete __pCamera;
		__pCamera = 0;
	}

	if(0!=__pBitmap)
	{
		delete __pBitmap;
		__pBitmap = 0;
	}
}
//########################################### END
bool
Form1::Initialize()
{
	// Construct an XML form
	Construct(L"IDF_FORM1");

	return true;
}
result
Form1::OnInitializing(void)
{
	result r = E_SUCCESS;

	// TODO: Add your initialization code here

	// Get a button via resource ID
	__pButtonOk = static_cast<Button *>(GetControl(L"IDC_BUTTON_OK"));
	if (__pButtonOk != null)
	{
		__pButtonOk->SetActionId(ID_BUTTON_OK);
		__pButtonOk->AddActionEventListener(*this);
	}

	InitCamera();

	return r;
}

result
Form1::OnTerminating(void)
{
	result r = E_SUCCESS;

	// TODO: Add your termination code here

	return r;
}

void
Form1::OnActionPerformed(const Osp::Ui::Control& source, int actionId)
{
	switch(actionId)
	{
	case ID_BUTTON_OK:
		{
			AppLog("OK Button is clicked! \n");
		}
		break;
	default:
		break;
	}
}

void Form1::InitCamera(){

	__h = 480;
	__w = 640;
	__pCamera = new Osp::Media::Camera();
	result r = __pCamera->Construct( (*this),Osp::Media::CAMERA_SECONDARY);

	//Ausgabe der Mglichen Auflsungen und Formate
	Osp::Base::Collection::IListT<Osp::Graphics::PixelFormat>* pixelList = __pCamera->GetSupportedPreviewFormatListN();
	if(0==pixelList)
	{
		AppLog("Can't get PixelList:%s",GetErrorMessage(GetLastResult()));
	}
	else
	{
		int count = pixelList->GetCount();
		for(int i=0;i< count;i++)
		{
			Osp::Graphics::PixelFormat pf = Osp::Graphics::PIXEL_FORMAT_MIN;
			pixelList->GetAt(i,pf);
			AppLog("PixelFormat[%d]: %d",i,pf);
		}
		delete pixelList;
	}
	Osp::Base::Collection::IList* list = __pCamera->GetSupportedPreviewResolutionListN();
	if(0==list)
	{
		AppLog("Can't get List:%s",GetErrorMessage(GetLastResult()));
	}
	else
	{
		int count = list->GetCount();
		for(int i=0;i< count;i++)
		{
			Osp::Graphics::Dimension* dim = static_cast<Osp::Graphics::Dimension*>(list->GetAt(i));
			AppLog("Resolutions[%d]: %i,%i",i, dim->width,dim->height);
		}
		delete list;
	}
	if(E_SUCCESS != r)
	{
		AppLog("Camera Construct problem: %s",GetErrorMessage(r));
	}

	r  = __pCamera->SetPreviewFormat(Osp::Graphics::PIXEL_FORMAT_YCbCr420_PLANAR);

	if(E_SUCCESS != r)
	{
		AppLog("Camera SetPreviewFormat problem: %s",GetErrorMessage(r));
	}

	r = __pCamera->SetPreviewResolution(Osp::Graphics::Dimension(__w,__h));
	if(E_SUCCESS != r)
	{
		AppLog("Camera SetPreviewResolution problem: %s",GetErrorMessage(r));
	}

	r = __pCamera->SetPreviewFrameRate(15);
	if(E_SUCCESS != r)
	{
		AppLog("Camera SetPreviewFrameRate problem: %s",GetErrorMessage(r));
	}

	if(0!=__pBitmap)
	{
		delete __pBitmap;
		__pBitmap = 0;
	}
	__pBitmap = new Osp::Graphics::Bitmap();
	__pBitmap->Construct(Osp::Graphics::Dimension(__w,__h),Osp::Graphics::BITMAP_PIXEL_FORMAT_ARGB8888);

	r = __pCamera->PowerOn();
	r = __pCamera->StartPreview(null, true);

	if(E_SUCCESS != r)
	{
		AppLog("Camera StartPreview problem: %s",GetErrorMessage(r));
	}
}

void Form1::ConvertYCbCr420p2RGB888(Osp::Base::ByteBuffer * pB)
{
	//Falls RBG Format dann neues Bitmap erzeugen
	if(Osp::Graphics::PIXEL_FORMAT_RGB565 ==  __pCamera->GetPreviewFormat())
	{
		if(0!=__pBitmap)
		{
			delete __pBitmap;
			__pBitmap = 0;
		}
		__pBitmap = new Osp::Graphics::Bitmap();
		__pBitmap->Construct((*pB),__pCamera->GetPreviewResolution(),Osp::Graphics::BITMAP_PIXEL_FORMAT_RGB565);

		return;
	}

	int hw = __w/2;
	int hh = __h/2;
	byte* pOriY= (byte *)pB->GetPointer();
	byte * pOriCb= pOriY + __w*__h;
	byte * pOriCr = pOriCb + hw*hh;

	Osp::Graphics::BufferInfo bi;
	__pBitmap->Lock(bi);
	for( int j=0;j<__h;j+=2)
	{
		byte * pY0,*pY1, *pCb, *pCr;
		pY0 = pOriY + j*__w;
		pY1 = pOriY + (j+1)*__w;
		pCb = pOriCb + hw*(j/2);
		pCr = pOriCr + hw*(j/2);

		unsigned char * buf = (unsigned char *)bi.pPixels + bi.pitch * j;
		unsigned int * pB0= (unsigned int *)buf;

		buf = (unsigned char *)bi.pPixels + bi.pitch * (j+1);
		unsigned int * pB1= (unsigned int *)buf;
		for( int i=0;i<__w;i+=2)
		{
			int Y[4],Cb,Cr;
			Cb = pCb[i/2] - 128;
			Cr = pCr[i/2] - 128;

			Y[0]=pY0[i];
			Y[1]=pY0[i+1];
			Y[2]=pY1[i];
			Y[3]=pY1[i+1];

			int A,B,C;
			A= Cr + (Cr>>2) + (Cr>>3) + (Cr>>5);
			B= (Cb>>2) + (Cb>>4) + (Cb>>5) + (Cr>>1) + (Cr>>3) + (Cr>>4) + (Cr>>5);
			C= Cb + (Cb>>1) + (Cb>>2) + (Cb>>6);

#define CL(A) 	((A>255)? 255:( (A<0)? 0:A ))
//#define RGBA(R, G, B, A) ( (A <<24) | (B<<16) | (G<<8) | (R) )// FOR OPENGLES
#define RGBA(R, G, B, A) ( (A <<24) | (R<<16) | (G<<8) | (B) )	// FOR GENERAL 2D BITMAP

			pB0[i]   = RGBA(CL(Y[0]+A), CL(Y[0]-B), CL(Y[0]+C), 0XFF);
			pB0[i+1] = RGBA(CL(Y[1]+A), CL(Y[1]-B), CL(Y[1]+C), 0XFF);
			pB1[i]   = RGBA(CL(Y[2]+A), CL(Y[2]-B), CL(Y[2]+C), 0XFF);
			pB1[i+1] = RGBA(CL(Y[3]+A), CL(Y[3]-B), CL(Y[3]+C), 0XFF);
		}
	}

	__pBitmap->Unlock();

}

void Form1::OnCameraPreviewed ( Osp::Base::ByteBuffer& previewedData, result r )
{
//	AppLogDebug("OnCameraPreviewed");
	if(E_SUCCESS != r)
	{
		return;
	}
	Osp::Base::ByteBuffer* copyData = new Osp::Base::ByteBuffer();
	copyData->Construct(previewedData);

	ConvertYCbCr420p2RGB888(copyData);
	delete copyData;
	copyData = 0;

	Osp::Graphics::Canvas* a_canvasPtr = this->GetCanvasN();

	float ratio = (float)this->GetWidth() / (float)__pBitmap->GetWidth();
	int  a_width = this->GetWidth();
	int a_height = __pBitmap->GetHeight()*ratio;

	Osp::Graphics::Rectangle  destRct = Osp::Graphics::Rectangle(0,0,a_width,a_height);
	Osp::Graphics::Rectangle  srcRct = Osp::Graphics::Rectangle(0,0,__pBitmap->GetWidth(),__pBitmap->GetHeight());

	a_canvasPtr->DrawBitmap(destRct,*(__pBitmap),srcRct);

	a_canvasPtr->Show();
	delete a_canvasPtr;

	if(__doCapture)
	{
		Osp::Media::Image* pImage = new Osp::Media::Image();
		pImage->Construct();
		result r = pImage->EncodeToFile(*(__pBitmap),Osp::Media::IMG_FORMAT_JPG,L"/Media/Images/MyCamPic.jpg",true);
		AppLogDebug("Encode result:%s",GetErrorMessage(r));
		delete pImage;

		Osp::Content::ContentManager contentManager;
		contentManager.Construct();

		Osp::Content::ImageContentInfo imageContentInfo;
		imageContentInfo.Construct(L"/Media/Images/MyCamPic.jpg");

		Osp::Content::ContentId id= contentManager.CreateContent(imageContentInfo);
		contentManager.UpdateContent(imageContentInfo);

		__doCapture = false;
	}
}

void Form1::OnCameraAutoFocused( bool completeCondition  )
{
}

void Form1::OnCameraCaptured ( Osp::Base::ByteBuffer& capturedData, result r )
{
}

void Form1::OnCameraErrorOccurred( Osp::Media::CameraErrorReason r )
{
}

