#ifndef _FORM1_H_
#define _FORM1_H_

#include <FBase.h>
#include <FUi.h>
#include <FMedia.h>
class Form1 :
	public Osp::Ui::Controls::Form,
	public Osp::Ui::IActionEventListener,
	public Osp::Media::ICameraEventListener
{
// Construction
public:
	Form1(void);
	virtual ~Form1(void);
	bool Initialize(void);

// Implementation
protected:
	static const int ID_BUTTON_OK = 101;
	Osp::Ui::Controls::Button *__pButtonOk;

	Osp::Media::Camera* __pCamera; //Zeiger auf Kameraobjekt
	Osp::Graphics::Bitmap* __pBitmap; // Zeiger auf Bitmapobjekt
	int __w; //Zum Hinterlegen der Weite unseres Kamerabildes
	int __h;  //Zum Hinterlegen der Hhe unseres Kamerabildes

	bool __doCapture; // Boolean zum festlegen das wir das aktuelle Bild speichern mchten

	void InitCamera();
	void ConvertYCbCr420p2RGB888(Osp::Base::ByteBuffer * pB);

public:
	virtual result OnInitializing(void);
	virtual result OnTerminating(void);
	virtual void OnActionPerformed(const Osp::Ui::Control& source, int actionId);

	// ICameraEventListener-Methoden
	void OnCameraAutoFocused( bool completeCondition  );
	void OnCameraPreviewed ( Osp::Base::ByteBuffer& previewedData, result r );
	void OnCameraCaptured ( Osp::Base::ByteBuffer& capturedData, result r );
	void OnCameraErrorOccurred(  Osp::Media::CameraErrorReason r );
};

#endif	//_FORM1_H_
