/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.content.ContentProviderOperation;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.ContactsContract;
import android.util.Log;
import android.webkit.WebView;
import com.phonegap.ContactAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactAccessorSdk5
extends ContactAccessor {
    private static final Map<String, String> dbMap = new HashMap<String, String>();

    public ContactAccessorSdk5(WebView view, Activity app) {
        this.mApp = app;
        this.mView = view;
    }

    @Override
    public JSONArray search(JSONArray fields, JSONObject options) {
        long totalStart = System.currentTimeMillis();
        String searchTerm = "";
        int limit = 1;
        boolean multiple = false;
        try {
            searchTerm = options.getString("filter");
            searchTerm = searchTerm.length() == 0 ? "%" : "%" + searchTerm + "%";
            multiple = options.getBoolean("multiple");
            if (multiple) {
                limit = options.getInt("limit");
            }
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        HashMap<String, Boolean> populate = this.buildPopulationSet(fields);
        ContactAccessor.WhereOptions whereOptions = this.buildWhereClause(fields, searchTerm);
        Cursor c = this.mApp.getContentResolver().query(ContactsContract.Data.CONTENT_URI, null, whereOptions.getWhere(), whereOptions.getWhereArgs(), "contact_id ASC");
        String contactId = "";
        String rawId = "";
        String oldContactId = "";
        boolean newContact = true;
        String mimetype = "";
        JSONArray contacts = new JSONArray();
        JSONObject contact = new JSONObject();
        JSONArray organizations = new JSONArray();
        JSONArray addresses = new JSONArray();
        JSONArray phones = new JSONArray();
        JSONArray emails = new JSONArray();
        JSONArray ims = new JSONArray();
        JSONArray websites = new JSONArray();
        JSONArray relationships = new JSONArray();
        while (c.moveToNext() && contacts.length() <= limit - 1) {
            try {
                contactId = c.getString(c.getColumnIndex("contact_id"));
                rawId = c.getString(c.getColumnIndex("raw_contact_id"));
                if (c.getPosition() == 0) {
                    oldContactId = contactId;
                }
                if (!oldContactId.equals(contactId)) {
                    contacts.put((Object)this.populateContact(contact, organizations, addresses, phones, emails, ims, websites, relationships));
                    contact = new JSONObject();
                    organizations = new JSONArray();
                    addresses = new JSONArray();
                    phones = new JSONArray();
                    emails = new JSONArray();
                    ims = new JSONArray();
                    websites = new JSONArray();
                    relationships = new JSONArray();
                    newContact = true;
                }
                if (newContact) {
                    newContact = false;
                    contact.put("id", (Object)contactId);
                    contact.put("rawId", (Object)rawId);
                    contact.put("displayName", (Object)c.getString(c.getColumnIndex("display_name")));
                }
                if ((mimetype = c.getString(c.getColumnIndex("mimetype"))).equals("vnd.android.cursor.item/name") && this.isRequired("name", populate)) {
                    contact.put("name", (Object)this.nameQuery(c));
                } else if (mimetype.equals("vnd.android.cursor.item/phone_v2") && this.isRequired("phoneNumbers", populate)) {
                    phones.put((Object)this.phoneQuery(c));
                } else if (mimetype.equals("vnd.android.cursor.item/email_v2") && this.isRequired("emails", populate)) {
                    emails.put((Object)this.emailQuery(c));
                } else if (mimetype.equals("vnd.android.cursor.item/postal-address_v2") && this.isRequired("addresses", populate)) {
                    addresses.put((Object)this.addressQuery(c));
                } else if (mimetype.equals("vnd.android.cursor.item/organization") && this.isRequired("organizations", populate)) {
                    organizations.put((Object)this.organizationQuery(c));
                } else if (mimetype.equals("vnd.android.cursor.item/im") && this.isRequired("ims", populate)) {
                    ims.put((Object)this.imQuery(c));
                } else if (mimetype.equals("vnd.android.cursor.item/note") && this.isRequired("note", populate)) {
                    contact.put("note", (Object)c.getString(c.getColumnIndex("data1")));
                } else if (mimetype.equals("vnd.android.cursor.item/nickname") && this.isRequired("nickname", populate)) {
                    contact.put("nickname", (Object)c.getString(c.getColumnIndex("data1")));
                } else if (mimetype.equals("vnd.android.cursor.item/website") && this.isRequired("urls", populate)) {
                    websites.put((Object)this.websiteQuery(c));
                } else if (mimetype.equals("vnd.android.cursor.item/relation") && this.isRequired("relationships", populate)) {
                    relationships.put((Object)this.relationshipQuery(c));
                } else if (mimetype.equals("vnd.android.cursor.item/contact_event")) {
                    if (1 == c.getInt(c.getColumnIndex("data2")) && this.isRequired("anniversary", populate)) {
                        contact.put("anniversary", (Object)c.getString(c.getColumnIndex("data1")));
                    } else if (3 == c.getInt(c.getColumnIndex("data2")) && this.isRequired("birthday", populate)) {
                        contact.put("birthday", (Object)c.getString(c.getColumnIndex("data1")));
                    }
                }
            }
            catch (JSONException e) {
                Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
            }
            oldContactId = contactId;
        }
        c.close();
        contacts.put((Object)this.populateContact(contact, organizations, addresses, phones, emails, ims, websites, relationships));
        long totalEnd = System.currentTimeMillis();
        Log.d((String)"ContactsAccessor", (String)("Total time = " + (totalEnd - totalStart)));
        return contacts;
    }

    private JSONObject populateContact(JSONObject contact, JSONArray organizations, JSONArray addresses, JSONArray phones, JSONArray emails, JSONArray ims, JSONArray websites, JSONArray relationships) {
        try {
            contact.put("organizations", (Object)organizations);
            contact.put("addresses", (Object)addresses);
            contact.put("phoneNumbers", (Object)phones);
            contact.put("emails", (Object)emails);
            contact.put("ims", (Object)ims);
            contact.put("websites", (Object)websites);
            contact.put("relationships", (Object)relationships);
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return contact;
    }

    private ContactAccessor.WhereOptions buildWhereClause(JSONArray fields, String searchTerm) {
        ArrayList<String> where = new ArrayList<String>();
        ArrayList<String> whereArgs = new ArrayList<String>();
        ContactAccessor.WhereOptions options = new ContactAccessor.WhereOptions();
        if ("%".equals(searchTerm)) {
            options.setWhere("(display_name LIKE ? )");
            options.setWhereArgs(new String[]{searchTerm});
            return options;
        }
        try {
            Log.d((String)"ContactsAccessor", (String)("How many fields do we have = " + fields.length()));
            for (int i = 0; i < fields.length(); ++i) {
                String key = fields.getString(i);
                if (key.startsWith("displayName")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? )");
                    whereArgs.add(searchTerm);
                    continue;
                }
                if (key.startsWith("name")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/name");
                    continue;
                }
                if (key.startsWith("nickname")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/nickname");
                    continue;
                }
                if (key.startsWith("phoneNumbers")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/phone_v2");
                    continue;
                }
                if (key.startsWith("emails")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/email_v2");
                    continue;
                }
                if (key.startsWith("addresses")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/postal-address_v2");
                    continue;
                }
                if (key.startsWith("ims")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/im");
                    continue;
                }
                if (key.startsWith("organizations")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/organization");
                    continue;
                }
                if (key.startsWith("note")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/note");
                    continue;
                }
                if (key.startsWith("relationships")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/relation");
                    continue;
                }
                if (!key.startsWith("urls")) continue;
                where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                whereArgs.add(searchTerm);
                whereArgs.add("vnd.android.cursor.item/website");
            }
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        StringBuffer selection = new StringBuffer();
        for (int i = 0; i < where.size(); ++i) {
            selection.append((String)where.get(i));
            if (i == where.size() - 1) continue;
            selection.append(" OR ");
        }
        options.setWhere(selection.toString());
        Log.d((String)"ContactsAccessor", (String)"The where clause is:");
        Log.d((String)"ContactsAccessor", (String)selection.toString());
        String[] selectionArgs = new String[whereArgs.size()];
        for (int i = 0; i < whereArgs.size(); ++i) {
            selectionArgs[i] = (String)whereArgs.get(i);
        }
        options.setWhereArgs(selectionArgs);
        return options;
    }

    private JSONObject organizationQuery(Cursor cursor) {
        JSONObject organization = new JSONObject();
        try {
            organization.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            organization.put("department", (Object)cursor.getString(cursor.getColumnIndex("data5")));
            organization.put("description", (Object)cursor.getString(cursor.getColumnIndex("data6")));
            organization.put("location", (Object)cursor.getString(cursor.getColumnIndex("data9")));
            organization.put("name", (Object)cursor.getString(cursor.getColumnIndex("data1")));
            organization.put("title", (Object)cursor.getString(cursor.getColumnIndex("data4")));
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return organization;
    }

    private JSONObject addressQuery(Cursor cursor) {
        JSONObject address = new JSONObject();
        try {
            address.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            address.put("formatted", (Object)cursor.getString(cursor.getColumnIndex("data1")));
            address.put("streetAddress", (Object)cursor.getString(cursor.getColumnIndex("data4")));
            address.put("locality", (Object)cursor.getString(cursor.getColumnIndex("data7")));
            address.put("region", (Object)cursor.getString(cursor.getColumnIndex("data8")));
            address.put("postalCode", (Object)cursor.getString(cursor.getColumnIndex("data9")));
            address.put("country", (Object)cursor.getString(cursor.getColumnIndex("data10")));
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return address;
    }

    private JSONObject nameQuery(Cursor cursor) {
        JSONObject contactName = new JSONObject();
        try {
            String familyName = cursor.getString(cursor.getColumnIndex("data3"));
            String givenName = cursor.getString(cursor.getColumnIndex("data2"));
            String middleName = cursor.getString(cursor.getColumnIndex("data5"));
            String honorificPrefix = cursor.getString(cursor.getColumnIndex("data4"));
            String honorificSuffix = cursor.getString(cursor.getColumnIndex("data6"));
            StringBuffer formatted = new StringBuffer("");
            if (honorificPrefix != null) {
                formatted.append(honorificPrefix + " ");
            }
            if (givenName != null) {
                formatted.append(givenName + " ");
            }
            if (middleName != null) {
                formatted.append(middleName + " ");
            }
            if (familyName != null) {
                formatted.append(familyName + " ");
            }
            if (honorificSuffix != null) {
                formatted.append(honorificSuffix + " ");
            }
            contactName.put("familyName", (Object)familyName);
            contactName.put("givenName", (Object)givenName);
            contactName.put("middleName", (Object)middleName);
            contactName.put("honorificPrefix", (Object)honorificPrefix);
            contactName.put("honorificSuffix", (Object)honorificSuffix);
            contactName.put("formatted", (Object)formatted);
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return contactName;
    }

    private JSONObject phoneQuery(Cursor cursor) {
        JSONObject phoneNumber = new JSONObject();
        try {
            phoneNumber.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            phoneNumber.put("primary", false);
            phoneNumber.put("value", (Object)cursor.getString(cursor.getColumnIndex("data1")));
            phoneNumber.put("type", (Object)this.getPhoneType(cursor.getInt(cursor.getColumnIndex("data2"))));
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        catch (Exception excp) {
            Log.e((String)"ContactsAccessor", (String)excp.getMessage(), (Throwable)excp);
        }
        return phoneNumber;
    }

    private JSONObject emailQuery(Cursor cursor) {
        JSONObject email = new JSONObject();
        try {
            email.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            email.put("primary", false);
            email.put("value", (Object)cursor.getString(cursor.getColumnIndex("data1")));
            email.put("type", (Object)this.getContactType(cursor.getInt(cursor.getColumnIndex("data2"))));
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return email;
    }

    private JSONObject imQuery(Cursor cursor) {
        JSONObject im = new JSONObject();
        try {
            im.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            im.put("primary", false);
            im.put("value", (Object)cursor.getString(cursor.getColumnIndex("data1")));
            im.put("type", (Object)this.getContactType(cursor.getInt(cursor.getColumnIndex("data2"))));
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return im;
    }

    private JSONObject websiteQuery(Cursor cursor) {
        JSONObject website = new JSONObject();
        try {
            website.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            website.put("primary", false);
            website.put("value", (Object)cursor.getString(cursor.getColumnIndex("data1")));
            website.put("type", (Object)this.getContactType(cursor.getInt(cursor.getColumnIndex("data2"))));
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return website;
    }

    private JSONObject relationshipQuery(Cursor cursor) {
        JSONObject relationship = new JSONObject();
        try {
            relationship.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            relationship.put("primary", false);
            relationship.put("value", (Object)cursor.getString(cursor.getColumnIndex("data1")));
            relationship.put("type", (Object)this.getRelationshipType(cursor.getInt(cursor.getColumnIndex("data2"))));
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return relationship;
    }

    @Override
    public boolean save(JSONObject contact) {
        AccountManager mgr = AccountManager.get((Context)this.mApp);
        Account[] accounts = mgr.getAccounts();
        if (accounts.length < 1) {
            return false;
        }
        String id = this.getJsonString(contact, "id");
        if (id == null) {
            return this.createNewContact(contact, accounts[0]);
        }
        return this.modifyContact(id, contact, accounts[0]);
    }

    private boolean modifyContact(String id, JSONObject contact, Account account) {
        String anniversary;
        int rawId = new Integer(this.getJsonString(contact, "rawId"));
        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.RawContacts.CONTENT_URI).withValue("account_type", (Object)account.type).withValue("account_name", (Object)account.name).build());
        String displayName = this.getJsonString(contact, "displayName");
        if (displayName != null) {
            ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("contact_id=? AND mimetype=?", new String[]{id, "vnd.android.cursor.item/name"}).withValue("data1", (Object)this.getJsonString(contact, "displayName")).build());
        }
        try {
            JSONObject name = contact.getJSONObject("name");
            if (name != null) {
                String honorificSuffix;
                String honorificPrefix;
                String givenName;
                String middleName;
                ContentProviderOperation.Builder builder = ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("contact_id=? AND mimetype=?", new String[]{id, "vnd.android.cursor.item/name"});
                String familyName = this.getJsonString(name, "familyName");
                if (familyName != null) {
                    builder.withValue("data3", (Object)familyName);
                }
                if ((middleName = this.getJsonString(name, "familyName")) != null) {
                    builder.withValue("data5", (Object)middleName);
                }
                if ((givenName = this.getJsonString(name, "givenName")) != null) {
                    builder.withValue("data2", (Object)givenName);
                }
                if ((honorificPrefix = this.getJsonString(name, "honorificPrefix")) != null) {
                    builder.withValue("data4", (Object)honorificPrefix);
                }
                if ((honorificSuffix = this.getJsonString(name, "honorificSuffix")) != null) {
                    builder.withValue("data6", (Object)honorificSuffix);
                }
                ops.add(builder.build());
            }
        }
        catch (JSONException e1) {
            Log.d((String)"ContactsAccessor", (String)"Could not get name");
        }
        JSONArray phones = null;
        try {
            phones = contact.getJSONArray("phoneNumbers");
            if (phones != null) {
                for (int i = 0; i < phones.length(); ++i) {
                    JSONObject phone = (JSONObject)phones.get(i);
                    String phoneId = this.getJsonString(phone, "id");
                    if (phoneId == null) {
                        ContentValues contentValues = new ContentValues();
                        contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                        contentValues.put("mimetype", "vnd.android.cursor.item/phone_v2");
                        contentValues.put("data1", this.getJsonString(phone, "value"));
                        contentValues.put("data2", Integer.valueOf(this.getPhoneType(this.getJsonString(phone, "type"))));
                        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                        continue;
                    }
                    ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{phoneId, "vnd.android.cursor.item/phone_v2"}).withValue("data1", (Object)this.getJsonString(phone, "value")).withValue("data2", (Object)this.getPhoneType(this.getJsonString(phone, "type"))).build());
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get phone numbers");
        }
        JSONArray emails = null;
        try {
            emails = contact.getJSONArray("emails");
            if (emails != null) {
                for (int i = 0; i < emails.length(); ++i) {
                    JSONObject email = (JSONObject)emails.get(i);
                    String emailId = this.getJsonString(email, "id");
                    if (emailId == null) {
                        ContentValues contentValues = new ContentValues();
                        contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                        contentValues.put("mimetype", "vnd.android.cursor.item/email_v2");
                        contentValues.put("data1", this.getJsonString(email, "value"));
                        contentValues.put("data2", Integer.valueOf(this.getContactType(this.getJsonString(email, "type"))));
                        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                        continue;
                    }
                    ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{emailId, "vnd.android.cursor.item/email_v2"}).withValue("data1", (Object)this.getJsonString(email, "value")).withValue("data2", (Object)this.getContactType(this.getJsonString(email, "type"))).build());
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get emails");
        }
        JSONArray addresses = null;
        try {
            addresses = contact.getJSONArray("addresses");
            if (addresses != null) {
                for (int i = 0; i < addresses.length(); ++i) {
                    JSONObject address = (JSONObject)addresses.get(i);
                    String addressId = this.getJsonString(address, "id");
                    if (addressId == null) {
                        ContentValues contentValues = new ContentValues();
                        contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                        contentValues.put("mimetype", "vnd.android.cursor.item/postal-address_v2");
                        contentValues.put("data1", this.getJsonString(address, "formatted"));
                        contentValues.put("data4", this.getJsonString(address, "streetAddress"));
                        contentValues.put("data7", this.getJsonString(address, "locality"));
                        contentValues.put("data8", this.getJsonString(address, "region"));
                        contentValues.put("data9", this.getJsonString(address, "postalCode"));
                        contentValues.put("data10", this.getJsonString(address, "country"));
                        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                        continue;
                    }
                    ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{addressId, "vnd.android.cursor.item/postal-address_v2"}).withValue("data1", (Object)this.getJsonString(address, "formatted")).withValue("data4", (Object)this.getJsonString(address, "streetAddress")).withValue("data7", (Object)this.getJsonString(address, "locality")).withValue("data8", (Object)this.getJsonString(address, "region")).withValue("data9", (Object)this.getJsonString(address, "postalCode")).withValue("data10", (Object)this.getJsonString(address, "country")).build());
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get addresses");
        }
        JSONArray organizations = null;
        try {
            organizations = contact.getJSONArray("organizations");
            if (organizations != null) {
                for (int i = 0; i < organizations.length(); ++i) {
                    JSONObject org = (JSONObject)organizations.get(i);
                    String orgId = this.getJsonString(org, "id");
                    if (orgId == null) {
                        ContentValues contentValues = new ContentValues();
                        contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                        contentValues.put("mimetype", "vnd.android.cursor.item/organization");
                        contentValues.put("data5", this.getJsonString(org, "department"));
                        contentValues.put("data6", this.getJsonString(org, "description"));
                        contentValues.put("data9", this.getJsonString(org, "location"));
                        contentValues.put("data1", this.getJsonString(org, "name"));
                        contentValues.put("data4", this.getJsonString(org, "title"));
                        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                        continue;
                    }
                    ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{orgId, "vnd.android.cursor.item/organization"}).withValue("data5", (Object)this.getJsonString(org, "department")).withValue("data6", (Object)this.getJsonString(org, "description")).withValue("data9", (Object)this.getJsonString(org, "location")).withValue("data1", (Object)this.getJsonString(org, "name")).withValue("data4", (Object)this.getJsonString(org, "title")).build());
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get organizations");
        }
        JSONArray ims = null;
        try {
            ims = contact.getJSONArray("ims");
            if (ims != null) {
                for (int i = 0; i < ims.length(); ++i) {
                    JSONObject im = (JSONObject)ims.get(i);
                    String imId = this.getJsonString(im, "id");
                    if (imId == null) {
                        ContentValues contentValues = new ContentValues();
                        contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                        contentValues.put("mimetype", "vnd.android.cursor.item/im");
                        contentValues.put("data1", this.getJsonString(im, "value"));
                        contentValues.put("data2", Integer.valueOf(this.getContactType(this.getJsonString(im, "type"))));
                        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                        continue;
                    }
                    ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{imId, "vnd.android.cursor.item/im"}).withValue("data1", (Object)this.getJsonString(im, "value")).withValue("data2", (Object)this.getContactType(this.getJsonString(im, "type"))).build());
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get emails");
        }
        String note = this.getJsonString(contact, "note");
        ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("contact_id=? AND mimetype=?", new String[]{id, "vnd.android.cursor.item/note"}).withValue("data1", (Object)note).build());
        String nickname = this.getJsonString(contact, "nickname");
        if (nickname != null) {
            ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("contact_id=? AND mimetype=?", new String[]{id, "vnd.android.cursor.item/nickname"}).withValue("data1", (Object)nickname).build());
        }
        JSONArray websites = null;
        try {
            websites = contact.getJSONArray("websites");
            if (websites != null) {
                for (int i = 0; i < websites.length(); ++i) {
                    JSONObject website = (JSONObject)websites.get(i);
                    String websiteId = this.getJsonString(website, "id");
                    if (websiteId == null) {
                        ContentValues contentValues = new ContentValues();
                        contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                        contentValues.put("mimetype", "vnd.android.cursor.item/website");
                        contentValues.put("data1", this.getJsonString(website, "value"));
                        contentValues.put("data2", Integer.valueOf(this.getContactType(this.getJsonString(website, "type"))));
                        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                        continue;
                    }
                    ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{websiteId, "vnd.android.cursor.item/website"}).withValue("data1", (Object)this.getJsonString(website, "value")).withValue("data2", (Object)this.getContactType(this.getJsonString(website, "type"))).build());
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get websites");
        }
        JSONArray relationships = null;
        try {
            relationships = contact.getJSONArray("relationships");
            if (relationships != null) {
                for (int i = 0; i < relationships.length(); ++i) {
                    JSONObject relationship = (JSONObject)relationships.get(i);
                    String relationshipId = this.getJsonString(relationship, "id");
                    if (relationshipId == null) {
                        ContentValues contentValues = new ContentValues();
                        contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                        contentValues.put("mimetype", "vnd.android.cursor.item/relation");
                        contentValues.put("data1", this.getJsonString(relationship, "name"));
                        contentValues.put("data2", Integer.valueOf(this.getRelationshipType(this.getJsonString(relationship, "type"))));
                        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                        continue;
                    }
                    ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{relationshipId, "vnd.android.cursor.item/relation"}).withValue("data1", (Object)this.getJsonString(relationship, "value")).withValue("data2", (Object)this.getRelationshipType(this.getJsonString(relationship, "type"))).build());
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get relationships");
        }
        String birthday = this.getJsonString(contact, "birthday");
        if (birthday != null) {
            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withSelection("contact_id=? AND mimetype=? AND data2=?", new String[]{id, "vnd.android.cursor.item/contact_event", new String("3")}).withValue("data2", (Object)3).withValue("data1", (Object)birthday).build());
        }
        if ((anniversary = this.getJsonString(contact, "anniversary")) != null) {
            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withSelection("contact_id=? AND mimetype=? AND data2=?", new String[]{id, "vnd.android.cursor.item/contact_event", new String("1")}).withValue("data2", (Object)1).withValue("data1", (Object)anniversary).build());
        }
        boolean retVal = true;
        try {
            this.mApp.getContentResolver().applyBatch("com.android.contacts", ops);
        }
        catch (RemoteException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
            Log.e((String)"ContactsAccessor", (String)Log.getStackTraceString((Throwable)e), (Throwable)e);
            retVal = false;
        }
        catch (OperationApplicationException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
            Log.e((String)"ContactsAccessor", (String)Log.getStackTraceString((Throwable)e), (Throwable)e);
            retVal = false;
        }
        return retVal;
    }

    private void insertRelationship(ArrayList<ContentProviderOperation> ops, JSONObject relationship) {
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/relation").withValue("data1", (Object)this.getJsonString(relationship, "value")).withValue("data2", (Object)this.getRelationshipType(this.getJsonString(relationship, "type"))).build());
    }

    private void insertWebsite(ArrayList<ContentProviderOperation> ops, JSONObject website) {
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/website").withValue("data1", (Object)this.getJsonString(website, "value")).withValue("data2", (Object)this.getContactType(this.getJsonString(website, "type"))).build());
    }

    private void insertIm(ArrayList<ContentProviderOperation> ops, JSONObject im) {
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/im").withValue("data1", (Object)this.getJsonString(im, "value")).withValue("data2", (Object)this.getContactType(this.getJsonString(im, "type"))).build());
    }

    private void insertOrganization(ArrayList<ContentProviderOperation> ops, JSONObject org) {
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/organization").withValue("data5", (Object)this.getJsonString(org, "department")).withValue("data6", (Object)this.getJsonString(org, "description")).withValue("data9", (Object)this.getJsonString(org, "location")).withValue("data1", (Object)this.getJsonString(org, "name")).withValue("data4", (Object)this.getJsonString(org, "title")).build());
    }

    private void insertAddress(ArrayList<ContentProviderOperation> ops, JSONObject address) {
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/postal-address_v2").withValue("data1", (Object)this.getJsonString(address, "formatted")).withValue("data4", (Object)this.getJsonString(address, "streetAddress")).withValue("data7", (Object)this.getJsonString(address, "locality")).withValue("data8", (Object)this.getJsonString(address, "region")).withValue("data9", (Object)this.getJsonString(address, "postalCode")).withValue("data10", (Object)this.getJsonString(address, "country")).build());
    }

    private void insertEmail(ArrayList<ContentProviderOperation> ops, JSONObject email) {
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/email_v2").withValue("data1", (Object)this.getJsonString(email, "value")).withValue("data2", (Object)this.getPhoneType(this.getJsonString(email, "type"))).build());
    }

    private void insertPhone(ArrayList<ContentProviderOperation> ops, JSONObject phone) {
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/phone_v2").withValue("data1", (Object)this.getJsonString(phone, "value")).withValue("data2", (Object)this.getPhoneType(this.getJsonString(phone, "type"))).build());
    }

    private boolean createNewContact(JSONObject contact, Account account) {
        String anniversary;
        String nickname;
        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.RawContacts.CONTENT_URI).withValue("account_type", (Object)account.type).withValue("account_name", (Object)account.name).build());
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/name").withValue("data1", (Object)this.getJsonString(contact, "displayName")).build());
        try {
            JSONObject name = contact.getJSONObject("name");
            if (name != null) {
                ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/name").withValue("data3", (Object)this.getJsonString(name, "familyName")).withValue("data5", (Object)this.getJsonString(name, "middleName")).withValue("data2", (Object)this.getJsonString(name, "givenName")).withValue("data4", (Object)this.getJsonString(name, "honorificPrefix")).withValue("data6", (Object)this.getJsonString(name, "honorificSuffix")).build());
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get name object");
        }
        JSONArray phones = null;
        try {
            phones = contact.getJSONArray("phoneNumbers");
            if (phones != null) {
                for (int i = 0; i < phones.length(); ++i) {
                    JSONObject phone = (JSONObject)phones.get(i);
                    this.insertPhone(ops, phone);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get phone numbers");
        }
        JSONArray emails = null;
        try {
            emails = contact.getJSONArray("emails");
            if (emails != null) {
                for (int i = 0; i < emails.length(); ++i) {
                    JSONObject email = (JSONObject)emails.get(i);
                    this.insertEmail(ops, email);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get emails");
        }
        JSONArray addresses = null;
        try {
            addresses = contact.getJSONArray("addresses");
            if (addresses != null) {
                for (int i = 0; i < addresses.length(); ++i) {
                    JSONObject address = (JSONObject)addresses.get(i);
                    this.insertAddress(ops, address);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get addresses");
        }
        JSONArray organizations = null;
        try {
            organizations = contact.getJSONArray("organizations");
            if (organizations != null) {
                for (int i = 0; i < organizations.length(); ++i) {
                    JSONObject org = (JSONObject)organizations.get(i);
                    this.insertOrganization(ops, org);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get organizations");
        }
        JSONArray ims = null;
        try {
            ims = contact.getJSONArray("ims");
            if (ims != null) {
                for (int i = 0; i < ims.length(); ++i) {
                    JSONObject im = (JSONObject)ims.get(i);
                    this.insertIm(ops, im);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get emails");
        }
        String note = this.getJsonString(contact, "note");
        if (note != null) {
            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/note").withValue("data1", (Object)note).build());
        }
        if ((nickname = this.getJsonString(contact, "nickname")) != null) {
            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/nickname").withValue("data1", (Object)nickname).build());
        }
        JSONArray websites = null;
        try {
            websites = contact.getJSONArray("websites");
            if (websites != null) {
                for (int i = 0; i < websites.length(); ++i) {
                    JSONObject website = (JSONObject)websites.get(i);
                    this.insertWebsite(ops, website);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get websites");
        }
        JSONArray relationships = null;
        try {
            relationships = contact.getJSONArray("relationships");
            if (relationships != null) {
                for (int i = 0; i < relationships.length(); ++i) {
                    JSONObject relationship = (JSONObject)relationships.get(i);
                    this.insertRelationship(ops, relationship);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get relationships");
        }
        String birthday = this.getJsonString(contact, "birthday");
        if (birthday != null) {
            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/contact_event").withValue("data2", (Object)3).withValue("data1", (Object)birthday).build());
        }
        if ((anniversary = this.getJsonString(contact, "anniversary")) != null) {
            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/contact_event").withValue("data2", (Object)1).withValue("data1", (Object)anniversary).build());
        }
        boolean retVal = true;
        try {
            this.mApp.getContentResolver().applyBatch("com.android.contacts", ops);
        }
        catch (RemoteException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
            retVal = false;
        }
        catch (OperationApplicationException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
            retVal = false;
        }
        return retVal;
    }

    @Override
    public boolean remove(String id) {
        int result = this.mApp.getContentResolver().delete(ContactsContract.Data.CONTENT_URI, "contact_id = ?", new String[]{id});
        return result > 0;
    }

    private int getPhoneType(String string) {
        int type = 7;
        if ("home".equals(string.toLowerCase())) {
            return 1;
        }
        if ("mobile".equals(string.toLowerCase())) {
            return 2;
        }
        if ("work".equals(string.toLowerCase())) {
            return 3;
        }
        if ("work fax".equals(string.toLowerCase())) {
            return 4;
        }
        if ("home fax".equals(string.toLowerCase())) {
            return 5;
        }
        if ("fax".equals(string.toLowerCase())) {
            return 4;
        }
        if ("pager".equals(string.toLowerCase())) {
            return 6;
        }
        if ("other".equals(string.toLowerCase())) {
            return 7;
        }
        if ("car".equals(string.toLowerCase())) {
            return 9;
        }
        if ("company main".equals(string.toLowerCase())) {
            return 10;
        }
        if ("isdn".equals(string.toLowerCase())) {
            return 11;
        }
        if ("main".equals(string.toLowerCase())) {
            return 12;
        }
        if ("other fax".equals(string.toLowerCase())) {
            return 13;
        }
        if ("radio".equals(string.toLowerCase())) {
            return 14;
        }
        if ("telex".equals(string.toLowerCase())) {
            return 15;
        }
        if ("work mobile".equals(string.toLowerCase())) {
            return 17;
        }
        if ("work pager".equals(string.toLowerCase())) {
            return 18;
        }
        if ("assistant".equals(string.toLowerCase())) {
            return 19;
        }
        if ("mms".equals(string.toLowerCase())) {
            return 20;
        }
        if ("callback".equals(string.toLowerCase())) {
            return 8;
        }
        if ("tty ttd".equals(string.toLowerCase())) {
            return 16;
        }
        if ("custom".equals(string.toLowerCase())) {
            return 0;
        }
        return type;
    }

    private String getPhoneType(int type) {
        String stringType;
        switch (type) {
            case 0: {
                stringType = "custom";
                break;
            }
            case 5: {
                stringType = "home fax";
                break;
            }
            case 4: {
                stringType = "work fax";
                break;
            }
            case 1: {
                stringType = "home";
                break;
            }
            case 2: {
                stringType = "mobile";
                break;
            }
            case 6: {
                stringType = "pager";
                break;
            }
            case 3: {
                stringType = "work";
                break;
            }
            case 8: {
                stringType = "callback";
                break;
            }
            case 9: {
                stringType = "car";
                break;
            }
            case 10: {
                stringType = "company main";
                break;
            }
            case 13: {
                stringType = "other fax";
                break;
            }
            case 14: {
                stringType = "radio";
                break;
            }
            case 15: {
                stringType = "telex";
                break;
            }
            case 16: {
                stringType = "tty tdd";
                break;
            }
            case 17: {
                stringType = "work mobile";
                break;
            }
            case 18: {
                stringType = "work pager";
                break;
            }
            case 19: {
                stringType = "assistant";
                break;
            }
            case 20: {
                stringType = "mms";
                break;
            }
            case 11: {
                stringType = "isdn";
                break;
            }
            default: {
                stringType = "other";
            }
        }
        return stringType;
    }

    private int getContactType(String string) {
        int type = 3;
        if (string != null) {
            if ("home".equals(string.toLowerCase())) {
                return 1;
            }
            if ("work".equals(string.toLowerCase())) {
                return 2;
            }
            if ("other".equals(string.toLowerCase())) {
                return 3;
            }
            if ("mobile".equals(string.toLowerCase())) {
                return 4;
            }
            if ("custom".equals(string.toLowerCase())) {
                return 0;
            }
        }
        return type;
    }

    private String getContactType(int type) {
        String stringType;
        switch (type) {
            case 0: {
                stringType = "custom";
                break;
            }
            case 1: {
                stringType = "home";
                break;
            }
            case 2: {
                stringType = "work";
                break;
            }
            case 4: {
                stringType = "mobile";
                break;
            }
            default: {
                stringType = "other";
            }
        }
        return stringType;
    }

    private int getRelationshipType(String string) {
        int type = 0;
        if (string != null) {
            if ("assistant".equals(string.toLowerCase())) {
                return 1;
            }
            if ("brother".equals(string.toLowerCase())) {
                return 2;
            }
            if ("child".equals(string.toLowerCase())) {
                return 3;
            }
            if ("domestic partner".equals(string.toLowerCase())) {
                return 4;
            }
            if ("father".equals(string.toLowerCase())) {
                return 5;
            }
            if ("friend".equals(string.toLowerCase())) {
                return 6;
            }
            if ("manager".equals(string.toLowerCase())) {
                return 7;
            }
            if ("mother".equals(string.toLowerCase())) {
                return 8;
            }
            if ("parent".equals(string.toLowerCase())) {
                return 9;
            }
            if ("partner".equals(string.toLowerCase())) {
                return 10;
            }
            if ("referred by".equals(string.toLowerCase())) {
                return 11;
            }
            if ("relative".equals(string.toLowerCase())) {
                return 12;
            }
            if ("sister".equals(string.toLowerCase())) {
                return 13;
            }
            if ("spouse".equals(string.toLowerCase())) {
                return 14;
            }
            if ("custom".equals(string.toLowerCase())) {
                return 0;
            }
        }
        return type;
    }

    private String getRelationshipType(int type) {
        String stringType;
        switch (type) {
            case 1: {
                stringType = "assistant";
                break;
            }
            case 2: {
                stringType = "brother";
                break;
            }
            case 3: {
                stringType = "child";
                break;
            }
            case 4: {
                stringType = "domestic partner";
                break;
            }
            case 5: {
                stringType = "father";
                break;
            }
            case 6: {
                stringType = "friend";
                break;
            }
            case 7: {
                stringType = "manager";
                break;
            }
            case 8: {
                stringType = "mother";
                break;
            }
            case 9: {
                stringType = "parent";
                break;
            }
            case 10: {
                stringType = "partner";
                break;
            }
            case 11: {
                stringType = "referred by";
                break;
            }
            case 12: {
                stringType = "relative";
                break;
            }
            case 13: {
                stringType = "sister";
                break;
            }
            case 14: {
                stringType = "spouse";
                break;
            }
            default: {
                stringType = "custom";
            }
        }
        return stringType;
    }

    static {
        dbMap.put("id", "_id");
        dbMap.put("displayName", "display_name");
        dbMap.put("name", "data1");
        dbMap.put("name.formatted", "data1");
        dbMap.put("name.familyName", "data3");
        dbMap.put("name.givenName", "data2");
        dbMap.put("name.middleName", "data5");
        dbMap.put("name.honorificPrefix", "data4");
        dbMap.put("name.honorificSuffix", "data6");
        dbMap.put("nickname", "data1");
        dbMap.put("phoneNumbers", "data1");
        dbMap.put("phoneNumbers.value", "data1");
        dbMap.put("emails", "data1");
        dbMap.put("emails.value", "data1");
        dbMap.put("addresses", "data1");
        dbMap.put("addresses.formatted", "data1");
        dbMap.put("addresses.streetAddress", "data4");
        dbMap.put("addresses.locality", "data7");
        dbMap.put("addresses.region", "data8");
        dbMap.put("addresses.postalCode", "data9");
        dbMap.put("addresses.country", "data10");
        dbMap.put("ims", "data1");
        dbMap.put("ims.value", "data1");
        dbMap.put("organizations", "data1");
        dbMap.put("organizations.name", "data1");
        dbMap.put("organizations.department", "data5");
        dbMap.put("organizations.title", "data4");
        dbMap.put("organizations.location", "data9");
        dbMap.put("organizations.description", "data6");
        dbMap.put("birthday", "vnd.android.cursor.item/contact_event");
        dbMap.put("anniversary", "vnd.android.cursor.item/contact_event");
        dbMap.put("note", "data1");
        dbMap.put("relationships", "data1");
        dbMap.put("relationships.value", "data1");
        dbMap.put("urls", "data1");
        dbMap.put("urls.value", "data1");
    }
}

