/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONException;

public class CameraLauncher
extends Plugin {
    private static final int DATA_URL = 0;
    private static final int FILE_URI = 1;
    private static final int PHOTOLIBRARY = 0;
    private static final int CAMERA = 1;
    private static final int SAVEDPHOTOALBUM = 2;
    private int mQuality;
    private Uri imageUri;
    public String callbackId;

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        this.callbackId = callbackId;
        try {
            if (action.equals("takePicture")) {
                int destType = 0;
                if (args.length() > 1) {
                    destType = args.getInt(1);
                }
                int srcType = 1;
                if (args.length() > 2) {
                    srcType = args.getInt(2);
                }
                if (srcType == 1) {
                    this.takePicture(args.getInt(0), destType);
                } else if (srcType == 0 || srcType == 2) {
                    this.getImage(args.getInt(0), srcType, destType);
                }
                PluginResult r = new PluginResult(PluginResult.Status.NO_RESULT);
                r.setKeepCallback(true);
                return r;
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public void takePicture(int quality, int returnType) {
        this.mQuality = quality;
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        File photo = new File(Environment.getExternalStorageDirectory(), "Pic.jpg");
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)photo));
        this.imageUri = Uri.fromFile((File)photo);
        this.ctx.startActivityForResult(this, intent, 32 + returnType + 1);
    }

    public void getImage(int quality, int srcType, int returnType) {
        this.mQuality = quality;
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        this.ctx.startActivityForResult(this, Intent.createChooser((Intent)intent, (CharSequence)new String("Get Picture")), (srcType + 1) * 16 + returnType + 1);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        block23: {
            int srcType = requestCode / 16 - 1;
            int destType = requestCode % 16 - 1;
            if (srcType == 1) {
                if (resultCode == -1) {
                    try {
                        Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.ctx.getContentResolver(), (Uri)this.imageUri);
                        if (destType == 0) {
                            this.processPicture(bitmap);
                            break block23;
                        }
                        if (destType != 1) break block23;
                        ContentValues values = new ContentValues();
                        values.put("mime_type", "image/jpeg");
                        Uri uri = null;
                        try {
                            uri = this.ctx.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
                        }
                        catch (UnsupportedOperationException e) {
                            System.out.println("Can't write to external media storage.");
                            try {
                                uri = this.ctx.getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, values);
                            }
                            catch (UnsupportedOperationException ex) {
                                System.out.println("Can't write to internal media storage.");
                                this.failPicture("Error capturing image - no media storage found.");
                                return;
                            }
                        }
                        OutputStream os = this.ctx.getContentResolver().openOutputStream(uri);
                        bitmap.compress(Bitmap.CompressFormat.JPEG, this.mQuality, os);
                        os.close();
                        this.success(new PluginResult(PluginResult.Status.OK, uri.toString()), this.callbackId);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.failPicture("Error capturing image.");
                    }
                } else if (resultCode == 0) {
                    this.failPicture("Camera cancelled.");
                } else {
                    this.failPicture("Did not complete!");
                }
            } else if (srcType == 0 || srcType == 2) {
                if (resultCode == -1) {
                    Uri uri = intent.getData();
                    ContentResolver resolver = this.ctx.getContentResolver();
                    if (destType == 0) {
                        try {
                            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)resolver.openInputStream(uri));
                            this.processPicture(bitmap);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            this.failPicture("Error retrieving image.");
                        }
                    } else if (destType == 1) {
                        this.success(new PluginResult(PluginResult.Status.OK, uri.toString()), this.callbackId);
                    }
                } else if (resultCode == 0) {
                    this.failPicture("Selection cancelled.");
                } else {
                    this.failPicture("Selection did not complete!");
                }
            }
        }
    }

    public void processPicture(Bitmap bitmap) {
        ByteArrayOutputStream jpeg_data = new ByteArrayOutputStream();
        try {
            if (bitmap.compress(Bitmap.CompressFormat.JPEG, this.mQuality, (OutputStream)jpeg_data)) {
                byte[] code = jpeg_data.toByteArray();
                byte[] output = Base64.encodeBase64((byte[])code);
                String js_out = new String(output);
                this.success(new PluginResult(PluginResult.Status.OK, js_out), this.callbackId);
            }
        }
        catch (Exception e) {
            this.failPicture("Error compressing image.");
        }
    }

    public void failPicture(String err) {
        this.error(new PluginResult(PluginResult.Status.ERROR, err), this.callbackId);
    }
}

