/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.net.Proxy;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.UUID;

public class CallbackServer
implements Runnable {
    private LinkedList<String> javascript = new LinkedList();
    private int port = 0;
    private Thread serverThread;
    private boolean active = false;
    private boolean empty = true;
    private boolean usePolling;
    private String token;

    public void init(String url) {
        if (url != null && !url.startsWith("file://")) {
            this.usePolling = true;
            this.stopServer();
        } else if (Proxy.getDefaultHost() != null) {
            this.usePolling = true;
            this.stopServer();
        } else {
            this.usePolling = false;
            this.startServer();
        }
    }

    public boolean usePolling() {
        return this.usePolling;
    }

    public int getPort() {
        return this.port;
    }

    public String getToken() {
        return this.token;
    }

    public void startServer() {
        this.active = false;
        this.serverThread = new Thread(this);
        this.serverThread.start();
    }

    public void restartServer() {
        this.stopServer();
        this.startServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.active = true;
            ServerSocket waitSocket = new ServerSocket(0);
            this.port = waitSocket.getLocalPort();
            this.token = UUID.randomUUID().toString();
            while (this.active) {
                Socket connection = waitSocket.accept();
                BufferedReader xhrReader = new BufferedReader(new InputStreamReader(connection.getInputStream()), 40);
                DataOutputStream output = new DataOutputStream(connection.getOutputStream());
                String request = xhrReader.readLine();
                String response = "";
                if (request.contains("GET")) {
                    if (request.substring(5, 41).equals(this.token)) {
                        CallbackServer callbackServer = this;
                        synchronized (callbackServer) {
                            while (this.empty) {
                                try {
                                    this.wait(10000L);
                                    break;
                                }
                                catch (Exception e) {
                                }
                            }
                        }
                        response = this.active ? (this.empty ? "HTTP/1.1 404 NO DATA\r\n\r\n " : "HTTP/1.1 200 OK\r\n\r\n" + this.getJavascript()) : "HTTP/1.1 503 Service Unavailable\r\n\r\n ";
                    } else {
                        response = "HTTP/1.1 403 Forbidden\r\n\r\n ";
                    }
                } else {
                    response = "HTTP/1.1 400 Bad Request\r\n\r\n ";
                }
                output.writeBytes(response);
                output.flush();
                output.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        if (this.active) {
            this.active = false;
            CallbackServer callbackServer = this;
            synchronized (callbackServer) {
                this.notify();
            }
        }
    }

    public void destroy() {
        this.stopServer();
    }

    public int getSize() {
        int size = this.javascript.size();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJavascript() {
        if (this.javascript.size() == 0) {
            return null;
        }
        String statement = this.javascript.remove(0);
        if (this.javascript.size() == 0) {
            CallbackServer callbackServer = this;
            synchronized (callbackServer) {
                this.empty = true;
            }
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendJavascript(String statement) {
        this.javascript.add(statement);
        CallbackServer callbackServer = this;
        synchronized (callbackServer) {
            this.empty = false;
            this.notify();
        }
    }
}

