/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import com.phonegap.DroidGap;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class App
extends Plugin {
    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("clearCache")) {
                this.clearCache();
            } else if (action.equals("loadUrl")) {
                this.loadUrl(args.getString(0), args.optJSONObject(1));
            } else if (action.equals("cancelLoadUrl")) {
                this.cancelLoadUrl();
            } else if (action.equals("clearHistory")) {
                this.clearHistory();
            } else if (action.equals("addService")) {
                this.addService(args.getString(0), args.getString(1));
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public void clearCache() {
        ((DroidGap)this.ctx).clearCache();
    }

    public void loadUrl(String url, JSONObject props) throws JSONException {
        System.out.println("App.loadUrl(" + url + "," + props + ")");
        int wait = 0;
        if (props != null) {
            JSONArray keys = props.names();
            for (int i = 0; i < keys.length(); ++i) {
                String key = keys.getString(i);
                if (key.equals("wait")) {
                    wait = props.getInt(key);
                    continue;
                }
                Object value = props.get(key);
                if (value == null) continue;
                if (value.getClass().equals(String.class)) {
                    this.ctx.getIntent().putExtra(key, (String)value);
                    continue;
                }
                if (value.getClass().equals(Boolean.class)) {
                    this.ctx.getIntent().putExtra(key, (Serializable)((Boolean)value));
                    continue;
                }
                if (!value.getClass().equals(Integer.class)) continue;
                this.ctx.getIntent().putExtra(key, (Serializable)((Integer)value));
            }
        }
        if (wait > 0) {
            ((DroidGap)this.ctx).loadUrl(url, wait);
        } else {
            ((DroidGap)this.ctx).loadUrl(url);
        }
    }

    public void cancelLoadUrl() {
        ((DroidGap)this.ctx).cancelLoadUrl();
    }

    public void clearHistory() {
        ((DroidGap)this.ctx).clearHistory();
    }

    public void addService(String serviceType, String className) {
        this.ctx.addService(serviceType, className);
    }
}

