package de.wartala.meinevideos;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.hibernate.validator.NotNull;
import org.trails.descriptor.annotation.Collection;
import org.trails.descriptor.annotation.PropertyDescriptor;
import org.trails.validation.ValidateUniqueness;

@Entity
@ValidateUniqueness(property="title")
public class Movie {
    private Integer id;
    private String title;
    private Integer year;
    private Set<Actor> actors = new HashSet<Actor>();
  
    @PropertyDescriptor(index=0)
    @Id(generate=GeneratorType.AUTO)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @PropertyDescriptor(index=1)
    @NotNull
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @PropertyDescriptor(index=2)
    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }
    
    @PropertyDescriptor(index=3)
    @OneToMany(cascade=CascadeType.ALL)
    @JoinColumn(name="movieId")
    @Collection(child=true)
    public Set<Actor> getActors()
    {
        return actors;
    }

    public void setActors(Set<Actor> actors)
    {
        this.actors = actors;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
    
    public String toString() {
        return this.getTitle();
    }
}
